/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class BooleanNumericInput
extends ADataInput {
    private Button bbuton;
    private Spinner num;
    private int min;
    private int max;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return true;
    }

    @Override
    public void createInput(Composite parent, final IParameter param, final Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (Number.class.isAssignableFrom(param.getValueClass())) {
            this.min = 0;
            this.max = Integer.MAX_VALUE;
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            this.bbuton = new Button(container, 32);
            this.bbuton.setText("Limit the number of records to");
            this.num = new Spinner(container, 2048);
            this.num.addFocusListener(this.focusListener);
            this.num.addTraverseListener(this.keyListener);
            this.num.setToolTipText(VParameters.createToolTip(param));
            this.updateInput();
            SelectionAdapter adapter1 = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!BooleanNumericInput.this.bbuton.getSelection()) {
                        params.remove(param.getName());
                        BooleanNumericInput.this.num.setEnabled(false);
                    } else {
                        Number n = BooleanNumericInput.this.getNumber();
                        BooleanNumericInput.this.updateModel(n);
                        BooleanNumericInput.this.num.setEnabled(true);
                    }
                    BooleanNumericInput.this.setDecoratorNullable(param);
                }
            };
            this.bbuton.addSelectionListener((SelectionListener)adapter1);
            ModifyListener listener2 = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BooleanNumericInput.this.num.removeModifyListener((ModifyListener)this);
                    BooleanNumericInput.this.textModifyEvent();
                    BooleanNumericInput.this.num.addModifyListener((ModifyListener)this);
                }
            };
            this.num.addModifyListener(listener2);
            if (param.getMinValue() != null) {
                int minval = new Integer(param.getMinValue());
                if (!param.isStrictMin()) {
                    ++minval;
                }
                this.num.setMinimum(minval);
                this.min = minval;
            }
            if (param.getMaxValue() != null) {
                int maxval = new Integer(param.getMaxValue());
                if (!param.isStrictMax()) {
                    --maxval;
                }
                this.num.setMaximum(maxval);
                this.max = maxval;
            }
            GridData gd = new GridData(768);
            gd.horizontalIndent = 2;
            gd.widthHint = 40;
            this.num.setLayoutData((Object)gd);
            BooleanNumericInput.setMandatory(param, (Control)this.num);
            this.setNullable(param, (Control)this.bbuton);
        }
    }

    private Number getNumber() {
        Number n = null;
        String text = this.num.getText();
        if (!text.trim().isEmpty()) {
            if (this.param.getValueClass().equals(Integer.class)) {
                n = new Integer(Misc.nvl((String)this.num.getText()));
            } else if (this.param.getValueClass().equals(Byte.class)) {
                n = new Byte(Misc.nvl((String)this.num.getText()));
            } else if (this.param.getValueClass().equals(Short.class)) {
                n = new Short(Misc.nvl((String)this.num.getText()));
            }
        }
        return n;
    }

    private void textModifyEvent() {
        Number n = this.getNumber();
        if (n != null) {
            this.updateModel(n);
        }
        this.updateInput();
    }

    protected int compareTo(Number n1, Number n2) {
        if (this.param.getValueClass().equals(Long.class)) {
            return ((Long)n1).compareTo((Long)n2);
        }
        if (this.param.getValueClass().equals(BigInteger.class)) {
            return ((BigInteger)n1).compareTo((BigInteger)n2);
        }
        if (this.param.getValueClass().equals(Float.class)) {
            return ((Float)n1).compareTo((Float)n2);
        }
        if (this.param.getValueClass().equals(Double.class)) {
            return ((Double)n1).compareTo((Double)n2);
        }
        if (this.param.getValueClass().equals(Integer.class)) {
            return ((Integer)n1).compareTo((Integer)n2);
        }
        if (this.param.getValueClass().equals(Short.class)) {
            return ((Short)n1).compareTo((Short)n2);
        }
        if (this.param.getValueClass().equals(Byte.class)) {
            return ((Byte)n1).compareTo((Byte)n2);
        }
        if (this.param.getValueClass().equals(BigDecimal.class)) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2);
        }
        return 0;
    }

    protected Number getNumber(String number) throws NumberFormatException {
        if (this.param.getValueClass().equals(Long.class)) {
            return new Long(number);
        }
        if (this.param.getValueClass().equals(BigInteger.class)) {
            return new BigInteger(number);
        }
        if (this.param.getValueClass().equals(Float.class)) {
            return new Float(number);
        }
        if (this.param.getValueClass().equals(Double.class)) {
            return new Double(number);
        }
        if (this.param.getValueClass().equals(Integer.class)) {
            return new Integer(number);
        }
        if (this.param.getValueClass().equals(Short.class)) {
            return new Short(number);
        }
        if (this.param.getValueClass().equals(Byte.class)) {
            return new Byte(number);
        }
        if (this.param.getValueClass().equals(BigDecimal.class)) {
            return new BigDecimal(number);
        }
        return null;
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            value = this.getNumber((String)value);
        }
        if (value != null && value instanceof Number) {
            if (!value.equals(this.getNumber())) {
                int val = ((Number)value).intValue();
                this.num.setValues(val, this.min, this.max, 0, 1, 10);
                this.num.setSelection(this.num.getText().length());
                this.bbuton.setSelection(true);
                this.num.setEnabled(true);
            }
        } else {
            this.bbuton.setSelection(false);
            this.num.setEnabled(false);
        }
        this.setDecoratorNullable(this.param);
    }
}

