/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.swt.widgets.DRDateTime;
import java.beans.PropertyChangeEvent;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.types.date.CalendarUnit;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import net.sf.jasperreports.types.date.DateRangeExpression;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;
import net.sf.jasperreports.types.date.TimestampRange;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DateInput
extends ADataInput {
    protected boolean supportDateRange;
    private static String[] namesOfDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    protected boolean isNumeric = false;
    protected CDateTime date;

    public DateInput() {
        this(false, true);
    }

    public DateInput(boolean isNumeric, boolean supportDateRange) {
        this.isNumeric = isNumeric;
        this.supportDateRange = supportDateRange;
    }

    @Override
    public boolean isForType(Class<?> valueClass) {
        return java.util.Date.class.isAssignableFrom(valueClass) || DateRange.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        Class<?> valueClass = param.getValueClass();
        if (Date.class.isAssignableFrom(valueClass)) {
            this.createDate(parent, param, params);
        } else if (Time.class.isAssignableFrom(valueClass)) {
            this.createTime(parent, param, params);
        } else if (Timestamp.class.isAssignableFrom(valueClass) || java.util.Date.class.isAssignableFrom(valueClass)) {
            this.createTimestamp(parent, param, params);
        } else if (TimestampRange.class.isAssignableFrom(valueClass)) {
            this.createTimestampRange(parent, param, params);
        } else if (DateRange.class.isAssignableFrom(valueClass)) {
            this.createDateRange(parent, param, params);
        }
        this.date.setToolTipText(VParameters.createToolTip(param));
        if (this.supportDateRange) {
            StringBuilder tt = new StringBuilder("Possible values to use as parameter:\n");
            String del = "";
            CalendarUnit[] calendarUnitArray = CalendarUnit.values();
            int n = calendarUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarUnit cu = calendarUnitArray[n2];
                tt.append(del);
                if (cu.equals((Object)CalendarUnit.WEEK)) {
                    DateRangeBuilder drb = new DateRangeBuilder("WEEK");
                    tt.append(String.valueOf(cu.name()) + "(" + namesOfDays[(Integer)Misc.nvl((Object)drb.getWeekStartDay(), (Object)2)] + ")");
                } else {
                    tt.append(cu.name());
                }
                del = ", ";
                ++n2;
            }
            this.date.setToolTipText(tt + "\n" + this.date.getToolTipText());
        }
        this.setNullable(param, (Control)this.date);
        this.date.addFocusListener(this.focusListener);
        this.date.addTraverseListener(this.keyListener);
    }

    @Override
    protected void handleFocusLost() {
        IStatusLineManager statusLineManager = this.getStatusLineManager();
        if (statusLineManager != null) {
            statusLineManager.setMessage(null);
        }
    }

    private void setFormat(CDateTime cDateTime, String key) {
        String f = Misc.nvl((String)this.getjConfig().getProperty(key));
        if (!Misc.isNullOrEmpty((String)f)) {
            cDateTime.setPattern(f);
        }
    }

    private void refresh() {
        if (this.date != null && !this.date.isDisposed()) {
            Class<?> valueClass = this.getParameter().getValueClass();
            if (TimestampRange.class.isAssignableFrom(valueClass)) {
                this.handleDateRangeChange(Timestamp.class);
            } else if (DateRange.class.isAssignableFrom(valueClass)) {
                this.handleDateRangeChange(java.util.Date.class);
            }
        }
    }

    protected void handleDateChanged() {
        java.util.Date sdate = this.date.getSelection();
        Date d = sdate != null ? new Date(sdate.getTime()) : null;
        this.updateModel(this.isNumeric && d != null ? Long.valueOf(d.getTime()) : d);
    }

    protected void handleTimestampChanged() {
        java.util.Date sdate = this.date.getSelection();
        Timestamp d = sdate != null ? new Timestamp(sdate.getTime()) : null;
        d.setNanos(0);
        this.updateModel(this.isNumeric && d != null ? Long.valueOf(d.getTime()) : d);
    }

    protected void handleTimeChanged() {
        java.util.Date sdate = this.date.getSelection();
        Time d = sdate != null ? new Time(sdate.getTime()) : null;
        this.updateModel(this.isNumeric && d != null ? Long.valueOf(d.getTime()) : d);
    }

    private boolean useReportTimezone() {
        return !this.getjConfig().getPrefStore().getBoolean("com.jaspersoft.studio.parameters.usetimezone");
    }

    protected void handleDateRangeChange(Class<? extends java.util.Date> clazz) {
        try {
            DateRangeBuilder drb = this.getDateRangeBuilder();
            if (this.useReportTimezone()) {
                TimeZone timeZone;
                String prefTimeZone;
                Object timeZoneObj = this.params.get("REPORT_TIME_ZONE");
                boolean timeZoneSet = false;
                if (timeZoneObj != null) {
                    TimeZone timeZone2 = null;
                    if (timeZoneObj instanceof String) {
                        timeZone2 = TimeZone.getTimeZone((String)timeZoneObj);
                    } else if (timeZoneObj instanceof TimeZone) {
                        timeZone2 = (TimeZone)timeZoneObj;
                    }
                    if (timeZone2 != null) {
                        drb.set(timeZone2);
                        timeZoneSet = true;
                    }
                }
                if (!timeZoneSet && (prefTimeZone = this.getjConfig().getPrefStore().getString("net.sf.jasperreports.default.timezone")) != null && (timeZone = TimeZone.getTimeZone(prefTimeZone)) != null) {
                    drb.set(timeZone);
                }
            }
            this.updateModel(drb.set(clazz).toDateRange());
        }
        catch (InvalidDateRangeExpressionException invalidDateRangeExpressionException) {
            this.updateModel(null);
        }
    }

    private DateRangeBuilder getDateRangeBuilder() {
        if (this.date.getSelection() != null) {
            return new DateRangeBuilder(this.date.getSelection());
        }
        String exp = Misc.nvl((String)this.date.getText()).toUpperCase();
        Matcher matcher = Pattern.compile("^(DAY|WEEK|MONTH|QUARTER|SEMI|YEAR)([\\+|-][\\d]{1,9})?$").matcher(exp.replaceAll(" ", ""));
        if (matcher.matches()) {
            return new DateRangeBuilder(exp.replaceAll(" ", ""));
        }
        if (this.date.getPattern() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.date.getPattern());
            try {
                return new DateRangeBuilder(sdf.parse(exp));
            }
            catch (ParseException parseException) {}
        }
        return new DateRangeBuilder(exp);
    }

    protected void createTimestampRange(Composite parent, IParameter param, Map<String, Object> params) {
        IPropertyChangeListener preferencesTimeZoneListener = event -> {
            if ("net.sf.jasperreports.default.timezone".equals(event.getProperty()) || "com.jaspersoft.studio.parameters.usetimezone".equals(event.getProperty())) {
                this.handleDateRangeChange(Timestamp.class);
            }
        };
        this.getjConfig().getPrefStore().addPropertyChangeListener(preferencesTimeZoneListener);
        this.date = new DRDateTime(parent, 0x1100003);
        ((DRDateTime)this.date).setSupportDateRange(this.supportDateRange);
        GridData gd = new GridData();
        gd.horizontalIndent = 8;
        gd.widthHint = 25 * DateInput.getCharWidth((Control)this.date);
        this.date.setLayoutData((Object)gd);
        this.setFormat(this.date, "com.jaspersoft.studio.ic.format.timestamp");
        DateInput.setMandatory(param, (Control)this.date);
        ModifyListener listener = e -> this.handleDateRangeChange(Timestamp.class);
        ((DRDateTime)this.date).addModifyListener(listener);
        this.date.addDisposeListener(e -> this.getjConfig().getPrefStore().removePropertyChangeListener(preferencesTimeZoneListener));
        this.updateInput();
        listener.modifyText(null);
    }

    protected void createDateRange(Composite parent, IParameter param, Map<String, Object> params) {
        IPropertyChangeListener preferencesTimeZoneListener = event -> {
            if ("net.sf.jasperreports.default.timezone".equals(event.getProperty()) || "com.jaspersoft.studio.parameters.usetimezone".equals(event.getProperty())) {
                this.handleDateRangeChange(java.util.Date.class);
            }
        };
        this.getjConfig().getPrefStore().addPropertyChangeListener(preferencesTimeZoneListener);
        this.date = new DRDateTime(parent, 0x100003);
        ((DRDateTime)this.date).setSupportDateRange(this.supportDateRange);
        GridData gd = new GridData();
        gd.horizontalIndent = 8;
        gd.widthHint = 25 * DateInput.getCharWidth((Control)this.date);
        this.date.setLayoutData((Object)gd);
        this.setFormat(this.date, "com.jaspersoft.studio.ic.format.date");
        DateInput.setMandatory(param, (Control)this.date);
        ModifyListener listener = e -> this.handleDateRangeChange(java.util.Date.class);
        ((DRDateTime)this.date).addModifyListener(listener);
        this.date.addDisposeListener(e -> this.getjConfig().getPrefStore().removePropertyChangeListener(preferencesTimeZoneListener));
        this.updateInput();
        listener.modifyText(null);
    }

    protected void createTimestamp(Composite parent, IParameter param, Map<String, Object> params) {
        this.date = new CDateTime(parent, 0x1100003);
        GridData gd = new GridData();
        gd.horizontalIndent = 8;
        gd.widthHint = 25 * DateInput.getCharWidth((Control)this.date);
        this.date.setLayoutData((Object)gd);
        this.setFormat(this.date, "com.jaspersoft.studio.ic.format.timestamp");
        DateInput.setMandatory(param, (Control)this.date);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateInput.this.handleTimestampChanged();
            }
        };
        this.date.addSelectionListener((SelectionListener)listener);
        this.updateInput();
        listener.widgetSelected(null);
    }

    protected void createTime(Composite parent, IParameter param, Map<String, Object> params) {
        this.date = new CDateTime(parent, 0x1000003);
        GridData gd = new GridData();
        gd.horizontalIndent = 8;
        gd.widthHint = 25 * DateInput.getCharWidth((Control)this.date);
        this.date.setLayoutData((Object)gd);
        this.setFormat(this.date, "com.jaspersoft.studio.ic.format.time");
        DateInput.setMandatory(param, (Control)this.date);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateInput.this.handleTimeChanged();
            }
        };
        this.date.addSelectionListener((SelectionListener)listener);
        this.updateInput();
        listener.widgetSelected(null);
    }

    protected void createDate(Composite parent, IParameter param, Map<String, Object> params) {
        this.date = new CDateTime(parent, 0x100003);
        GridData gd = new GridData();
        gd.horizontalIndent = 8;
        gd.widthHint = 25 * DateInput.getCharWidth((Control)this.date);
        this.date.setLayoutData((Object)gd);
        this.setFormat(this.date, "com.jaspersoft.studio.ic.format.date");
        DateInput.setMandatory(param, (Control)this.date);
        this.updateInput();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateInput.this.handleDateChanged();
            }
        };
        this.date.addSelectionListener((SelectionListener)listener);
        listener.widgetSelected(null);
    }

    @Override
    public void parameterChanged(PropertyChangeEvent evt) {
        if ("REPORT_TIME_ZONE".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    @Override
    public void updateInput() {
        Object d = this.params.get(this.param.getName());
        if (d != null) {
            if (d instanceof String) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(this.date.getPattern());
                    sdf.parse((String)d);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (d instanceof java.util.Date) {
                this.date.setSelection((java.util.Date)d);
            } else if (d instanceof Long) {
                this.date.setSelection(new java.util.Date((Long)d));
                this.isNumeric = true;
            } else if (d instanceof DateRange) {
                String expr;
                DateRange dr = (DateRange)d;
                if (dr instanceof DateRangeExpression && (expr = ((DateRangeExpression)dr).getExpression()) != null) {
                    ((DRDateTime)this.date).setText(expr);
                    return;
                }
                this.date.setSelection(null);
                ((DRDateTime)this.date).setText(null);
            }
        } else {
            this.date.setSelection(null);
            if (this.date instanceof DRDateTime) {
                ((DRDateTime)this.date).setText(null);
            }
        }
    }

    public boolean isSupportDateRange() {
        return this.supportDateRange;
    }

    public void setSupportDateRange(boolean supportDateRange) {
        this.supportDateRange = supportDateRange;
    }
}

