/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class NumericInput
extends ADataInput {
    private Spinner num;
    private int min;
    private int max;
    private int digits;
    private int increment;
    private int pageIncrement;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Integer.class.isAssignableFrom(valueClass) || Short.class.isAssignableFrom(valueClass) || Byte.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        Class<?> valueClass = param.getValueClass();
        if (Number.class.isAssignableFrom(param.getValueClass())) {
            this.min = 0;
            this.max = 0;
            this.digits = 0;
            this.increment = 1;
            this.pageIncrement = 10;
            if (valueClass.equals(Integer.class)) {
                this.min = Integer.MIN_VALUE;
                this.max = Integer.MAX_VALUE;
            } else if (valueClass.equals(Short.class)) {
                this.min = Short.MIN_VALUE;
                this.max = Short.MAX_VALUE;
            } else if (valueClass.equals(Byte.class)) {
                this.min = -128;
                this.max = 127;
            }
            this.num = new Spinner(parent, 2048);
            this.num.addFocusListener(this.focusListener);
            this.num.addTraverseListener(this.keyListener);
            this.num.setToolTipText(VParameters.createToolTip(param));
            this.updateInput();
            ModifyListener listener2 = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NumericInput.this.num.removeModifyListener((ModifyListener)this);
                    Number n = null;
                    if (param.getValueClass().equals(Integer.class)) {
                        n = new Integer(Misc.nvl((String)NumericInput.this.num.getText()));
                    } else if (param.getValueClass().equals(Byte.class)) {
                        n = new Byte(Misc.nvl((String)NumericInput.this.num.getText()));
                    } else if (param.getValueClass().equals(Short.class)) {
                        n = new Short(Misc.nvl((String)NumericInput.this.num.getText()));
                    }
                    NumericInput.this.updateModel(n);
                    NumericInput.this.updateInput();
                    NumericInput.this.num.addModifyListener((ModifyListener)this);
                }
            };
            this.num.addModifyListener(listener2);
            if (param.getMinValue() != null) {
                int minval = new Integer(param.getMinValue());
                if (!param.isStrictMin()) {
                    ++minval;
                }
                this.num.setMinimum(minval);
            }
            if (param.getMaxValue() != null) {
                int maxval = new Integer(param.getMaxValue());
                if (!param.isStrictMax()) {
                    --maxval;
                }
                this.num.setMaximum(maxval);
            }
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.num.setLayoutData((Object)gd);
            NumericInput.setMandatory(param, (Control)this.num);
            this.setNullable(param, (Control)this.num);
        }
    }

    protected Number getNumber(String number) throws NumberFormatException {
        if (this.param.getValueClass().equals(Long.class)) {
            return new Long(number);
        }
        if (this.param.getValueClass().equals(BigInteger.class)) {
            return new BigInteger(number);
        }
        if (this.param.getValueClass().equals(Float.class)) {
            return new Float(number);
        }
        if (this.param.getValueClass().equals(Double.class)) {
            return new Double(number);
        }
        if (this.param.getValueClass().equals(Integer.class)) {
            return new Integer(number);
        }
        if (this.param.getValueClass().equals(Short.class)) {
            return new Short(number);
        }
        if (this.param.getValueClass().equals(Byte.class)) {
            return new Byte(number);
        }
        if (this.param.getValueClass().equals(BigDecimal.class)) {
            return new BigDecimal(number);
        }
        return null;
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            value = this.getNumber((String)value);
        }
        if (value != null && value instanceof Number) {
            int val = 0;
            if (value != null) {
                val = this.digits == 0 ? ((Number)value).intValue() : (int)(((Number)value).doubleValue() * Math.pow(10000.0, 1.0));
            }
            this.num.setValues(val, this.min, this.max, this.digits, this.increment, this.pageIncrement);
        }
        this.setDecoratorNullable(this.param);
    }
}

