/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class URLInput
extends ADataInput {
    private Text txt;
    private boolean isRefresh = false;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return URL.class.isAssignableFrom(valueClass) || URI.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            this.txt = new Text(parent, 2048);
            this.txt.setToolTipText(VParameters.createToolTip(param));
            this.txt.addFocusListener(this.focusListener);
            this.txt.addTraverseListener(this.keyListener);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.txt.setLayoutData((Object)gd);
            URLInput.setMandatory(param, (Control)this.txt);
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!URLInput.this.isRefresh) {
                        URLInput.hideError((Control)URLInput.this.txt);
                        if (param.getValueClass().equals(URL.class)) {
                            try {
                                URLInput.this.updateModel(new URL(Misc.nvl((String)URLInput.this.txt.getText())));
                            }
                            catch (MalformedURLException e1) {
                                URLInput.setError((Control)URLInput.this.txt, e1.getMessage());
                            }
                        } else if (param.getValueClass().equals(URI.class)) {
                            try {
                                URLInput.this.updateModel(new URI(Misc.nvl((String)URLInput.this.txt.getText())));
                            }
                            catch (URISyntaxException e1) {
                                URLInput.setError((Control)URLInput.this.txt, e1.getMessage());
                            }
                        }
                    }
                }
            };
            this.txt.addModifyListener(listener);
            this.updateInput();
            this.setNullable(param, (Control)this.txt);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            this.txt.setText((String)value);
        } else {
            this.isRefresh = true;
            this.txt.setText(value == null ? "" : value.toString());
            this.isRefresh = false;
        }
        this.setDecoratorNullable(this.param);
    }
}

