/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.inputs.dialog;

import com.jaspersoft.studio.editor.preview.input.BigNumericInput;
import com.jaspersoft.studio.editor.preview.input.BooleanInput;
import com.jaspersoft.studio.editor.preview.input.DateInput;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.editor.preview.input.ImageInput;
import com.jaspersoft.studio.editor.preview.input.LocaleInput;
import com.jaspersoft.studio.editor.preview.input.NumericInput;
import com.jaspersoft.studio.editor.preview.input.ParameterJasper;
import com.jaspersoft.studio.editor.preview.input.TextInput;
import com.jaspersoft.studio.editor.preview.input.TimeZoneInput;
import com.jaspersoft.studio.editor.preview.inputs.dialog.SortFieldSection;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParametersDialog
extends FormDialog {
    private static List<IDataInput> inputs = new ArrayList<IDataInput>();
    private List<JRParameter> prompts;
    private Map<String, Object> params;
    private JasperDesign jDesign;
    private JasperReportsConfiguration jConfig;

    static {
        inputs.add(new BooleanInput());
        inputs.add(new TextInput());
        inputs.add(new LocaleInput());
        inputs.add(new TimeZoneInput());
        inputs.add(new NumericInput());
        inputs.add(new BigNumericInput());
        inputs.add(new DateInput(false, true));
        inputs.add(new ImageInput());
    }

    public ParametersDialog(Shell shell, JasperDesign jDesign, JasperReportsConfiguration jConfig, Map<String, Object> params) {
        super(shell);
        this.jDesign = jDesign;
        this.prompts = jDesign.getParametersList();
        this.params = params;
        this.jConfig = jConfig;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ParametersDialog_report_parameters);
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public boolean canShowParameters() {
        for (JRParameter p : this.prompts) {
            if (!p.isForPrompting() || p.isSystemDefined()) continue;
            for (IDataInput in : inputs) {
                try {
                    if (!in.isForType(p.getValueClass())) continue;
                    return true;
                }
                catch (JRRuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.ParametersDialog_report_parameters);
        FormToolkit toolkit = mform.getToolkit();
        Composite body = mform.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        CTabFolder tabFolder = new CTabFolder(body, 1024);
        GridData gd = new GridData(1808);
        gd.widthHint = 700;
        gd.heightHint = 500;
        tabFolder.setLayoutData((Object)gd);
        tabFolder.setBackground(body.getBackground());
        this.createUserParam(toolkit, tabFolder);
        this.createBParam(toolkit, tabFolder);
        SortFieldSection sortFieldSection = new SortFieldSection();
        sortFieldSection.fillTable((Composite)tabFolder, this.jDesign, this.prompts, this.params);
    }

    private void createBParam(FormToolkit toolkit, CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.ParametersDialog_built_in_parameters);
        ScrolledComposite scompo = new ScrolledComposite((Composite)tabFolder, 768);
        scompo.setExpandHorizontal(true);
        scompo.setExpandVertical(true);
        Composite sectionClient = toolkit.createComposite((Composite)scompo);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        for (JRParameter p : this.prompts) {
            if (p.isForPrompting() && !p.isSystemDefined()) continue;
            this.createInput(toolkit, sectionClient, (JRDesignParameter)p);
        }
        sectionClient.pack();
        scompo.setMinSize(sectionClient.getSize());
        scompo.setContent((Control)sectionClient);
        bptab.setControl((Control)scompo);
    }

    private void createUserParam(FormToolkit toolkit, CTabFolder tabFolder) {
        if (this.canShowParameters()) {
            CTabItem ptab = new CTabItem(tabFolder, 0);
            ptab.setText(Messages.ParametersDialog_user_parameters);
            ScrolledComposite scompo = new ScrolledComposite((Composite)tabFolder, 768);
            scompo.setExpandHorizontal(true);
            scompo.setExpandVertical(true);
            Composite sectionClient = toolkit.createComposite((Composite)scompo);
            sectionClient.setLayout((Layout)new GridLayout(2, false));
            for (JRParameter p : this.prompts) {
                if (!p.isForPrompting() || p.isSystemDefined()) continue;
                this.createInput(toolkit, sectionClient, (JRDesignParameter)p);
            }
            sectionClient.pack();
            scompo.setMinSize(sectionClient.getSize());
            scompo.setContent((Control)sectionClient);
            ptab.setControl((Control)scompo);
        }
    }

    private void createInput(FormToolkit toolkit, Composite sectionClient, JRDesignParameter p) {
        for (IDataInput in : inputs) {
            if (!in.isForType(p.getValueClass())) continue;
            toolkit.createLabel(sectionClient, String.valueOf(MessagesByKeys.getString(p.getName())) + ":", 131072);
            in.createInput(sectionClient, new ParameterJasper(p, this.jConfig), this.params);
            break;
        }
    }
}

