/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.toolbar;

import com.jaspersoft.studio.data.widget.DatasourceComboItem;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.view.APreview;
import net.sf.jasperreports.eclipse.viewer.action.AReportAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.services.IDisposable;

public abstract class ATopToolBarManager {
    protected PreviewJRPrint container;
    protected IToolBarManager tbManager;
    protected ToolBar topToolBar;

    public ATopToolBarManager(PreviewJRPrint container, Composite parent) {
        this.container = container;
        this.createToolBar(parent);
    }

    protected void createToolBar(Composite parent) {
        this.tbManager = new ToolBarManager(8519936);
        this.topToolBar = ((ToolBarManager)this.tbManager).createControl(parent);
        this.removeAll();
        this.fillToolbar(this.tbManager);
        this.refreshToolbar();
    }

    public ToolBar getTopToolBar() {
        return this.topToolBar;
    }

    protected abstract void fillToolbar(IToolBarManager var1);

    public void removeAll() {
        IContributionItem[] iContributionItemArray = this.tbManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem it = iContributionItemArray[n2];
            if (it instanceof ActionContributionItem && ((ActionContributionItem)it).getAction() instanceof IDisposable) {
                ((IDisposable)((ActionContributionItem)it).getAction()).dispose();
            } else if (it instanceof ContributionItem) {
                it.dispose();
            }
            ++n2;
        }
        this.tbManager.removeAll();
    }

    public void refreshToolbar() {
        this.tbManager.update(true);
        if (!this.topToolBar.isDisposed()) {
            this.topToolBar.pack();
            this.topToolBar.getParent().layout(true);
        }
    }

    public void contributeItems(APreview contributor) {
        this.removeAll();
        this.fillToolbar(this.tbManager);
        contributor.contribute2ToolBar(this.tbManager);
        this.refreshToolbar();
    }

    public void setFocus() {
    }

    public void setEnabled(boolean enabled) {
        IContributionItem[] iContributionItemArray = this.tbManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem ti = iContributionItemArray[n2];
            if (ti instanceof ToolItem) {
                ((ToolItem)ti).setEnabled(enabled);
            } else if (ti instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)ti).getAction();
                if (action instanceof AReportAction && enabled) {
                    action.setEnabled(((AReportAction)action).isActionEnabled());
                } else {
                    action.setEnabled(enabled);
                }
            } else if (ti instanceof DatasourceComboItem) {
                ((DatasourceComboItem)ti).setEnabled(enabled);
            }
            ++n2;
        }
        this.refreshToolbar();
    }
}

