/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.toolbar;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.IParametrable;
import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.actions.ViewBookmarksAction;
import com.jaspersoft.studio.editor.preview.actions.ViewExporterAction;
import com.jaspersoft.studio.editor.preview.actions.ViewParametersAction;
import com.jaspersoft.studio.editor.preview.actions.ViewReportParametersAction;
import com.jaspersoft.studio.editor.preview.actions.ViewSortFieldsAction;
import com.jaspersoft.studio.editor.preview.toolbar.ATopToolBarManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.toolbar.ToolItemContribution;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LeftToolBarManager
extends ATopToolBarManager {
    private Label label;
    private Composite prmtbar;
    private ViewParametersAction vprmAction;
    private ViewReportParametersAction vprmrepAction;
    private ViewSortFieldsAction vsortAction;
    private ViewBookmarksAction vTocAction;
    private ViewExporterAction vexpAction;

    public LeftToolBarManager(PreviewJRPrint container, Composite parent) {
        super(container, parent);
    }

    @Override
    protected void createToolBar(Composite parent) {
        this.prmtbar = new Composite(parent, 0);
        this.prmtbar.setLayout((Layout)new GridLayout(2, false));
        this.prmtbar.setLayoutData((Object)new GridData(768));
        this.label = new Label(this.prmtbar, 0);
        this.label.setText(Messages.LeftToolBarManager_label);
        this.label.setLayoutData((Object)new GridData(768));
        this.topToolBar = new ToolBar(this.prmtbar, 8519744);
        this.tbManager = new ToolBarManager(this.topToolBar);
        this.fillToolbar(this.tbManager);
        this.refreshToolbar();
    }

    public void refresh() {
        this.tbManager.removeAll();
        this.fillToolbar(this.tbManager);
    }

    @Override
    protected void fillToolbar(IToolBarManager tbManager) {
        PreviewContainer pvcont = (PreviewContainer)this.container;
        if (this.vprmAction == null) {
            this.vprmAction = new ViewParametersAction(pvcont.getLeftContainer());
        }
        tbManager.add((IAction)this.vprmAction);
        if (this.vprmrepAction == null) {
            this.vprmrepAction = new ViewReportParametersAction(pvcont.getLeftContainer());
        }
        tbManager.add((IAction)this.vprmrepAction);
        if (pvcont.getJrContext().getEditorContext().hasSortFields()) {
            if (this.vsortAction == null) {
                this.vsortAction = new ViewSortFieldsAction(pvcont.getLeftContainer());
            }
            tbManager.add((IAction)this.vsortAction);
        }
        this.addExporterSettings(tbManager, pvcont);
        if (pvcont.getJrContext().getEditorContext().hasBookmarks()) {
            if (this.vTocAction == null) {
                this.vTocAction = new ViewBookmarksAction(pvcont.getLeftContainer());
            }
            tbManager.add((IAction)this.vTocAction);
        }
        this.addPin(this.container, tbManager);
    }

    protected void addExporterSettings(IToolBarManager tbManager, IParametrable ip) {
        PreviewJRPrint pvcont = this.container;
        if (pvcont.getJrContext().getEditorContext().hasExporterSettings()) {
            if (this.vexpAction == null) {
                JasperReportsContext jrContext = (JasperReportsContext)this.container.getAdapter(JasperReportsContext.class);
                IFile f = null;
                if (jrContext != null) {
                    f = (IFile)jrContext.getValue("ifile");
                }
                this.vexpAction = new ViewExporterAction(ip.getLeftContainer(), f);
            }
            tbManager.add((IAction)this.vexpAction);
        }
    }

    public void addPin(final PreviewJRPrint container, IToolBarManager tbManager) {
        ToolItemContribution titem = new ToolItemContribution("id", 32);
        tbManager.add((IContributionItem)titem);
        tbManager.update(true);
        ToolItem item = titem.getToolItem();
        item.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/eclipseicons/pin.png"));
        item.setToolTipText(Messages.LeftToolBarManager_pintooltip);
        item.setSelection(!container.isHideParameters());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                container.setHideParameters(!container.isHideParameters());
            }
        });
    }

    public void setLabelText(String key) {
        this.label.setText(key);
        this.prmtbar.layout();
    }
}

