/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.editor.preview.view.control.JRErrorHandler;
import com.jaspersoft.studio.utils.Console;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.util.xml.SourceLocation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;

public class JRMarkerErrorHandler
extends JRErrorHandler {
    private IFile resource;

    public JRMarkerErrorHandler(Console c, IFile resouece) {
        super(c);
        this.resource = resouece;
    }

    @Override
    public void reset() {
        super.reset();
        try {
            if (this.resource != null) {
                Markers.deleteMarkers((IResource)this.resource);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addMarker(Throwable e) {
        super.addMarker(e);
        try {
            if (this.resource != null) {
                Markers.addMarker((IResource)this.resource, (Throwable)e);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private int getLocationLine(SourceLocation location) {
        return location != null ? location.getLineNumber() : 0;
    }

    @Override
    public void addMarker(IProblem problem, SourceLocation location) {
        super.addMarker(problem, location);
        try {
            if (this.resource != null) {
                Markers.addMarker((IResource)this.resource, (String)problem.getMessage(), (int)this.getLocationLine(location), (int)2);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void addMarker(String message, SourceLocation location) {
        super.addMarker(message, location);
        try {
            if (this.resource != null) {
                Markers.addMarker((IResource)this.resource, (String)message, (int)this.getLocationLine(location), (int)2);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void addMarker(IProblem problem, SourceLocation location, JRExpression expr) {
        super.addMarker(problem, location, expr);
        try {
            if (this.resource != null) {
                Markers.addMarker((IResource)this.resource, (String)problem.getMessage(), (int)this.getLocationLine(location), (int)2);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void addMarker(String message, SourceLocation location, JRDesignElement element) {
        super.addMarker(message, location, element);
        try {
            if (this.resource != null) {
                Markers.addMarker((IResource)this.resource, (String)message, (int)this.getLocationLine(location), (int)2);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }
}

