/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.report.swt.SWTViewer;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.base.BasePrintBookmark;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VBookmarks
extends APreview {
    private Composite composite;
    private TreeViewer treeViewer;
    private PreviewJRPrint pcontainer;

    public VBookmarks(Composite parent, JasperReportsConfiguration jContext, PreviewJRPrint pcontainer) {
        super(parent, jContext);
        this.pcontainer = pcontainer;
    }

    public void setJasperPrint(JasperPrint jrPrint) {
        BasePrintBookmark root = new BasePrintBookmark("Root", 0, "");
        if (jrPrint != null && jrPrint.getBookmarks() != null) {
            for (PrintBookmark pb : jrPrint.getBookmarks()) {
                root.addBookmark(pb);
            }
        }
        this.treeViewer.setInput((Object)root);
        this.treeViewer.expandToLevel(1);
    }

    @Override
    protected Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.treeViewer = new TreeViewer(this.composite, 2816);
        this.treeViewer.setContentProvider((IContentProvider)new BookmarkContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BookmarkLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection sel = (ITreeSelection)event.getSelection();
                PrintBookmark pb = (PrintBookmark)sel.getFirstElement();
                APreview view = VBookmarks.this.pcontainer.getDefaultViewer();
                if (view instanceof SWTViewer) {
                    ((SWTViewer)view).setPageNumber(pb.getPageIndex());
                }
            }
        });
        this.composite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                int h = VBookmarks.this.composite.getSize().y;
                int w = VBookmarks.this.composite.getSize().x;
                VBookmarks.this.composite.setSize(VBookmarks.this.composite.computeSize(w, h, true));
                VBookmarks.this.composite.layout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return this.composite;
    }

    private class BookmarkContentProvider
    implements ITreeContentProvider {
        private Object[] EMPTY_ARRAY = new Object[0];

        private BookmarkContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            PrintBookmark pb = (PrintBookmark)element;
            if (pb.getBookmarks() != null) {
                return !pb.getBookmarks().isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return this.getChildren(element);
        }

        public Object[] getChildren(Object element) {
            PrintBookmark pb = (PrintBookmark)element;
            if (pb.getBookmarks() != null) {
                return pb.getBookmarks().toArray();
            }
            return this.EMPTY_ARRAY;
        }
    }

    private class BookmarkLabelProvider
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private BookmarkLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof PrintBookmark) {
                String label = ((PrintBookmark)element).getLabel();
                return new StyledString(Misc.nvl((String)label));
            }
            return new StyledString("");
        }

        public String getToolTipText(Object element) {
            if (element instanceof PrintBookmark) {
                PrintBookmark pb = (PrintBookmark)element;
                return String.valueOf(pb.getLabel()) + "\nAddress: " + pb.getElementAddress() + "\nPage: " + pb.getPageIndex();
            }
            return "";
        }

        public void update(ViewerCell cell) {
            try {
                Object element = cell.getElement();
                StyledString st = this.getStyledText(element);
                cell.setText(st.getString());
                cell.setStyleRanges(this.getStyledText(element).getStyleRanges());
                cell.setImage(this.getImage(element));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Image getImage(Object element) {
            return JaspersoftStudioPlugin.getInstance().getImage("icons/blue-document-bookmark.png");
        }
    }
}

