/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.PropertyChangeNotifier;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.preferences.editor.pages.Pages;
import com.jaspersoft.studio.utils.NumberValidator;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class VReportParameters
extends VParameters {
    private Button btPage;
    private Spinner page;
    private Button btRange;
    private Spinner pageFrom;
    private Spinner pageTo;
    private Button btAll;

    public VReportParameters(Composite parent, JasperReportsConfiguration jContext, PropertyChangeNotifier propertyChangeNotifier) {
        super(parent, jContext, propertyChangeNotifier);
        this.isSystem = true;
    }

    @Override
    protected boolean isParameterToShow(JRParameter p) {
        return p.isSystemDefined() && !p.getName().equals("REPORT_TEMPLATES") && !p.getName().equals("SORT_FIELDS") && !p.getName().equals("REPORT_PARAMETERS_MAP");
    }

    @Override
    protected void setupLabel(Label lbl, IParameter pres) {
        lbl.setText(MessagesByKeys.getString(pres.getLabel()));
    }

    @Override
    protected void createInputControls(List<JRParameter> prompts, Map<String, Object> params) {
        super.createInputControls(prompts, params);
        this.createVerticalSeprator(false);
        Composite cmp = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        cmp.setLayout((Layout)layout);
        new Label(cmp, 0).setText(Messages.JRExporterPreferencePage_16);
        Text tOx = new Text(cmp, 2048);
        tOx.setLayoutData((Object)new GridData(768));
        tOx.setText(Misc.nvl((String)this.jContext.getProperty("expparam.offset.x")));
        tOx.addVerifyListener((VerifyListener)new NumberValidator(0, Integer.MAX_VALUE, Integer.class));
        tOx.addModifyListener((ModifyListener)new OffsetModifyListener(tOx, "expparam.offset.x"));
        new Label(cmp, 0).setText(Messages.JRExporterPreferencePage_17);
        Text tOy = new Text(cmp, 2048);
        tOy.setLayoutData((Object)new GridData(768));
        tOy.setText(Misc.nvl((String)this.jContext.getProperty("expparam.offset.y")));
        tOy.addVerifyListener((VerifyListener)new NumberValidator(0, Integer.MAX_VALUE, Integer.class));
        tOy.addModifyListener((ModifyListener)new OffsetModifyListener(tOy, "expparam.offset.y"));
        Group container = new Group(cmp, 0);
        container.setText(Messages.PagesFieldEditor_pageToExportBox);
        container.setLayout((Layout)new GridLayout(5, false));
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        container.setLayoutData((Object)gd);
        this.btAll = new Button((Composite)container, 16);
        this.btAll.setText(Messages.PagesFieldEditor_allPages);
        gd = new GridData();
        gd.horizontalSpan = 5;
        this.btAll.setLayoutData((Object)gd);
        this.btAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VReportParameters.this.handlePageChange();
            }
        });
        this.createPage(container);
        this.createRange(container);
        String ip = this.jContext.getProperty("expparam.index.page");
        Pages pages = new Pages();
        pages.parseString(ip);
        if (pages.getPage() != null) {
            this.btPage.setSelection(true);
            this.page.setSelection(pages.getPage().intValue());
            this.page.setEnabled(true);
        } else if (pages.getFrom() != null) {
            this.btRange.setSelection(true);
            this.pageFrom.setSelection(pages.getFrom().intValue());
            this.pageFrom.setEnabled(true);
            this.pageTo.setSelection(pages.getTo().intValue());
            this.pageTo.setEnabled(true);
        } else {
            this.btAll.setSelection(true);
        }
        this.refreshControl();
    }

    private void createPage(Group container) {
        this.btPage = new Button((Composite)container, 16);
        this.btPage.setText(Messages.PagesFieldEditor_precisePages);
        this.page = new Spinner((Composite)container, 2048);
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        this.page.setLayoutData((Object)gd);
        this.page.setEnabled(false);
        this.page.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.page.addModifyListener(e -> this.handlePageChange());
        this.btPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VReportParameters.this.page.setEnabled(VReportParameters.this.btPage.getSelection());
            }
        });
    }

    private void createRange(Group container) {
        this.btRange = new Button((Composite)container, 16);
        this.btRange.setText(Messages.PagesFieldEditor_fromToPages);
        this.pageFrom = new Spinner((Composite)container, 2048);
        this.pageFrom.setEnabled(false);
        this.pageFrom.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.pageFrom.addModifyListener(e -> this.handlePageChange());
        Label lbl = new Label((Composite)container, 0);
        lbl.setText(Messages.PagesFieldEditor_to);
        this.pageTo = new Spinner((Composite)container, 2048);
        this.pageTo.setEnabled(false);
        this.pageTo.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 10);
        this.pageTo.addModifyListener(e -> this.handlePageChange());
        this.btRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VReportParameters.this.pageFrom.setEnabled(VReportParameters.this.btRange.getSelection());
                VReportParameters.this.pageTo.setEnabled(VReportParameters.this.btRange.getSelection());
            }
        });
    }

    private void handlePageChange() {
        MScopedPreferenceStore ps = this.jContext.getPrefStore();
        String value = this.getProperty();
        if (value.equals("all")) {
            this.jContext.setProperty("expparam.index.page", "");
            ps.setValue("expparam.index.page", "");
        } else {
            this.jContext.setProperty("expparam.index.page", value);
            ps.setValue("expparam.index.page", value);
        }
        try {
            ps.save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private String getProperty() {
        if (this.btAll.getSelection()) {
            return "all";
        }
        if (this.btPage.getSelection()) {
            return Integer.toString(this.page.getSelection());
        }
        int from = this.pageFrom.getSelection();
        int to = this.pageTo.getSelection();
        if (to < from) {
            to = from;
        }
        return String.valueOf(Integer.toString(from)) + ";" + Integer.toString(to);
    }

    class OffsetModifyListener
    implements ModifyListener {
        private Text txt;
        private String property;
        private ScopedPreferenceStore ps;

        public OffsetModifyListener(Text txt, String property) {
            this.txt = txt;
            this.property = property;
            this.ps = VReportParameters.this.jContext.getPrefStore();
        }

        public void modifyText(ModifyEvent e) {
            String v = this.txt.getText();
            if (Misc.isNullOrEmpty((String)v)) {
                VReportParameters.this.jContext.removeProperty(this.property);
                this.ps.setValue(this.property, this.ps.getDefaultInt(this.property));
            } else {
                VReportParameters.this.jContext.setProperty(this.property, v);
                this.ps.setValue(this.property, Integer.parseInt(v));
            }
            try {
                this.ps.save();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

