/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.html;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.report.IURLViewable;
import com.jaspersoft.studio.editor.preview.view.report.html.URLContributionItem;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.TimeZone;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ABrowserViewer
extends APreview
implements IURLViewable {
    public static final String REFRESH_ACTION_ID = "com.jaspersoft.studio.browserViewer.refreshAction";
    public static final String OPEN_BROWSER_ACTION_ID = "com.jaspersoft.studio.browserViewer.openBrowserAction";
    private Browser browser;
    private String url;
    private URLContributionItem urlBar;
    private Action refreshAction;
    private Action openInBrowserAction;
    private StackLayout stackLayout;
    private Composite container;
    private Composite externalBrowserCmp;
    private boolean isEdgeEnabled;

    public ABrowserViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
        parent.addDisposeListener(e -> {
            if (this.browser != null) {
                this.browser.dispose();
            }
        });
        this.isEdgeEnabled = BrowserUtils.isEdgeWebViewEnabled();
    }

    @Override
    protected Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.container.setLayout((Layout)this.stackLayout);
        return this.container;
    }

    @Override
    public void contribute2ToolBar(IToolBarManager tmanager) {
        super.contribute2ToolBar(tmanager);
        if (!ABrowserViewer.useExternalBrowser()) {
            if (this.urlBar == null) {
                this.urlBar = new URLContributionItem(Misc.nvl((Object)this.url, (String)"")){

                    @Override
                    protected int computeWidth(Control control) {
                        return Math.max(UIUtils.getScaledWidth((int)200), ABrowserViewer.this.getUrlWidth((Control)control.getParent()) - UIUtils.getScaledWidth((int)320));
                    }
                };
            }
            tmanager.add((IContributionItem)this.urlBar);
            tmanager.add((IAction)this.getRefreshAction());
            tmanager.add((IAction)this.getOpenBrowser());
        }
    }

    protected int getUrlWidth(Control control) {
        return control.getParent().getSize().x - UIUtils.getScaledWidth((int)80);
    }

    public void setURL(String url, String urlcookie, String scookie) throws Exception {
        this.updateUIForBrowser();
        this.url = Misc.nvl((String)url);
        if (ABrowserViewer.useExternalBrowser()) {
            BrowserUtils.openExternalBrowser((String)url);
        } else {
            if (this.urlBar != null) {
                this.urlBar.setUrl(url);
            }
            if (this.browser != null) {
                Browser.clearSessions();
                if (urlcookie != null && scookie != null) {
                    Browser.setCookie((String)scookie, (String)urlcookie);
                    this.browser.setUrl(url, null, new String[]{"Accept-Timezone: " + TimeZone.getDefault().getID(), "User-Agent: " + HttpUtils.USER_AGENT_JASPERSOFT_STUDIO});
                } else {
                    this.browser.setUrl(url);
                }
                if (this.isEdgeEnabled) {
                    this.browser.pack(true);
                    this.container.layout();
                }
            }
        }
    }

    @Override
    public void setURL(String url) throws Exception {
        this.setURL(url, null, null);
    }

    public void updateUIForBrowser() {
        if (ABrowserViewer.useExternalBrowser()) {
            if (this.externalBrowserCmp == null) {
                this.externalBrowserCmp = new Composite(this.container, 0);
                this.externalBrowserCmp.setLayout((Layout)new FillLayout());
                Label messageLbl = new Label(this.externalBrowserCmp, 0);
                messageLbl.setText(Messages.ABrowserViewer_ExternalBrowserPreviewMsg);
            }
            if (this.stackLayout.topControl != this.externalBrowserCmp) {
                this.stackLayout.topControl = this.externalBrowserCmp;
                this.container.layout();
            }
        } else {
            if (this.browser == null) {
                try {
                    this.browser = BrowserUtils.getSWTBrowserWidget((Composite)this.container, (int)0);
                    this.browser.setLayoutData((Object)new GridData(1808));
                    this.browser.setJavascriptEnabled(true);
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
            if (this.stackLayout.topControl != this.browser) {
                this.stackLayout.topControl = this.browser;
                this.container.layout();
            }
        }
    }

    private Action getRefreshAction() {
        if (this.refreshAction == null) {
            this.refreshAction = new Action("", JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/refresh-16.png")){

                public boolean isEnabled() {
                    return true;
                }

                public void run() {
                    ABrowserViewer.this.browser.refresh();
                }
            };
            this.refreshAction.setId(REFRESH_ACTION_ID);
        }
        return this.refreshAction;
    }

    private Action getOpenBrowser() {
        if (this.openInBrowserAction == null) {
            ImageDescriptor baseImage = JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/application_go.png");
            this.openInBrowserAction = new Action("", baseImage){

                public boolean isEnabled() {
                    return true;
                }

                public void run() {
                    BrowserUtils.openExternalBrowser((String)ABrowserViewer.this.url);
                }
            };
            this.openInBrowserAction.setId(OPEN_BROWSER_ACTION_ID);
            this.openInBrowserAction.setToolTipText("Open the report in the external browser");
        }
        return this.openInBrowserAction;
    }

    protected void refreshBrowser() {
        if (this.browser != null) {
            this.updateUIForBrowser();
            if (!ABrowserViewer.useExternalBrowser()) {
                this.browser.refresh();
            }
        }
    }

    public static boolean useExternalBrowser() {
        return JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.jss.browser.external");
    }
}

