/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.html;

import com.jaspersoft.studio.editor.preview.actions.export.AExportAction;
import com.jaspersoft.studio.editor.preview.actions.export.ExportMenuAction;
import com.jaspersoft.studio.editor.preview.actions.export.html.ExportAsLHtmlAction;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.IPreferencePage;
import com.jaspersoft.studio.editor.preview.view.report.ExportMenu;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.editor.preview.view.report.html.ABrowserViewer;
import com.jaspersoft.studio.preferences.exporter.HTMLExporterPreferencePage;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.ReportViewer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class HTMLViewer
extends ABrowserViewer
implements IJRPrintable,
IPreferencePage {
    private JasperPrint jrprint;
    private ReportViewer rptviewer;
    private AExportAction expAction;
    private File tmpDir;
    private File tmpFile;
    private boolean isRefresh = false;
    private boolean newRequest = false;

    @Override
    public JasperPrint getJrPrint() {
        return this.jrprint;
    }

    public HTMLViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    @Override
    protected Control createControl(Composite parent) {
        Control composite = super.createControl(parent);
        this.rptviewer = new ReportViewer((JasperReportsContext)this.jContext);
        return composite;
    }

    @Override
    public void contribute2ToolBar(IToolBarManager tmanager) {
        super.contribute2ToolBar(tmanager);
        if (this.jrprint != null) {
            ExportMenuAction exportMenu = ExportMenu.getExportMenu((IReportViewer)this.rptviewer, this.jContext);
            this.setDefaultExporter(exportMenu, this.createExporter(this.rptviewer));
            tmanager.add((IAction)exportMenu);
        }
    }

    @Override
    protected int getUrlWidth(Control control) {
        return control.getParent().getSize().x - UIUtils.getScaledWidth((int)110);
    }

    @Override
    public void setJRPRint(Statistics stats, JasperPrint jrprint) throws Exception {
        this.setJRPRint(stats, jrprint, false);
    }

    @Override
    public void setJRPRint(final Statistics stats, JasperPrint jrprint, boolean refresh) throws Exception {
        if (this.jrprint != jrprint || refresh) {
            this.rptviewer.setReport(jrprint);
            if (this.tmpFile == null) {
                this.tmpFile = File.createTempFile("report", this.getExtension(), this.getTmpPath());
            }
            AExportAction exp = this.createExporter(this.rptviewer);
            stats.startCount("ST_EXPORTTIME");
            exp.preview(this.tmpFile, new Callback<File>(){

                @Override
                public void completed(File value) {
                    stats.endCount("ST_EXPORTTIME");
                    stats.setValue("REPORTSIZE", HTMLViewer.this.tmpFile.length());
                    try {
                        HTMLViewer.this.setURL(HTMLViewer.this.tmpFile.toURI().toASCIIString());
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                    }
                    HTMLViewer.this.doRefresh();
                }
            });
        }
        this.doRefresh();
        this.jrprint = jrprint;
    }

    protected String getExtension() {
        return ".html";
    }

    protected AExportAction createExporter(ReportViewer rptv) {
        if (this.expAction == null) {
            this.expAction = new ExportAsLHtmlAction((IReportViewer)rptv, this.jContext, null);
        }
        return this.expAction;
    }

    private File getTmpPath() throws IOException {
        if (this.tmpDir != null) {
            FileUtils.recursiveDelete((File)this.tmpDir);
        }
        this.tmpDir = FileUtils.createTempDir();
        return this.tmpDir;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.tmpDir != null) {
            FileUtils.recursiveDelete((File)this.tmpDir);
        }
    }

    public void pageGenerated(JasperPrint arg0, int arg1) {
        this.doRefresh();
    }

    public void pageUpdated(JasperPrint arg0, int arg1) {
        this.doRefresh();
    }

    private void doRefresh() {
        if (this.isRefresh) {
            this.newRequest = true;
            return;
        }
        this.isRefresh = true;
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                HTMLViewer.this.newRequest = false;
                HTMLViewer.this.refreshBrowser();
                HTMLViewer.this.isRefresh = false;
                if (HTMLViewer.this.newRequest) {
                    HTMLViewer.this.doRefresh();
                }
            }
        });
    }

    @Override
    public PreferencePage getPreferencePage() {
        return new HTMLExporterPreferencePage();
    }
}

