/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.java2d.ISelectionOverrider;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import com.jaspersoft.studio.preferences.bindings.JSSKeySequence;
import com.jaspersoft.studio.preferences.bindings.JSSKeyStroke;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;

public class ParentSelectionOverrider
implements ISelectionOverrider {
    private static final String BINDING_KEY_ID = "com.jaspersoft.studio.editor.ParentSelectionOverrider";
    private Class<?> searchedType;
    private boolean ignoreSelected = false;

    public ParentSelectionOverrider(Class<?> searchedType, boolean ignoreSelected) {
        this.searchedType = searchedType;
        this.ignoreSelected = ignoreSelected;
    }

    @Override
    public boolean overriddenSelection(EditPart selectedPart, List<?> previousSelection, GraphicalViewer currentViewer) {
        if (selectedPart != null && BindingsPreferencePersistence.isPressed(BINDING_KEY_ID)) {
            Object lastItem = selectedPart.getModel();
            if (lastItem instanceof ANode) {
                ANode currentNode = (ANode)lastItem;
                if (this.ignoreSelected) {
                    currentNode = currentNode.getParent();
                }
                while (currentNode != null) {
                    EditPart part;
                    if (this.searchedType.isAssignableFrom(currentNode.getClass()) && (part = SelectionHelper.getEditPart(currentNode)) != null) {
                        part.getViewer().deselectAll();
                        if (part.getViewer() instanceof JSSScrollingGraphicalViewer) {
                            ((JSSScrollingGraphicalViewer)part.getViewer()).forceSelect(part);
                        } else {
                            part.getViewer().select(part);
                        }
                        return true;
                    }
                    currentNode = currentNode.getParent();
                }
            }
        } else if (JaspersoftStudioPlugin.getInstance().isTraceEnabled()) {
            StringBuilder message = new StringBuilder("ParentSelectOverrider-");
            message.append("Sequence Expected: ");
            message.append(BindingsPreferencePersistence.getBinding(BINDING_KEY_ID));
            ArrayList<JSSKeyStroke> pressedKeys = new ArrayList<JSSKeyStroke>();
            Integer[] integerArray = JasperReportsPlugin.getPressedKeys();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int pressedKey = integerArray[n2];
                pressedKeys.add(JSSKeyStroke.getInstance(pressedKey));
                ++n2;
            }
            JSSKeySequence keysSequence = JSSKeySequence.getInstance(pressedKeys);
            message.append("\r\n Currently Pressed: ");
            message.append(keysSequence);
            JaspersoftStudioPlugin.getInstance().logTrace(message.toString());
        }
        return false;
    }
}

