/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.figures.ImageFigure;
import com.jaspersoft.studio.editor.gef.figures.StaticTextFigure;
import com.jaspersoft.studio.editor.gef.figures.borders.CornerBorder;
import com.jaspersoft.studio.editor.gef.figures.borders.ElementLineBorder;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.style.editpolicy.ElementEditPolicy;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.text.MStaticText;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class StyleEditPart
extends FigureEditPart {
    private StaticTextFigure textF;
    private ImageFigure imageF;
    private JRDesignStaticText textE;
    private MStaticText textModel;
    private JRDesignImage imageE;
    private MImage imageModel;
    private GridData gd;

    @Override
    protected IFigure createFigure() {
        RectangleFigure rf = new RectangleFigure();
        rf.setBorder((Border)new LineBorder(ColorConstants.lightGray));
        GridLayout lm = new GridLayout(2, false);
        lm.marginHeight = 20;
        lm.marginWidth = 20;
        lm.horizontalSpacing = 20;
        rf.setLayoutManager((LayoutManager)lm);
        MStyle st = (MStyle)this.getModel();
        final JRStyle style = st.getValue();
        this.textModel = new MStaticText();
        this.textE = new JRDesignStaticText();
        this.textE.setX(20);
        this.textE.setY(20);
        this.textE.setWidth(200);
        this.textE.setHeight(100);
        this.textE.setText(this.computeTextMsg(style));
        this.textE.setStyle(style);
        this.textModel.setValue(this.textE);
        this.imageModel = new MImage();
        this.imageE = new JRDesignImage(null);
        this.imageE.setX(this.textE.getX() * 2 + this.textE.getWidth());
        this.imageE.setY(this.textE.getY());
        this.imageE.setWidth(100);
        this.imageE.setHeight(this.textE.getHeight());
        this.imageE.setStyle(style);
        this.imageModel.setValue(this.imageE);
        rf.setSize(this.textE.getX() * 3 + this.textE.getWidth() + this.imageE.getWidth(), this.textE.getY() * 2 + this.textE.getHeight());
        this.textF = new StaticTextFigure(this.textModel);
        this.textF.setJRElement((JRElement)this.textE, this.drawVisitor);
        this.imageF = new ImageFigure(this.imageModel);
        this.imageF.setJRElement((JRElement)this.imageE, this.drawVisitor);
        GridData gd = new GridData(1808);
        gd.heightHint = this.textE.getHeight() + 20;
        gd.widthHint = this.textE.getWidth() + 5;
        lm.setConstraint((IFigure)this.textF, (Object)gd);
        gd = new GridData(768);
        gd.heightHint = this.imageE.getHeight() + 20;
        gd.widthHint = this.imageE.getWidth() + 5;
        lm.setConstraint((IFigure)this.imageF, (Object)gd);
        rf.add((IFigure)this.textF);
        rf.add((IFigure)this.imageF);
        this.setPrefsBorder((IFigure)rf);
        st.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if ("name".equals(arg0.getPropertyName())) {
                    StyleEditPart.this.textE.setText(StyleEditPart.this.getStylePartText(arg0.getNewValue() != null ? arg0.getNewValue() : ""));
                }
                if ("conditionExpression".equals(arg0.getPropertyName())) {
                    StyleEditPart.this.textE.setText(StyleEditPart.this.computeTextMsg(style));
                }
                StyleEditPart.this.imageModel.setChangedProperty(true);
                StyleEditPart.this.textModel.setChangedProperty(true);
                if (StyleEditPart.this.getParent() != null) {
                    StyleEditPart.this.refresh();
                } else {
                    StyleEditPart.this.getModel().getPropertyChangeSupport().removePropertyChangeListener(this);
                }
            }
        });
        return rf;
    }

    private String computeTextMsg(JRStyle style) {
        if (style instanceof JRConditionalStyle) {
            JRExpression conditionExpression = ((JRConditionalStyle)style).getConditionExpression();
            String conditionExpr = conditionExpression != null ? conditionExpression.getText() : "<NO CONDITION SET>";
            return "Conditional Style: " + conditionExpr;
        }
        return this.getStylePartText(style.getName());
    }

    private String getStylePartText(Object styleName) {
        return MessageFormat.format(Messages.StyleEditPart_styleTemplatePrefix, styleName);
    }

    @Override
    public void setPrefsBorder(IFigure rect) {
        String pref = Platform.getPreferencesService().getString(JaspersoftStudioPlugin.getUniqueIdentifier(), "elementDesignBorderStyle", "rectangle", null);
        if (pref.equals("rectangle")) {
            this.imageF.setBorder((Border)new ElementLineBorder(ColorConstants.black));
            this.textF.setBorder((Border)new ElementLineBorder(ColorConstants.black));
        } else {
            this.imageF.setBorder((Border)new CornerBorder(ColorConstants.black, 5));
            this.textF.setBorder((Border)new CornerBorder(ColorConstants.black, 5));
        }
    }

    @Override
    protected void setupFigure(IFigure rect) {
        LayoutManager lm = rect.getParent().getLayoutManager();
        Rectangle b = rect.getBounds();
        if (this.gd == null) {
            this.gd = new GridData(768);
            this.gd.heightHint = b.height;
            this.gd.widthHint = b.width;
            lm.setConstraint(rect, (Object)this.gd);
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected void showSourceFeedback() {
            }

            protected void showTargetFeedback() {
                super.showTargetFeedback();
            }
        };
    }
}

