/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.tools;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.editor.defaults.CustomStyleResolver;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.tools.ICompositeElementModifyListener;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CompositeElementManager {
    public static final CompositeElementManager INSTANCE = new CompositeElementManager();
    private static final String NOTE_TEMPLATE = "callouts.1.fg=0,0,0\ncallouts.1.text={0}\ncallouts.1.bounds={1},0,650,40\ncallouts.1.bg=255,255,0\n";
    private static final String ELEMENTS_STORAGE_KEY = "compositeElements";
    private static final String INDEX_FILE_NAME = "index.xml";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_ICON_SMALL = "icon_small";
    private static final String PROPERTY_ICON_BIG = "icon_big";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_GROUP = "group_id";
    private static final String REQUIRED_RESOURCES = "requiredResources";
    private static final String PROPERTY_PATH = "path";
    private static final String XML_TAG_NAME = "compositeElement";
    public static final String COMPOSITE_ELEMENT_EXTENSION = ".jssce";
    private List<MCompositeElement> availableElements = new ArrayList<MCompositeElement>();
    private HashMap<String, Pair<JRBand, JasperDesign>> cachedElementssMap = new HashMap();
    private List<ICompositeElementModifyListener> listeners = new ArrayList<ICompositeElementModifyListener>();
    private IResourceChangeListener resourceDeletedListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayList<IFile> resourcesDeleted = new ArrayList<IFile>();
            if (event.getType() == 1 && !CompositeElementManager.this.cachedElementssMap.isEmpty()) {
                CompositeElementManager.this.iterateResourceDelta(event.getDelta(), resourcesDeleted);
                for (IFile resource : resourcesDeleted) {
                    String resourceString = resource.getRawLocation().toOSString();
                    CompositeElementManager.this.cachedElementssMap.remove(resourceString);
                }
            }
        }
    };

    private CompositeElementManager() {
        this.loadElements();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceDeletedListener);
    }

    public List<MCompositeElement> getAvailableElements() {
        return this.availableElements;
    }

    public boolean isNameAlreadyUsed(String name) {
        for (MCompositeElement element : this.availableElements) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void exportCompositeElement(List<MCompositeElement> elementsToExport, File targetFolder) {
        block15: {
            File indexFile = new File(targetFolder, INDEX_FILE_NAME);
            Document document = null;
            Element root = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            FileOutputStream oStream = null;
            try {
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    document = builder.newDocument();
                    root = document.createElement("elements");
                    document.appendChild(root);
                    String baseFolderName = "CompositeElement";
                    int index = 1;
                    for (MCompositeElement elementToExport : elementsToExport) {
                        File elementResourceDir;
                        File iconBigFile;
                        File iconSmallFile;
                        File destinationFolder = new File(targetFolder, String.valueOf(baseFolderName) + index);
                        destinationFolder.mkdirs();
                        ++index;
                        File elementDefinition = new File(elementToExport.getPath());
                        if (!elementDefinition.exists()) continue;
                        org.apache.commons.io.FileUtils.copyFile((File)elementDefinition, (File)new File(destinationFolder, elementDefinition.getName()));
                        boolean hasSmallIcon = false;
                        String iconSmallPath = elementToExport.getIconPathSmall();
                        if (iconSmallPath != null && (iconSmallFile = new File(iconSmallPath)).exists()) {
                            org.apache.commons.io.FileUtils.copyFile((File)iconSmallFile, (File)new File(destinationFolder, iconSmallFile.getName()));
                            hasSmallIcon = true;
                        }
                        boolean hasBigIcon = false;
                        String iconBigPath = elementToExport.getIconPathBig();
                        if (iconBigPath != null && (iconBigFile = new File(iconBigPath)).exists()) {
                            org.apache.commons.io.FileUtils.copyFile((File)iconBigFile, (File)new File(destinationFolder, iconBigFile.getName()));
                            hasBigIcon = true;
                        }
                        if ((elementResourceDir = new File(elementDefinition.getParentFile(), elementToExport.getName())).exists()) {
                            try {
                                org.apache.commons.io.FileUtils.copyDirectory((File)elementResourceDir, (File)new File(destinationFolder, elementResourceDir.getName()));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                JaspersoftStudioPlugin.getInstance().logError(e);
                            }
                        }
                        try {
                            Element newNode = document.createElement(XML_TAG_NAME);
                            newNode.setAttribute(PROPERTY_NAME, elementToExport.getName());
                            newNode.setAttribute(PROPERTY_PATH, String.valueOf(destinationFolder.getName()) + "/" + elementDefinition.getName());
                            newNode.setAttribute(PROPERTY_DESCRIPTION, elementToExport.getDescription());
                            newNode.setAttribute(PROPERTY_GROUP, elementToExport.getGroupId());
                            if (hasSmallIcon) {
                                newNode.setAttribute(PROPERTY_ICON_SMALL, String.valueOf(destinationFolder.getName()) + "/" + new File(iconSmallPath).getName());
                            }
                            if (hasBigIcon) {
                                newNode.setAttribute(PROPERTY_ICON_BIG, String.valueOf(destinationFolder.getName()) + "/" + new File(iconBigPath).getName());
                            }
                            root.appendChild(newNode);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                        }
                    }
                    indexFile.delete();
                    indexFile.createNewFile();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    oStream = new FileOutputStream(indexFile);
                    StreamResult result = new StreamResult(oStream);
                    indexFile.createNewFile();
                    transformer.transform(source, result);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    FileUtils.closeStream(oStream);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(oStream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)oStream);
        }
    }

    public List<MCompositeElement> loadCompositeElements(File contentFolder) {
        File indexFile = new File(contentFolder, INDEX_FILE_NAME);
        ArrayList<MCompositeElement> elementsFound = new ArrayList<MCompositeElement>();
        if (indexFile != null && indexFile.exists()) {
            try {
                String xmlContent = CompositeElementManager.readFile(indexFile);
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlContent)));
                NodeList adapterNodes = document.getElementsByTagName(XML_TAG_NAME);
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    try {
                        MCompositeElement loadedElement;
                        Node adapterNode = adapterNodes.item(i);
                        if (adapterNode.getNodeType() == 1 && adapterNode.getAttributes().getNamedItem(PROPERTY_NAME) != null && (loadedElement = CompositeElementManager.createElementFromNode(adapterNode, contentFolder)) != null) {
                            elementsFound.add(loadedElement);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
        }
        return elementsFound;
    }

    public void deleteCompositeElement(MCompositeElement elementToRemove) {
        this.cachedElementssMap.remove(elementToRemove.getPath());
        this.availableElements.remove(elementToRemove);
        File indexFile = ConfigurationManager.getStorageResource(ELEMENTS_STORAGE_KEY, INDEX_FILE_NAME);
        if (indexFile.exists()) {
            try {
                String xmlContent = CompositeElementManager.readFile(indexFile);
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlContent)));
                NodeList adapterNodes = document.getElementsByTagName(XML_TAG_NAME);
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    try {
                        String name;
                        Node adapterNode = adapterNodes.item(i);
                        if (adapterNode.getNodeType() == 1 && adapterNode.getAttributes().getNamedItem(PROPERTY_NAME) != null && (name = adapterNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue()).equals(elementToRemove.getName())) {
                            document.getDocumentElement().removeChild(adapterNode);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                    }
                    ++i;
                }
                indexFile.delete();
                if (adapterNodes.getLength() > 0) {
                    indexFile.createNewFile();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(new FileOutputStream(indexFile));
                    indexFile.createNewFile();
                    transformer.transform(source, result);
                }
                this.deleteElementResources(elementToRemove);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
        } else {
            this.deleteElementResources(elementToRemove);
        }
        this.firePropertyChange(elementToRemove, null, ICompositeElementModifyListener.OPERATION_TYPE.DELETE);
    }

    private void checkResources(JRChild newElement, JasperReportsConfiguration jConfig, JRDesignDataset dataset, JRBand band, File resourcesDir, HashSet<String> foundResources) {
        JRExpression exp;
        String expression;
        if (newElement instanceof JRDesignImage && (expression = ExpressionUtil.cachedExpressionEvaluationString(exp = ((JRDesignImage)newElement).getExpression(), jConfig, dataset)) != null) {
            URI resourceURI = null;
            try {
                resourceURI = new URI(expression);
            }
            catch (Exception exception) {
                URIBuilder builder = new URIBuilder();
                builder.setScheme("file");
                builder.setPath(expression);
                try {
                    resourceURI = builder.build();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            if (resourceURI != null) {
                resourcesDir.mkdir();
                File dest = new File(resourcesDir, FilenameUtils.getName((String)resourceURI.getPath()));
                JRDesignImage newImage = (JRDesignImage)newElement;
                try {
                    if (!dest.exists()) {
                        org.apache.commons.io.FileUtils.copyURLToFile((URL)resourceURI.toURL(), (File)dest);
                    }
                    newImage.setExpression((JRExpression)new JRDesignExpression("\"" + dest.getAbsolutePath() + "\""));
                    String requiredResources = band.getPropertiesMap().getProperty(REQUIRED_RESOURCES);
                    if (!foundResources.contains(dest.getName())) {
                        if (requiredResources == null) {
                            band.getPropertiesMap().setProperty(REQUIRED_RESOURCES, dest.getName());
                        } else {
                            requiredResources = String.valueOf(requiredResources) + ";" + dest.getName();
                            band.getPropertiesMap().setProperty(REQUIRED_RESOURCES, requiredResources);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
        }
        if (newElement instanceof JRElementGroup) {
            for (JRChild childElement : ((JRElementGroup)newElement).getChildren()) {
                this.checkResources(childElement, jConfig, dataset, band, resourcesDir, foundResources);
            }
        }
    }

    private JasperDesign createDesign(String name, List<Object> elementContents, File resourcesDir) {
        Integer leftOffset = null;
        Integer topOffset = null;
        for (Object element : elementContents) {
            MGraphicElement gElement = (MGraphicElement)element;
            int elementX = gElement.getValue().getX();
            int elementY = gElement.getValue().getY();
            if (leftOffset == null || leftOffset > elementX) {
                leftOffset = elementX;
            }
            if (topOffset != null && topOffset <= elementY) continue;
            topOffset = elementY;
        }
        JasperDesign jd = new JasperDesign();
        jd.setJasperReportsContext((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
        jd.setName(name);
        jd.setColumnFooter(null);
        jd.setColumnHeader(null);
        jd.setPageFooter(null);
        jd.setPageHeader(null);
        jd.setSummary(null);
        jd.setBackground(null);
        jd.setLeftMargin(0);
        jd.setRightMargin(0);
        jd.setTopMargin(0);
        jd.setBottomMargin(0);
        JRDesignBand band = new JRDesignBand();
        int maxHeight = 0;
        int maxWidth = 0;
        for (Object element : elementContents) {
            MGraphicElement mOriginalElement = (MGraphicElement)element;
            JRDesignElement originalElement = mOriginalElement.getValue();
            JRDesignElement newElement = (JRDesignElement)originalElement.clone();
            CustomStyleResolver.copyInheritedAttributes(mOriginalElement, newElement);
            newElement.setStyle(null);
            newElement.setStyleNameReference(null);
            newElement.setX(originalElement.getX() - leftOffset);
            newElement.setY(originalElement.getY() - topOffset);
            if (newElement.getWidth() + newElement.getX() > maxWidth) {
                maxWidth = newElement.getWidth() + newElement.getX();
            }
            if (newElement.getHeight() + newElement.getY() > maxHeight) {
                maxHeight = newElement.getHeight() + newElement.getY();
            }
            JRDesignDataset jrd = ModelUtils.getFirstDatasetInHierarchy(mOriginalElement);
            this.checkResources((JRChild)newElement, mOriginalElement.getJasperConfiguration(), jrd, (JRBand)band, resourcesDir, new HashSet<String>());
            band.addElement(newElement);
        }
        jd.setTitle((JRBand)band);
        band.setHeight(maxHeight);
        jd.setPageWidth(maxWidth);
        String noteValue = MessageFormat.format(NOTE_TEMPLATE, Messages.ToolManager_noteText, maxWidth + 5);
        jd.setProperty("ireport.callouts", noteValue);
        return jd;
    }

    public void addCompositeElement(String name, String description, String groupID, ImageData iconSmall, ImageData iconBig, List<Object> elementContents) {
        File storage = ConfigurationManager.getStorage(ELEMENTS_STORAGE_KEY);
        File resourcesDir = new File(storage, name);
        JasperDesign jd = this.createDesign(name, elementContents, resourcesDir);
        if (!this.addCompositeElement(name, description, groupID, iconSmall, iconBig, jd)) {
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)resourcesDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
    }

    private String getImageBigName(String compositeElementName) {
        return String.valueOf(compositeElementName) + "-big" + System.currentTimeMillis() + ".png";
    }

    private String getImageSmallName(String compositeElementName) {
        return String.valueOf(compositeElementName) + "-small" + System.currentTimeMillis() + ".png";
    }

    public void editCompositeElement(MCompositeElement oldElement, String newName, String newDescription, String newGroup, ImageData iconSmall, ImageData iconBig) {
        block15: {
            File storage = ConfigurationManager.getStorage(ELEMENTS_STORAGE_KEY);
            try {
                File indexFile;
                String oldName = oldElement.getName();
                if (oldElement.getIconPathSmall() != null) {
                    File oldIconSmall = new File(oldElement.getIconPathSmall());
                    oldIconSmall.delete();
                }
                if (oldElement.getIconPathBig() != null) {
                    File oldIconBig = new File(oldElement.getIconPathBig());
                    oldIconBig.delete();
                }
                String oldReportName = String.valueOf(oldName) + COMPOSITE_ELEMENT_EXTENSION;
                String newReportName = String.valueOf(newName) + COMPOSITE_ELEMENT_EXTENSION;
                File oldReportFile = new File(storage, oldReportName);
                if (oldReportFile.exists()) {
                    oldReportFile.renameTo(new File(storage, newReportName));
                }
                String imageSmallName = this.getImageSmallName(newName);
                if (iconSmall != null) {
                    this.writeImage(new File(storage, imageSmallName), iconSmall);
                }
                String imageBigName = this.getImageBigName(newName);
                if (iconBig != null) {
                    this.writeImage(new File(storage, imageBigName), iconBig);
                }
                if (!(indexFile = new File(storage, INDEX_FILE_NAME)).exists()) break block15;
                String xmlContent = CompositeElementManager.readFile(indexFile);
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlContent)));
                NodeList adapterNodes = document.getElementsByTagName(XML_TAG_NAME);
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    try {
                        String name;
                        Node adapterNode = adapterNodes.item(i);
                        if (adapterNode.getNodeType() == 1 && adapterNode.getAttributes().getNamedItem(PROPERTY_NAME) != null && (name = adapterNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue()).equals(oldName)) {
                            Element element = (Element)adapterNode;
                            element.setAttribute(PROPERTY_NAME, newName);
                            element.setAttribute(PROPERTY_DESCRIPTION, newDescription);
                            element.setAttribute(PROPERTY_GROUP, newGroup);
                            element.setAttribute(PROPERTY_PATH, newReportName);
                            if (iconSmall != null) {
                                element.setAttribute(PROPERTY_ICON_SMALL, imageSmallName);
                            } else {
                                element.removeAttribute(PROPERTY_ICON_SMALL);
                            }
                            if (iconBig != null) {
                                element.setAttribute(PROPERTY_ICON_BIG, imageBigName);
                                break;
                            }
                            element.removeAttribute(PROPERTY_ICON_BIG);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                    }
                    ++i;
                }
                indexFile.delete();
                if (adapterNodes.getLength() > 0) {
                    indexFile.createNewFile();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(new FileOutputStream(indexFile));
                    indexFile.createNewFile();
                    transformer.transform(source, result);
                }
                this.cachedElementssMap.remove(oldElement.getPath());
                this.loadElements();
                this.firePropertyChange(oldElement, this.getElemenetByName(newName), ICompositeElementModifyListener.OPERATION_TYPE.EDIT);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
        }
    }

    public MCompositeElement getElemenetByName(String name) {
        for (MCompositeElement element : this.availableElements) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public boolean addCompositeElement(String name, String description, String groupID, ImageData iconSmall, ImageData iconBig, JasperDesign jd, File resourceDir) {
        boolean result = this.addCompositeElement(name, description, groupID, iconSmall, iconBig, jd);
        if (result && resourceDir != null && resourceDir.exists()) {
            try {
                org.apache.commons.io.FileUtils.copyDirectory((File)resourceDir, (File)this.getResourceDir(name));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean addCompositeElement(String name, String description, String groupID, ImageData iconSmall, ImageData iconBig, JasperDesign jd) {
        block13: {
            Assert.isTrue((!this.isNameAlreadyUsed(name) ? 1 : 0) != 0, (String)"The name must be unique");
            File storage = ConfigurationManager.getStorage(ELEMENTS_STORAGE_KEY);
            try {
                String reportName = String.valueOf(name) + COMPOSITE_ELEMENT_EXTENSION;
                File reportFile = new File(storage, reportName);
                String contents = JRXmlWriterHelper.writeReport((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance(), (JRReport)jd, "last");
                BufferedWriter writer = new BufferedWriter(new FileWriter(reportFile));
                writer.write(contents);
                writer.close();
                String imageSmallName = this.getImageSmallName(name);
                if (iconSmall != null) {
                    this.writeImage(new File(storage, imageSmallName), iconSmall);
                }
                String imageBigName = this.getImageBigName(name);
                if (iconBig != null) {
                    this.writeImage(new File(storage, imageBigName), iconBig);
                }
                File indexFile = new File(storage, INDEX_FILE_NAME);
                Document document = null;
                Element root = null;
                if (indexFile.exists()) {
                    String xmlContent = CompositeElementManager.readFile(indexFile);
                    document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlContent)));
                    root = document.getDocumentElement();
                } else {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    document = builder.newDocument();
                    root = document.createElement("elements");
                    document.appendChild(root);
                }
                FileOutputStream oStream = null;
                try {
                    try {
                        Element newNode = document.createElement(XML_TAG_NAME);
                        newNode.setAttribute(PROPERTY_NAME, name);
                        newNode.setAttribute(PROPERTY_PATH, reportName);
                        newNode.setAttribute(PROPERTY_DESCRIPTION, description);
                        newNode.setAttribute(PROPERTY_GROUP, groupID);
                        if (iconSmall != null) {
                            newNode.setAttribute(PROPERTY_ICON_SMALL, imageSmallName);
                        }
                        if (iconBig != null) {
                            newNode.setAttribute(PROPERTY_ICON_BIG, imageBigName);
                        }
                        root.appendChild(newNode);
                        indexFile.delete();
                        indexFile.createNewFile();
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        DOMSource source = new DOMSource(document);
                        oStream = new FileOutputStream(indexFile);
                        StreamResult result = new StreamResult(oStream);
                        indexFile.createNewFile();
                        transformer.transform(source, result);
                        MCompositeElement newElement = CompositeElementManager.createElementFromNode(newNode);
                        this.availableElements.add(newElement);
                        this.firePropertyChange(null, newElement, ICompositeElementModifyListener.OPERATION_TYPE.ADD);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                        FileUtils.closeStream(oStream);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(oStream);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)oStream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
                return false;
            }
        }
        return true;
    }

    public Command getCommand(ANode parent, MCompositeElement element, Rectangle location, int newIndex) {
        JSSCompoundCommand cmd = new JSSCompoundCommand(parent){

            @Override
            public void execute() {
                boolean defaultValue = DefaultManager.INSTANCE.isDisabled();
                super.execute();
                DefaultManager.INSTANCE.setDisabled(defaultValue);
            }
        };
        Pair<JRBand, JasperDesign> compositeElement = this.getElementContainer(element.getPath());
        JRBand elementContent = (JRBand)compositeElement.getKey();
        for (JRChild child : elementContent.getChildren()) {
            JRDesignElement designElement = (JRDesignElement)child;
            if (!(child instanceof JRDesignElement)) continue;
            MGraphicElement model = new MGraphicElement();
            model.setValue(designElement.clone());
            Rectangle relativeLocation = null;
            relativeLocation = location == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(location);
            relativeLocation.x += designElement.getX();
            relativeLocation.y += designElement.getY();
            relativeLocation.width = designElement.getWidth();
            relativeLocation.height = designElement.getHeight();
            Command createCommand = OutlineTreeEditPartFactory.getCreateCommand(parent, model, relativeLocation, newIndex);
            if (createCommand == null) continue;
            cmd.add(createCommand);
        }
        return cmd;
    }

    public void addModifyListener(ICompositeElementModifyListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void loadElements() {
        this.availableElements.clear();
        File indexFile = ConfigurationManager.getStorageResource(ELEMENTS_STORAGE_KEY, INDEX_FILE_NAME);
        if (indexFile != null && indexFile.exists()) {
            try {
                String xmlContent = CompositeElementManager.readFile(indexFile);
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xmlContent)));
                NodeList adapterNodes = document.getElementsByTagName(XML_TAG_NAME);
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    try {
                        MCompositeElement loadedElement;
                        Node adapterNode = adapterNodes.item(i);
                        if (adapterNode.getNodeType() == 1 && adapterNode.getAttributes().getNamedItem(PROPERTY_NAME) != null && (loadedElement = CompositeElementManager.createElementFromNode(adapterNode)) != null) {
                            this.availableElements.add(loadedElement);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(ex);
            }
        }
    }

    private static MCompositeElement createElementFromNode(Node adapterNode, File locationFolder) {
        String name = adapterNode.getAttributes().getNamedItem(PROPERTY_NAME).getNodeValue();
        String path = adapterNode.getAttributes().getNamedItem(PROPERTY_PATH).getNodeValue();
        File contentFile = new File(locationFolder, path);
        if (contentFile.exists()) {
            Node descriptionNode;
            File resource;
            String iconPath;
            String absoluteIconPathSmall = null;
            String absoluteIconPathBig = null;
            Node iconNode = adapterNode.getAttributes().getNamedItem(PROPERTY_ICON_SMALL);
            String string = iconPath = iconNode != null ? iconNode.getNodeValue() : null;
            if (iconPath != null) {
                resource = new File(locationFolder, iconPath);
                absoluteIconPathSmall = resource.getAbsolutePath();
            }
            String string2 = iconPath = (iconNode = adapterNode.getAttributes().getNamedItem(PROPERTY_ICON_BIG)) != null ? iconNode.getNodeValue() : null;
            if (iconPath != null) {
                resource = new File(locationFolder, iconPath);
                absoluteIconPathBig = resource.getAbsolutePath();
            }
            String description = (descriptionNode = adapterNode.getAttributes().getNamedItem(PROPERTY_DESCRIPTION)) != null && descriptionNode.getNodeValue() != null ? descriptionNode.getNodeValue() : "A user defined composite element";
            Node groupIDNode = adapterNode.getAttributes().getNamedItem(PROPERTY_GROUP);
            String groupID = groupIDNode != null ? groupIDNode.getNodeValue() : "com.jaspersoft.studio.COMMON_TOOLS";
            return new MCompositeElement(name, description, groupID, contentFile.getAbsolutePath(), absoluteIconPathSmall, absoluteIconPathBig);
        }
        return null;
    }

    private static MCompositeElement createElementFromNode(Node adapterNode) {
        File contentFolder = ConfigurationManager.getStorage(ELEMENTS_STORAGE_KEY);
        return CompositeElementManager.createElementFromNode(adapterNode, contentFolder);
    }

    private void writeImage(File destination, ImageData image) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image};
        loader.save(destination.getAbsolutePath(), 5);
    }

    private void deleteElementResources(MCompositeElement elementToRemove) {
        File elementResourceDir;
        File contentFile = new File(elementToRemove.getPath());
        contentFile.delete();
        if (elementToRemove.getIconPathSmall() != null) {
            File iconSmall = new File(elementToRemove.getIconPathSmall());
            iconSmall.delete();
        }
        if (elementToRemove.getIconPathBig() != null) {
            File iconBig = new File(elementToRemove.getIconPathBig());
            iconBig.delete();
        }
        if ((elementResourceDir = new File(contentFile.getParentFile(), elementToRemove.getName())).exists()) {
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)elementResourceDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
    }

    private static String readFile(File file) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Pair<JRBand, JasperDesign> loadElementModel(File defaultFile) {
        Pair result;
        block5: {
            ByteArrayInputStream in = null;
            result = null;
            try {
                try {
                    in = new ByteArrayInputStream(org.apache.commons.io.FileUtils.readFileToByteArray((File)defaultFile));
                    JasperReportsConfiguration jConfig = this.getDefaultJRConfig();
                    JasperDesign design = new JRXmlLoader((JasperReportsContext)jConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)jConfig)).loadXML((InputStream)in);
                    jConfig.setJasperDesign(design);
                    JRBand band = design.getTitle();
                    result = new Pair((Object)band, (Object)design);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream((Closeable)in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(in);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)in);
        }
        return result;
    }

    private Pair<JRBand, JasperDesign> getElementContainer(String path) {
        Pair<JRBand, JasperDesign> result;
        if (this.cachedElementssMap.containsKey(path)) {
            return this.cachedElementssMap.get(path);
        }
        File contentFile = new File(path);
        if (contentFile.exists() && (result = this.loadElementModel(contentFile)) != null) {
            this.cachedElementssMap.put(path, result);
            return result;
        }
        return null;
    }

    private JasperReportsConfiguration getDefaultJRConfig() {
        return new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
    }

    protected void firePropertyChange(MCompositeElement oldElement, MCompositeElement newElement, ICompositeElementModifyListener.OPERATION_TYPE operation) {
        for (ICompositeElementModifyListener listener : this.listeners) {
            listener.elementChanged(oldElement, newElement, operation);
        }
    }

    private void iterateResourceDelta(IResourceDelta delta, List<IFile> editedResources) {
        if (delta.getKind() == 4 && delta.getResource().getName().toLowerCase().endsWith(COMPOSITE_ELEMENT_EXTENSION) && delta.getResource() instanceof IFile) {
            editedResources.add((IFile)delta.getResource());
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta affectedResource = iResourceDeltaArray[n2];
            this.iterateResourceDelta(affectedResource, editedResources);
            ++n2;
        }
    }

    public File getResourceDir(String name) {
        File storage = ConfigurationManager.getStorage(ELEMENTS_STORAGE_KEY);
        File result = new File(storage, name);
        result.mkdirs();
        return result;
    }
}

