/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class CenterInParentAction
extends AbstractFormattingAction {
    public static final String ID = "centerinparent";

    public CenterInParentAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CenterInParentAction_actionName);
        this.setToolTipText(Messages.CenterInParentAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/align-container-center.png"));
    }

    public static JSSCompoundCommand generateCommand(List<APropertyNode> nodes) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        if (nodes.isEmpty()) {
            return command;
        }
        for (APropertyNode element : nodes) {
            command.setReferenceNodeIfNull(element);
            ANode parent = element.getParent();
            Dimension parentBounds = null;
            if (parent instanceof IContainer) {
                if (parent instanceof MBand) {
                    int h = ((MBand)parent).getValue().getHeight();
                    JasperDesign jasperDesign = element.getJasperDesign();
                    int w = jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin();
                    parentBounds = new Dimension(w, h);
                } else if (parent instanceof IGraphicElementContainer) {
                    parentBounds = ((IGraphicElementContainer)((Object)parent)).getSize();
                }
            }
            if (parentBounds == null) continue;
            JRDesignElement jrElement = (JRDesignElement)element.getValue();
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(element);
            setCommand.setPropertyId("x");
            setCommand.setPropertyValue(parentBounds.width / 2 - jrElement.getWidth() / 2);
            command.add(setCommand);
            setCommand = new SetValueCommand();
            setCommand.setTarget(element);
            setCommand.setPropertyId("y");
            setCommand.setPropertyValue(parentBounds.height / 2 - jrElement.getHeight() / 2);
            command.add(setCommand);
        }
        return command;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = null;
        if (!nodes.isEmpty()) {
            command = CenterInParentAction.generateCommand(nodes);
            command.setDebugLabel(this.getText());
        }
        return command;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 0;
    }
}

