/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.formatting.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.formatting.actions.AbstractFormattingAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class EqualsHSpaceAction
extends AbstractFormattingAction {
    public static final String ID = "samehspace";

    public EqualsHSpaceAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EqualsHSpaceAction_actionName);
        this.setToolTipText(Messages.EqualsHSpaceAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/elem_add_hspace.png"));
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getOperationSet().size() > 1;
    }

    public static JSSCompoundCommand generateCommand(List<APropertyNode> nodes) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        if (nodes.isEmpty()) {
            return command;
        }
        List<APropertyNode> sortedElements = EqualsHSpaceAction.sortXY(nodes);
        int gap = 0;
        int usedSpace = 0;
        JRDesignElement jrElement = (JRDesignElement)sortedElements.get(0).getValue();
        int minX = jrElement.getX();
        int maxX = minX + jrElement.getWidth();
        for (APropertyNode element : sortedElements) {
            command.setReferenceNodeIfNull(element);
            jrElement = (JRDesignElement)element.getValue();
            if (minX > jrElement.getX()) {
                minX = jrElement.getX();
            }
            if (maxX < jrElement.getX() + jrElement.getWidth()) {
                maxX = jrElement.getX() + jrElement.getWidth();
            }
            usedSpace += jrElement.getWidth();
        }
        gap = (maxX - minX - usedSpace) / (nodes.size() - 1);
        int actualX = minX;
        int i = 0;
        while (i < sortedElements.size()) {
            APropertyNode element = sortedElements.get(i);
            jrElement = (JRDesignElement)element.getValue();
            if (i == 0) {
                actualX = jrElement.getX() + jrElement.getWidth() + gap;
            } else {
                int setX = i == sortedElements.size() - 1 ? maxX - jrElement.getWidth() : actualX;
                SetValueCommand setCommand = new SetValueCommand();
                setCommand.setTarget(element);
                setCommand.setPropertyId("x");
                setCommand.setPropertyValue(setX);
                command.add(setCommand);
                actualX = setX + jrElement.getWidth() + gap;
            }
            ++i;
        }
        return command;
    }

    @Override
    protected Command createCommand() {
        List<APropertyNode> nodes = this.getOperationSet();
        JSSCompoundCommand command = null;
        if (!nodes.isEmpty()) {
            command = EqualsHSpaceAction.generateCommand(nodes);
            command.setDebugLabel(this.getText());
        }
        return command;
    }
}

