/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.handlers;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.MoveT2TButtons;
import com.jaspersoft.studio.templates.DefaultTemplateProvider;
import com.jaspersoft.studio.templates.StudioTemplateManager;
import com.jaspersoft.studio.templates.TemplateProvider;
import com.jaspersoft.studio.wizards.BuiltInCategories;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import com.jaspersoft.templates.TemplateBundle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class CategoriesPage
extends JSSWizardPage {
    protected List<Category> inFields;
    protected List<Category> outFileds;
    protected List<String> categoriesSelected = new ArrayList<String>();
    protected Table rightTable;
    private Table leftTable;
    private Combo engineCombo = null;
    protected String[] engineKeys;
    private MoveT2TButtons mt2t = null;
    private HashMap<String, TemplateProvider> providersMap = new HashMap();

    protected CategoriesPage() {
        super("addcategories");
        this.setTitle(Messages.CategoriesPage_pageTitle);
        this.setDescription(Messages.CategoriesPage_pageDescription);
        HashSet<String> foundCategories = new HashSet<String>();
        List<String> builtInCat = BuiltInCategories.getCategoriesList();
        builtInCat = builtInCat.subList(1, builtInCat.size());
        this.inFields = new ArrayList<Category>();
        for (String cat : builtInCat) {
            this.inFields.add(new Category(cat, false));
            foundCategories.add(cat.toLowerCase());
        }
        List<TemplateBundle> bundles = StudioTemplateManager.getInstance().getTemplateBundles();
        for (TemplateBundle b : bundles) {
            String[] strCategoryList;
            Object templateCategory = b.getProperty("template.category");
            if (templateCategory == null) continue;
            String[] stringArray = strCategoryList = templateCategory.toString().split("\n");
            int n = strCategoryList.length;
            int n2 = 0;
            while (n2 < n) {
                String lowerCaseCateogry;
                String cat = stringArray[n2];
                String trimmedCategory = cat.trim();
                if (!trimmedCategory.isEmpty() && !foundCategories.contains(lowerCaseCateogry = trimmedCategory.toLowerCase())) {
                    String categoryLocalizedName = trimmedCategory;
                    this.inFields.add(new Category(categoryLocalizedName, false));
                    foundCategories.add(lowerCaseCateogry);
                }
                ++n2;
            }
        }
        this.outFileds = new ArrayList<Category>();
    }

    private void createTopPanel(Composite parent) {
        Composite topPanel = new Composite(parent, 0);
        topPanel.setLayout((Layout)new GridLayout(2, false));
        new Label(topPanel, 0).setText(Messages.CategoriesPage_typeLabel);
        this.engineCombo = new Combo(topPanel, 8);
        ArrayList<TemplateProvider> templateProviders = new ArrayList<TemplateProvider>();
        templateProviders.add(new DefaultTemplateProvider());
        templateProviders.addAll(JaspersoftStudioPlugin.getExtensionManager().getTemplateProviders());
        this.engineKeys = new String[templateProviders.size()];
        String[] engineNames = new String[templateProviders.size()];
        int i = 0;
        while (i < templateProviders.size()) {
            TemplateProvider actualProvider = (TemplateProvider)templateProviders.get(i);
            this.engineKeys[i] = actualProvider.getProviderKey();
            this.providersMap.put(this.engineKeys[i], actualProvider);
            engineNames[i] = actualProvider.getProviderName();
            ++i;
        }
        this.engineCombo.setItems(engineNames);
        this.engineCombo.select(0);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)panel);
        this.createTopPanel(panel);
        Composite composite = new Composite(panel, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label categoryDescriptionsLabel = new Label(composite, 0);
        categoryDescriptionsLabel.setText(Messages.CategoriesPage_categoriesLabel);
        categoryDescriptionsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Composite leftPanel = new Composite(composite, 0);
        GridLayout leftLayout = new GridLayout(2, false);
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 5;
        leftLayout.marginHeight = 0;
        leftLayout.marginWidth = 0;
        leftPanel.setLayout((Layout)leftLayout);
        leftPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.leftTable = new Table(leftPanel, 68098);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        this.leftTable.setLayoutData((Object)gd);
        this.leftTable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.leftTable, 0)};
        col[0].setText(Messages.CategoriesPage_availabelCatLabel);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.leftTable.setLayout((Layout)tlayout);
        final Text customCategory = new Text(leftPanel, 2048);
        customCategory.setToolTipText(Messages.CategoriesPage_customCatBox);
        customCategory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final TableViewer leftTView = new TableViewer(this.leftTable);
        leftTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.setLabelProvider(leftTView);
        this.createMenu(leftTView);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.rightTable = new Table(composite, 68098);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.rightTable.setLayoutData((Object)gd);
        this.rightTable.setHeaderVisible(true);
        this.createColumns();
        TableViewer rightTView = new TableViewer(this.rightTable);
        rightTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.setLabelProvider(rightTView);
        this.createMenu(rightTView);
        leftTView.setInput(this.inFields);
        rightTView.setInput(this.outFileds);
        final Button addCustomButton = new Button(leftPanel, 0);
        addCustomButton.setText(Messages.CategoriesPage_addButton);
        addCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CategoriesPage.this.inFields.add(new Category(customCategory.getText(), true));
                customCategory.setText("");
                leftTView.refresh();
            }
        });
        addCustomButton.setEnabled(false);
        customCategory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = customCategory.getText().trim();
                if (text.isEmpty() || CategoriesPage.this.isCategoryAlreadyExisting(text)) {
                    addCustomButton.setEnabled(false);
                } else {
                    addCustomButton.setEnabled(true);
                }
            }
        });
        this.mt2t = new MoveT2TButtons();
        this.mt2t.createButtons(bGroup, (ColumnViewer)leftTView, rightTView);
        this.mt2t.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                CategoriesPage.this.storeSettings();
            }
        });
    }

    private boolean isCategoryAlreadyExisting(String newCategory) {
        String name;
        for (Category category : this.inFields) {
            name = category.name;
            if (!newCategory.equalsIgnoreCase(name)) continue;
            return true;
        }
        for (Category category : this.outFileds) {
            name = category.name;
            if (!newCategory.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void storeSettings() {
        this.categoriesSelected.clear();
        TableItem[] tableItemArray = this.rightTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.categoriesSelected.add(((Category)item.getData()).name);
            ++n2;
        }
    }

    public void finish(String reportName, String destinationPath) {
        Properties props = new Properties();
        props.setProperty("template.name", reportName);
        String categories = "";
        for (String cat : this.categoriesSelected) {
            categories = categories.concat(cat).concat("\n");
        }
        if (!categories.isEmpty()) {
            categories = categories.substring(0, categories.length() - 1);
            props.setProperty("template.category", categories);
        }
        String engine = this.engineCombo != null ? this.engineKeys[this.engineCombo.getSelectionIndex()] : this.engineKeys[0];
        props.setProperty("template.engine", engine);
        String path = destinationPath.substring(0, destinationPath.lastIndexOf(".jrxml"));
        path = path.concat("_descriptor.properties");
        File f = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(f);
            props.store(out, "");
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> validateWithSelectedEngine(JasperReportsContext jrContext, JasperDesign design) {
        String engine = this.engineCombo != null ? this.engineKeys[this.engineCombo.getSelectionIndex()] : this.engineKeys[0];
        return this.providersMap.get(engine).validateTemplate(jrContext, design);
    }

    protected void createColumns() {
        TableColumn[] col = new TableColumn[]{new TableColumn(this.rightTable, 0)};
        col[0].setText(Messages.CategoriesPage_selectedCatLabel);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Category category = (Category)element;
                String name = category.name;
                if (MessagesByKeys.hasTranslation(name)) {
                    return MessagesByKeys.getString(name);
                }
                return name;
            }
        });
    }

    protected void createMenu(final TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        final Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                final int selected = table.getSelectionIndex();
                final List input = (List)tableViewer.getInput();
                if (selected < 0 || selected >= input.size()) {
                    return;
                }
                Category selectedCategory = (Category)input.get(selected);
                if (!selectedCategory.isNew) {
                    return;
                }
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText(Messages.common_delete);
                newItem.setImage(ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"/icons/resources/delete_style.gif"));
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        input.remove(selected);
                        tableViewer.refresh();
                    }
                });
            }
        });
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_EXPORTED_CATEGORY;
    }

    private class Category {
        private String name;
        private boolean isNew;

        public Category(String name, boolean isNew) {
            this.name = name;
            this.isNew = isNew;
        }
    }
}

