/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.handlers;

import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.handlers.ConflictDetailsError;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.templates.JrxmlTemplateBundle;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import com.jaspersoft.templates.TemplateBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResourcePage
extends JSSHelpWizardPage {
    private TemplateBundle bundle;
    private TableViewer tableViewer;
    private Text pathText;
    private List<File> resourceList;
    private JasperReportsConfiguration jrContext;
    private IFile reportFile;
    private String pathString;
    private boolean conflictResources;

    protected ResourcePage(IFile reportFile) {
        super("exportresources");
        this.setTitle(Messages.ResourcePage_pageTitle);
        this.setDescription(Messages.ResourcePage_pageDescription);
        this.conflictResources = false;
        this.reportFile = reportFile;
        this.setPageComplete(false);
        try {
            this.jrContext = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), reportFile);
            this.bundle = new JrxmlTemplateBundle(reportFile.getLocationURI().toURL(), true, (JasperReportsContext)this.jrContext);
            this.jrContext.setJasperDesign(this.bundle.getJasperDesign());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_EXPORTED_RESOURCES;
    }

    public JasperDesign getDesign() {
        return this.bundle.getJasperDesign();
    }

    public JasperReportsConfiguration getJRConfiguration() {
        return this.jrContext;
    }

    public String getDestinationPath() {
        return this.pathString;
    }

    public IWizardPage getNextPage() {
        this.pathString = this.pathText.getText();
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        Table table = new Table(composite, 68098);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(table, 0)};
        col[0].setText(Messages.ResourcePage_exportedResourceLabel.trim());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, false));
        table.setLayout((Layout)tlayout);
        TableColumn[] tableColumnArray = col;
        int n = col.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
        Composite pathComposite = new Composite(composite, 0);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(1808);
        pathComposite.setLayoutData((Object)gd);
        new Label(pathComposite, 0).setText(Messages.ResourcePage_destinationFolderLabel);
        this.pathText = new Text(pathComposite, 2048);
        this.pathText.setEditable(false);
        gd = new GridData(4, 1024, true, false);
        this.pathText.setLayoutData((Object)gd);
        Button browseButton = new Button(pathComposite, 0);
        browseButton.setText(Messages.ResourcePage_browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell(), 8192);
                fd.setText(Messages.ExportImageAction_saveDialogTitle);
                String[] filterExt = new String[]{"*.jrxml"};
                fd.setFileName(ResourcePage.this.bundle.getLabel());
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    RunnableOverwriteQuestion.RESPONSE_TYPE response;
                    File checkExisting = new File(selected);
                    boolean doIt = true;
                    if (checkExisting.exists() && !RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE.equals((Object)(response = RunnableOverwriteQuestion.showQuestion((String)Messages.ResourcePage_templateAlreadyExistTitle, (String)Messages.ResourcePage_templateAlreadyExistMessage, (boolean)false)))) {
                        doIt = false;
                    }
                    if (doIt) {
                        ResourcePage.this.pathText.setText(selected);
                        if (!ResourcePage.this.conflictResources) {
                            ResourcePage.this.setPageComplete(true);
                        }
                    }
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.fillData();
    }

    private void createErrorMessage(List<String> conflicts) {
        StringBuilder conf = new StringBuilder();
        int i = 0;
        while (i < conflicts.size()) {
            conf.append(conflicts.get(i).concat("\n").concat(conflicts.get(i + 1)).concat("\n\n"));
            i += 2;
        }
        OperationStatus status = new OperationStatus(4, JasperReportsPlugin.getDefault().getPluginID(), 1, conf.toString(), null);
        new ConflictDetailsError(UIUtils.getShell(), Messages.ResourcePage_conflictTitle, Messages.ResourcePage_conflictMessage, (IStatus)status, 7){

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(newShellStyle | 0x10000000);
            }
        }.open();
    }

    public void fillData() {
        this.resourceList = this.getResourceNames();
        HashMap<String, File> resourceMap = new HashMap<String, File>();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (File actualResource : this.resourceList) {
            if (resourceMap.containsKey(actualResource.getName())) {
                File conflictFile = (File)resourceMap.get(actualResource.getName());
                if (conflictFile.getAbsolutePath().equals(actualResource.getAbsolutePath())) continue;
                conflicts.add(actualResource.getAbsolutePath());
                conflicts.add(conflictFile.getAbsolutePath());
                continue;
            }
            resourceMap.put(actualResource.getName(), actualResource);
        }
        ArrayList<File> exportedResource = new ArrayList<File>();
        exportedResource.add(this.reportFile.getLocation().toFile());
        exportedResource.addAll(this.resourceList);
        this.tableViewer.setInput(exportedResource);
        this.tableViewer.refresh();
        if (!conflicts.isEmpty()) {
            this.conflictResources = true;
            this.createErrorMessage(conflicts);
        }
    }

    protected File findFile(IFile file, String str) {
        if (str == null) {
            return null;
        }
        return FileUtils.resolveFile((String)str, Arrays.asList(new File(file.getParent().getLocationURI()), new File("."), new File(file.getProject().getLocationURI())), (boolean)true);
    }

    private String evalResourceName(JRExpression exp) {
        return ExpressionUtil.cachedExpressionEvaluationString(exp, this.jrContext);
    }

    private String model2xml() {
        String xml = null;
        try {
            JasperDesign report = this.bundle.getJasperDesign();
            report.removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
            String version = this.jrContext.getProperty("com.jaspersoft.studio.compatibility.version", "last");
            xml = JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrContext, (JRReport)report, "UTF-8", version);
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return xml;
    }

    private void copyFile(File inputFile, File outputFile) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)inputFile, (File)outputFile);
    }

    private void saveReport() {
        JasperDesign jd = this.bundle.getJasperDesign();
        if (jd != null) {
            this.rebindResources();
            try {
                File destination = new File(this.pathText.getText());
                org.apache.commons.io.FileUtils.writeStringToFile((File)destination, (String)this.model2xml(), (String)"UTF-8");
                String destinationPath = String.valueOf(destination.getParent()) + System.getProperty("file.separator");
                for (File resource : this.resourceList) {
                    this.copyFile(resource, new File(destinationPath.concat(resource.getName())));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean finish() {
        this.saveReport();
        return true;
    }

    private void rebindResources() {
        String res;
        File resFile;
        List<JRDesignElement> list = ModelUtils.getAllGElements(this.bundle.getJasperDesign());
        for (JRDesignElement el : list) {
            JRDesignSubreport sr;
            JRDesignImage im;
            if (el instanceof JRDesignImage && (resFile = this.findFile(this.reportFile, res = this.evalResourceName((im = (JRDesignImage)el).getExpression()))) != null) {
                im.setExpression((JRExpression)new JRDesignExpression("\"" + resFile.getName() + "\""));
            }
            if (!(el instanceof JRDesignSubreport) || (res = this.evalResourceName((sr = (JRDesignSubreport)el).getExpression())) == null || !res.endsWith(".jasper")) continue;
            res = String.valueOf(res.substring(0, res.length() - ".jasper".length())) + ".jrxml";
            resFile = this.findFile(this.reportFile, res);
            sr.setExpression((JRExpression)new JRDesignExpression("\"" + resFile.getName() + "\""));
        }
        List templates = this.bundle.getJasperDesign().getTemplatesList();
        for (JRReportTemplate t : templates) {
            res = this.evalResourceName(t.getSourceExpression());
            if (res == null || !(t instanceof JRDesignReportTemplate)) continue;
            resFile = this.findFile(this.reportFile, res);
            ((JRDesignReportTemplate)t).setSourceExpression((JRExpression)new JRDesignExpression("\"" + resFile.getName() + "\""));
        }
    }

    public List<File> getResourceNames() {
        String res;
        File resFile;
        ArrayList<File> resourceNames = new ArrayList<File>();
        HashSet<String> alredyAddedElements = new HashSet<String>();
        List<JRDesignElement> list = ModelUtils.getAllGElements(this.bundle.getJasperDesign());
        for (JRDesignElement el : list) {
            JRSubreport sr;
            JRImage im;
            if (el instanceof JRImage && (resFile = this.findFile(this.reportFile, res = this.evalResourceName((im = (JRImage)el).getExpression()))) != null && !alredyAddedElements.contains(resFile.getAbsolutePath())) {
                resourceNames.add(resFile);
                alredyAddedElements.add(resFile.getAbsolutePath());
            }
            if (!(el instanceof JRSubreport) || (res = this.evalResourceName((sr = (JRSubreport)el).getExpression())) == null || !res.endsWith(".jasper") || alredyAddedElements.contains((resFile = this.findFile(this.reportFile, res = String.valueOf(res.substring(0, res.length() - ".jasper".length())) + ".jrxml")).getAbsolutePath())) continue;
            resourceNames.add(resFile);
            alredyAddedElements.add(resFile.getAbsolutePath());
        }
        List templates = this.bundle.getJasperDesign().getTemplatesList();
        for (JRReportTemplate t : templates) {
            res = this.evalResourceName(t.getSourceExpression());
            resFile = this.findFile(this.reportFile, res);
            if (resFile == null || alredyAddedElements.contains(resFile.getAbsolutePath())) continue;
            resourceNames.add(resFile);
            alredyAddedElements.add(resFile.getAbsolutePath());
        }
        return resourceNames;
    }

    class TLabelProvider
    extends CellLabelProvider
    implements ITableLabelProvider {
        TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            File fr = (File)element;
            return fr.getAbsolutePath();
        }

        public void update(ViewerCell cell) {
            cell.setText(cell.getElement().toString());
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 2000;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

