/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.handlers;

import com.jaspersoft.studio.handlers.CategoriesPage;
import com.jaspersoft.studio.handlers.ConflictDetailsError;
import com.jaspersoft.studio.handlers.FinalPage;
import com.jaspersoft.studio.handlers.ResourcePage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class TemplateExporterWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private ResourcePage firstPage;
    private CategoriesPage secondPage;

    public void addPages() {
        super.addPages();
        if (this.selection.getFirstElement() instanceof IFile) {
            IFile reportFile = (IFile)this.selection.getFirstElement();
            try {
                this.firstPage = new ResourcePage(reportFile);
                this.secondPage = new CategoriesPage();
                this.addPage((IWizardPage)this.firstPage);
                this.addPage((IWizardPage)this.secondPage);
                this.addPage((IWizardPage)this.createCongratPage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private JSSHelpWizardPage createCongratPage() {
        return new FinalPage();
    }

    public boolean canOpen() {
        return this.selection != null && !this.selection.isEmpty();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        Object selectedResource;
        IEditorPart currentEditor;
        IWorkbenchPage page;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        if (this.selection.isEmpty() && workbench.getActiveWorkbenchWindow() != null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null && (currentEditor = page.getActiveEditor()) != null && (selectedResource = currentEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            this.selection = new StructuredSelection(selectedResource);
        }
        this.setWindowTitle(Messages.TemplateExporterWizard_title);
        this.setNeedsProgressMonitor(false);
    }

    private int createErrorMessage(List<String> errors) {
        String conf = "";
        for (String error : errors) {
            conf = String.valueOf(conf) + error.concat("\n");
        }
        OperationStatus status = new OperationStatus(4, JasperReportsPlugin.getDefault().getPluginID(), 1, conf, null);
        int result = new YesNoDetailsError(UIUtils.getShell(), Messages.TemplateExporterWizard_errorTitle, Messages.TemplateExporterWizard_errorMessage, (IStatus)status, 7).open();
        return result;
    }

    public List<String> getValidationErrors() {
        return this.secondPage.validateWithSelectedEngine((JasperReportsContext)this.firstPage.getJRConfiguration(), this.firstPage.getDesign());
    }

    public String getPath() {
        return this.firstPage.getDestinationPath();
    }

    public boolean performFinish() {
        this.firstPage.finish();
        this.secondPage.finish(this.firstPage.getDesign().getName(), this.firstPage.getDestinationPath());
        return true;
    }

    private class YesNoDetailsError
    extends ConflictDetailsError {
        public YesNoDetailsError(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.NO_LABEL, true);
            this.createDetailsButton(parent);
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle | 0x10000000);
        }
    }
}

