/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.help.ovverriders;

import com.jaspersoft.studio.help.ovverriders.IHelpOverrider;
import java.util.Collections;
import java.util.List;

public class RegularExpressionOverrider
implements IHelpOverrider {
    protected List<String> regularExpressions;
    protected String substitutionString;

    public RegularExpressionOverrider(String regEx, String substitution) {
        this(Collections.singletonList(regEx), substitution);
    }

    public RegularExpressionOverrider(List<String> regEx, String substitution) {
        this.substitutionString = substitution;
        this.regularExpressions = regEx;
    }

    @Override
    public String getPropertyURL(String propertyName) {
        return "net.sf.jasperreports.doc/docs/config.reference.html?cp=0_2#".concat(this.substitutionString);
    }

    @Override
    public boolean isOverrided(String propertyName) {
        for (String expression : this.regularExpressions) {
            if (propertyName.matches(expression)) continue;
            return false;
        }
        return true;
    }
}

