/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jasper;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.util.JRExpressionUtil;

public class JSSReportConverter
extends ReportConverter {
    protected boolean loadingTamplateStyles = false;

    public JSSReportConverter(JasperReportsContext jasperReportsContext, JRReport report, boolean ignoreContent) {
        super(jasperReportsContext, report, ignoreContent);
    }

    public Map<String, JRStyle> getStylesMap() {
        return this.stylesMap;
    }

    public boolean refreshCachedStyles() {
        if (!this.loadingTamplateStyles) {
            this.loadingTamplateStyles = true;
            this.convert(false);
            this.loadingTamplateStyles = false;
            return true;
        }
        return false;
    }

    protected void loadReportTemplateStyles(JRReportTemplate template, Set<String> loadedLocations) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression != null && sourceExpression.getText() != null) {
            String location = null;
            String overridenExpression = ExpressionUtil.extractValueForVariable("@path", sourceExpression.getText());
            location = overridenExpression != null ? JRExpressionUtil.getSimpleExpressionText((JRExpression)new JRDesignExpression(overridenExpression)) : JRExpressionUtil.getSimpleExpressionText((JRExpression)sourceExpression);
            if (location == null) {
                JaspersoftStudioPlugin.getInstance().logWarning("Template source expression " + sourceExpression.getText() + "cannot be evaluated; some styles might remain unresolved.");
            } else {
                HashSet<String> parentLocations = new HashSet<String>();
                this.loadTemplateStyles(location, loadedLocations, parentLocations);
            }
        }
    }

    protected void loadTemplateStyles(String location, Set<String> loadedLocations, Set<String> parentLocations) {
        if (!parentLocations.add(location)) {
            throw new JRRuntimeException("convert.report.converter.circular.dependency.found", new Object[]{location});
        }
        if (!loadedLocations.add(location)) {
            return;
        }
        JRTemplate template = null;
        try {
            template = ExternalStylesManager.getTemplate((JasperReportsConfiguration)this.getJasperReportsContext(), location);
        }
        catch (Exception e) {
            JaspersoftStudioPlugin.getInstance().logWarning("Could not load template from location at design time" + location + "; some styles might remain unresolved.", e);
            return;
        }
        if (template != null) {
            JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
            if (includedTemplates != null) {
                int i = 0;
                while (i < includedTemplates.length) {
                    JRTemplateReference reference = includedTemplates[i];
                    this.loadTemplateStyles(reference.getLocation(), loadedLocations, parentLocations);
                    ++i;
                }
            }
            this.collectStyles(template.getStyles());
        }
    }
}

