/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.jface.dialogs.FileSelectionDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.ImageUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilePreviewSelectionDialog
extends FileSelectionDialog {
    private static final int IMAGE_PREVIEW_JOB_DELAY = 500;
    private ImagePreviewJob filePreviewJob = new ImagePreviewJob();
    private Image previewJobResizedImg;
    private Composite cmpFilePreview;
    private Composite cmpNoFilePreview;
    private Label filePreview;
    private Group grpFilePreview;
    private StackLayout grpFilePreviewLayout;
    private Label lblFileSize;
    private Label lblFileDimension;

    public FilePreviewSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        this.createFilePreviewPanel(this.container);
        this.changeFileSelectionMode((Control)this.cmpNoFile);
        return area;
    }

    private void createFilePreviewPanel(Composite container) {
        this.grpFilePreview = new Group(container, 0);
        this.grpFilePreviewLayout = new StackLayout();
        this.grpFilePreview.setLayout((Layout)this.grpFilePreviewLayout);
        GridData gd = new GridData(4, 4, true, true, 2, 2);
        gd.heightHint = 200;
        this.grpFilePreview.setLayoutData((Object)gd);
        this.grpFilePreview.setText(Messages.ImageSelectionDialog_ImagePreviewGroupTitle);
        this.cmpFilePreview = new Composite((Composite)this.grpFilePreview, 0);
        this.cmpFilePreview.setLayout((Layout)new GridLayout(1, false));
        this.lblFileDimension = new Label(this.cmpFilePreview, 0);
        this.lblFileDimension.setText(Messages.ImageSelectionDialog_Dimension);
        this.lblFileDimension.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblFileSize = new Label(this.cmpFilePreview, 0);
        this.lblFileSize.setText(Messages.ImageSelectionDialog_Size);
        this.lblFileSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.filePreview = new Label(this.cmpFilePreview, 0);
        this.filePreview.setText("IMAGE HERE");
        this.filePreview.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cmpNoFilePreview = new Composite((Composite)this.grpFilePreview, 0);
        this.cmpNoFilePreview.setLayout((Layout)new GridLayout(1, false));
        Label lblNoPreviewAvailable = new Label(this.cmpNoFilePreview, 0);
        lblNoPreviewAvailable.setText(Messages.ImageSelectionDialog_NoPreviewAvailable);
        lblNoPreviewAvailable.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        lblNoPreviewAvailable.setAlignment(0x1000000);
    }

    @Override
    protected IFile selectFileFromWorkspace() {
        IFile file = super.selectFileFromWorkspace();
        if (file != null) {
            try {
                IFileStore imgFileStore = EFS.getStore((URI)file.getLocationURI());
                this.loadFilePreview(file.getLocation().toOSString(), imgFileStore);
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
        } else {
            this.grpFilePreviewLayout.topControl = this.cmpNoFilePreview;
            this.grpFilePreview.layout();
        }
        return file;
    }

    @Override
    public void handleTxtFilesystemPathChange() {
        super.handleTxtFilesystemPathChange();
        this.loadImagePreview();
    }

    @Override
    public void handleTxtUrlChange() {
        this.loadImagePreview();
    }

    @Override
    public void changeFileSelectionMode(Control newTopControl) {
        super.changeFileSelectionMode(newTopControl);
        if (this.filePreview != null) {
            Image currImgPreview = this.filePreview.getImage();
            if (currImgPreview != null) {
                currImgPreview.dispose();
            }
            this.grpFilePreviewLayout.topControl = this.cmpNoFilePreview;
            this.grpFilePreview.layout();
        }
    }

    private void loadFilePreview(String imgLocation, IFileStore imgFileStore) {
        Image oldPreviewImg = this.filePreview.getImage();
        Image originalImg = null;
        try {
            originalImg = new Image((Device)this.getShell().getDisplay(), imgLocation);
        }
        catch (SWTException sWTException) {
            this.grpFilePreviewLayout.topControl = this.cmpNoFilePreview;
            this.grpFilePreview.layout();
        }
        if (originalImg != null) {
            int imgHeight = originalImg.getImageData().height;
            int imgWidth = originalImg.getImageData().width;
            String sizeInfo = Messages.ImageSelectionDialog_NoSizeInfoAvailable;
            sizeInfo = String.valueOf(DecimalFormat.getNumberInstance().format(imgFileStore.fetchInfo().getLength())) + Messages.ImageSelectionDialog_bytes;
            Image resizedImg = ImageUtils.resize(originalImg, Math.min(imgWidth, 200), Math.min(imgHeight, 200));
            this.filePreview.setImage(resizedImg);
            this.lblFileDimension.setText(String.valueOf(Messages.ImageSelectionDialog_Dimension) + imgWidth + "x" + imgHeight + "px");
            this.lblFileSize.setText(String.valueOf(Messages.ImageSelectionDialog_Size) + sizeInfo);
            this.grpFilePreviewLayout.topControl = this.cmpFilePreview;
            this.grpFilePreview.layout(true);
            originalImg.dispose();
            if (oldPreviewImg != null) {
                oldPreviewImg.dispose();
            }
        }
    }

    private void loadPreviewRemoteImage(String imageURLText) {
        block6: {
            Image oldPreviewImg = this.filePreview.getImage();
            HttpURLConnection con = null;
            InputStream imageIS = null;
            try {
                try {
                    URL imageURL = new URL(imageURLText);
                    con = (HttpURLConnection)imageURL.openConnection();
                    imageIS = con.getInputStream();
                    int imageLength = con.getContentLength();
                    Image remoteImg = new Image((Device)this.getShell().getDisplay(), imageIS);
                    String sizeInfo = Messages.ImageSelectionDialog_NoSizeInfoAvailable;
                    sizeInfo = String.valueOf(DecimalFormat.getNumberInstance().format(imageLength)) + Messages.ImageSelectionDialog_bytes;
                    int imgWidth = remoteImg.getImageData().width;
                    int imgHeight = remoteImg.getImageData().height;
                    Image resizedImg = ImageUtils.resize(remoteImg, Math.min(imgWidth, 200), Math.min(imgHeight, 200));
                    this.filePreview.setImage(resizedImg);
                    this.lblFileDimension.setText(String.valueOf(Messages.ImageSelectionDialog_Dimension) + imgWidth + "x" + imgHeight + "px");
                    this.lblFileSize.setText(String.valueOf(Messages.ImageSelectionDialog_Size) + sizeInfo);
                    this.grpFilePreviewLayout.topControl = this.cmpFilePreview;
                    this.grpFilePreview.layout(true);
                    remoteImg.dispose();
                    if (oldPreviewImg != null) {
                        oldPreviewImg.dispose();
                    }
                }
                catch (Exception exception) {
                    this.grpFilePreviewLayout.topControl = this.cmpNoFilePreview;
                    this.grpFilePreview.layout();
                    FileUtils.closeStream((Closeable)imageIS);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(imageIS);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)imageIS);
        }
    }

    public void loadImagePreview() {
        this.filePreviewJob.cancel();
        this.filePreviewJob.schedule(500L);
    }

    public boolean close() {
        if (this.filePreviewJob != null) {
            this.filePreviewJob.cancel();
            this.filePreviewJob = null;
        }
        if (this.previewJobResizedImg != null) {
            this.previewJobResizedImg.dispose();
            this.previewJobResizedImg = null;
        }
        return super.close();
    }

    private final class ImagePreviewJob
    extends WorkbenchJob {
        public ImagePreviewJob() {
            super(Messages.ImageSelectionDialog_JobImgPreview);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (FilePreviewSelectionDialog.this.getDialogArea() != null && !FilePreviewSelectionDialog.this.getDialogArea().isDisposed()) {
                monitor.beginTask(Messages.ImageSelectionDialog_JobImgPreviewRetrieving, -1);
                if (FilePreviewSelectionDialog.this.btnAbsolutePath.getSelection()) {
                    String imagePath = FilePreviewSelectionDialog.this.txtFilesystemPath.getText();
                    IFileStore imgFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(imagePath));
                    FilePreviewSelectionDialog.this.loadFilePreview(imagePath, imgFileStore);
                    FilePreviewSelectionDialog.super.handleTxtFilesystemPathChange();
                } else if (FilePreviewSelectionDialog.this.btnUrlRemote.getSelection()) {
                    String imageURLText;
                    FilePreviewSelectionDialog.this.fileExpressionText = imageURLText = FilePreviewSelectionDialog.this.txtURL.getText();
                    FilePreviewSelectionDialog.this.loadPreviewRemoteImage(imageURLText);
                } else if (!Misc.isNullOrEmpty((String)FilePreviewSelectionDialog.this.fileExpressionText)) {
                    try {
                        byte[] imgByte;
                        String t = FilePreviewSelectionDialog.this.fileExpressionText;
                        if (t.startsWith("\"")) {
                            t = t.substring(1);
                        }
                        if (t.endsWith("\"")) {
                            t = t.substring(0, t.length() - 1);
                        }
                        if ((imgByte = RepositoryUtil.getInstance((JasperReportsContext)FilePreviewSelectionDialog.this.jConfig).getBytesFromLocation(t)) != null) {
                            Image oldPreviewImg = FilePreviewSelectionDialog.this.filePreview.getImage();
                            BufferedInputStream inputStreamReader = new BufferedInputStream(new ByteArrayInputStream(imgByte));
                            ImageData imageData = new ImageData((InputStream)inputStreamReader);
                            Image img = new Image((Device)this.getDisplay(), imageData);
                            String sizeInfo = String.valueOf(DecimalFormat.getNumberInstance().format(imgByte.length)) + Messages.ImageSelectionDialog_bytes;
                            int imgWidth = img.getImageData().width;
                            int imgHeight = img.getImageData().height;
                            if (FilePreviewSelectionDialog.this.previewJobResizedImg != null) {
                                FilePreviewSelectionDialog.this.previewJobResizedImg.dispose();
                            }
                            FilePreviewSelectionDialog.this.previewJobResizedImg = ImageUtils.resize(img, Math.min(imgWidth, 200), Math.min(imgHeight, 200));
                            FilePreviewSelectionDialog.this.filePreview.setImage(FilePreviewSelectionDialog.this.previewJobResizedImg);
                            FilePreviewSelectionDialog.this.lblFileDimension.setText(String.valueOf(Messages.ImageSelectionDialog_Dimension) + imgWidth + "x" + imgHeight + "px");
                            FilePreviewSelectionDialog.this.lblFileSize.setText(String.valueOf(Messages.ImageSelectionDialog_Size) + sizeInfo);
                            FilePreviewSelectionDialog.this.grpFilePreviewLayout.topControl = FilePreviewSelectionDialog.this.cmpFilePreview;
                            FilePreviewSelectionDialog.this.grpFilePreview.layout(true);
                            img.dispose();
                            if (oldPreviewImg != null) {
                                oldPreviewImg.dispose();
                            }
                        }
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

