/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.jface.dialogs;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WLocaleList;
import java.util.Locale;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocaleDialog
extends PersistentLocationDialog {
    private CTabFolder tabFolder;
    private CTabItem tbtmPredefinedLocales;
    private CTabItem tbtmCustomLocale;
    private WLocaleList wLocaleList;
    private Text textCustomLanguageCode;
    private Text textCustomCountryCode;
    private Text textCustomVariantCode;
    private Button buttonDefaultLocale;
    private Locale locale = null;

    public LocaleDialog(Shell parentShell, Locale locale) {
        super(parentShell);
        this.locale = locale;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LocaleDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        FillLayout fl_container = new FillLayout(256);
        fl_container.marginWidth = 5;
        fl_container.marginHeight = 5;
        container.setLayout((Layout)fl_container);
        this.tabFolder = new CTabFolder(container, 2048);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.tbtmPredefinedLocales = new CTabItem(this.tabFolder, 0);
        this.tbtmPredefinedLocales.setText(Messages.LocaleDialog_1);
        Composite compositePredefinedLocales = new Composite((Composite)this.tabFolder, 0);
        this.tbtmPredefinedLocales.setControl((Control)compositePredefinedLocales);
        FillLayout fl_compositePredefinedLocales = new FillLayout(256);
        fl_compositePredefinedLocales.marginWidth = 5;
        fl_compositePredefinedLocales.marginHeight = 5;
        compositePredefinedLocales.setLayout((Layout)fl_compositePredefinedLocales);
        this.wLocaleList = new WLocaleList(compositePredefinedLocales, 0);
        this.tbtmCustomLocale = new CTabItem(this.tabFolder, 0);
        this.tbtmCustomLocale.setText(Messages.LocaleDialog_2);
        Composite compositeCustomLocale = new Composite((Composite)this.tabFolder, 0);
        this.tbtmCustomLocale.setControl((Control)compositeCustomLocale);
        GridLayout gl_compositeCustomLocale = new GridLayout(3, false);
        compositeCustomLocale.setLayout((Layout)gl_compositeCustomLocale);
        Label lblNewLabel = new Label(compositeCustomLocale, 0);
        lblNewLabel.setText(String.valueOf(Messages.LocaleDialog_3) + Messages.LocaleDialog_4);
        this.textCustomLanguageCode = new Text(compositeCustomLocale, 2048);
        GridData gd_txtCustomLanguageCode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtCustomLanguageCode.minimumWidth = 100;
        this.textCustomLanguageCode.setLayoutData((Object)gd_txtCustomLanguageCode);
        Label lblNewLabel_1 = new Label(compositeCustomLocale, 0);
        lblNewLabel_1.setText(Messages.LocaleDialog_5);
        Label lblNewLabel_2 = new Label(compositeCustomLocale, 0);
        lblNewLabel_2.setText(Messages.LocaleDialog_6);
        this.textCustomCountryCode = new Text(compositeCustomLocale, 2048);
        GridData gd_textCustomCountryCode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textCustomCountryCode.minimumWidth = 100;
        this.textCustomCountryCode.setLayoutData((Object)gd_textCustomCountryCode);
        Label lblNewLabel_3 = new Label(compositeCustomLocale, 0);
        lblNewLabel_3.setText(Messages.LocaleDialog_7);
        Label lblNewLabel_4 = new Label(compositeCustomLocale, 0);
        lblNewLabel_4.setText(Messages.LocaleDialog_8);
        this.textCustomVariantCode = new Text(compositeCustomLocale, 2048);
        GridData gd_textCustomVariantCode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textCustomVariantCode.minimumWidth = 100;
        this.textCustomVariantCode.setLayoutData((Object)gd_textCustomVariantCode);
        Label lblNewLabel_5 = new Label(compositeCustomLocale, 0);
        lblNewLabel_5.setText(Messages.LocaleDialog_9);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        new Label(compositeCustomLocale, 0);
        Label lblNewLabel_6 = new Label(compositeCustomLocale, 0);
        lblNewLabel_6.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        lblNewLabel_6.setText(String.valueOf(Messages.LocaleDialog_10) + Messages.LocaleDialog_11);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem cTabItem = (CTabItem)e.item;
                if (cTabItem == LocaleDialog.this.tbtmPredefinedLocales) {
                    LocaleDialog.this.getButton(0).setEnabled(true);
                } else {
                    LocaleDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LocaleDialog.this.okPressed();
            }
        };
        this.wLocaleList.setListSelectionListener(selectionAdapter);
        this.initElements();
        return container;
    }

    private void initElements() {
        if (this.locale != null) {
            if (this.wLocaleList.contains(this.locale)) {
                this.wLocaleList.setSelection(this.locale);
                this.tabFolder.setSelection(0);
            } else {
                String language = this.locale.getLanguage();
                String country = this.locale.getCountry();
                String variant = this.locale.getVariant();
                if (language != null && language.length() > 0) {
                    this.textCustomLanguageCode.setText(language);
                }
                if (country != null && country.length() > 0) {
                    this.textCustomCountryCode.setText(country);
                }
                if (variant != null && variant.length() > 0) {
                    this.textCustomVariantCode.setText(variant);
                }
                this.tabFolder.setSelection(1);
            }
        } else {
            this.wLocaleList.setSelection(Locale.getDefault());
            this.tabFolder.setSelection(0);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttonDefaultLocale = this.createButton(parent, 2, Messages.LocaleDialog_12, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.buttonDefaultLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocaleDialog.this.wLocaleList.setSelection(Locale.getDefault());
                LocaleDialog.this.tabFolder.setSelection(0);
                LocaleDialog.this.okPressed();
            }
        });
        this.textCustomLanguageCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocaleDialog.this.getButton(0).setEnabled(LocaleDialog.this.isCustomLocaleValid());
            }
        });
        this.textCustomCountryCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocaleDialog.this.getButton(0).setEnabled(LocaleDialog.this.isCustomLocaleValid());
            }
        });
        this.textCustomVariantCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocaleDialog.this.getButton(0).setEnabled(LocaleDialog.this.isCustomLocaleValid());
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(650, 300);
    }

    protected void okPressed() {
        CTabItem tabItem = this.tabFolder.getSelection();
        if (tabItem.equals(this.tbtmPredefinedLocales)) {
            this.locale = this.wLocaleList.getSelectedLocale();
        } else {
            String language = this.textCustomLanguageCode.getText();
            String country = this.textCustomCountryCode.getText();
            String variant = this.textCustomVariantCode.getText();
            this.locale = language != null && language.trim().length() > 0 ? (country != null && language.trim().length() > 0 ? (variant != null && variant.trim().length() > 0 ? new Locale(language, country, variant) : new Locale(language, country)) : new Locale(language)) : this.wLocaleList.getSelectedLocale();
        }
        super.okPressed();
    }

    private boolean isCustomLocaleValid() {
        String language = this.textCustomLanguageCode.getText();
        String country = this.textCustomCountryCode.getText();
        String variant = this.textCustomVariantCode.getText();
        if (variant != null && variant.trim().length() > 0) {
            if (country != null && country.trim().length() > 0) {
                return language != null && language.trim().length() > 0;
            }
            return false;
        }
        return false;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

