/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model;

import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.FloatPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSPopupPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.EnumHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wb.swt.ResourceManager;

public class MLinePen
extends APropertyNode
implements IPropertySource {
    public static final long serialVersionUID = 10200L;
    private static List<ComboItem> lineSpacingItems = null;
    private static IPropertyDescriptor[] descriptors;
    private static JSSPopupPropertyDescriptor penLineStyleD;

    public MLinePen(JRPen linePen) {
        this.setValue(linePen);
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getValue() == null) {
            return result;
        }
        JRBasePen element = (JRBasePen)this.getValue();
        result.put("lineColor", element.getOwnLineColor());
        result.put("lineStyle", element.getOwnLineStyleValue());
        result.put("lineWidth", element.getOwnLineWidth());
        return result;
    }

    private List<ComboItem> createLineSpacingItems() {
        if (lineSpacingItems == null) {
            lineSpacingItems = new ArrayList<ComboItem>();
            LineStyleEnum[] values = (LineStyleEnum[])LineStyleEnum.class.getEnumConstants();
            lineSpacingItems.add(new ComboItem(MessagesByKeys.getString("LineSpacing_nullEnum"), true, ResourceManager.getImage(this.getClass(), (String)"/icons/resources/inherited.png"), 0, (Object)NullEnum.INHERITED, null));
            Image[] images = new Image[]{ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-solid.png"), ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-dashed.png"), ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-dotted.png"), ResourceManager.getImage(this.getClass(), (String)"/icons/resources/line-double.png")};
            int i = 0;
            while (i < values.length) {
                LineStyleEnum value = values[i];
                lineSpacingItems.add(new ComboItem(MessagesByKeys.getString("LineStyle_".concat(value.getName())), true, images[i], i + 1, value, EnumHelper.getIntValueForCombo(value, true)));
                ++i;
            }
        }
        return lineSpacingItems;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        ColorPropertyDescriptor penLineColorD = new ColorPropertyDescriptor("lineColor", Messages.common_line_color, NullEnum.INHERITED);
        penLineColorD.setDescription(Messages.MLinePen_line_color_description);
        penLineColorD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#pen_lineColor"));
        desc.add((IPropertyDescriptor)penLineColorD);
        FloatPropertyDescriptor penLineWidthD = new FloatPropertyDescriptor("lineWidth", Messages.MLinePen_line_width);
        penLineWidthD.setDescription(Messages.MLinePen_line_width_description);
        penLineWidthD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#pen_lineWidth"));
        penLineWidthD.setBounds(0.0f, 999.0f);
        desc.add((IPropertyDescriptor)penLineWidthD);
        penLineStyleD = new JSSPopupPropertyDescriptor("lineStyle", Messages.common_line_style, LineStyleEnum.DASHED, NullEnum.INHERITED, this.createLineSpacingItems());
        penLineStyleD.setDescription(Messages.MLinePen_line_style_description);
        penLineStyleD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#pen_lineStyle"));
        desc.add((IPropertyDescriptor)penLineStyleD);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("lineStyle", new DefaultValue(null, true));
        defaultsMap.put("lineColor", new DefaultValue(null, true));
        defaultsMap.put("lineWidth", new DefaultValue(null, true));
        return defaultsMap;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public Object getPropertyValue(Object id) {
        JRPen linePen = (JRPen)this.getValue();
        if (linePen != null) {
            if (id.equals("lineColor")) {
                return Colors.getSWTRGB4AWTGBColor(linePen.getOwnLineColor());
            }
            if (id.equals("lineWidth")) {
                return linePen.getOwnLineWidth();
            }
            if (id.equals("lineStyle")) {
                LineStyleEnum ownLineStyle;
                if (penLineStyleD == null) {
                    this.getPropertyDescriptors();
                }
                return (ownLineStyle = linePen.getOwnLineStyleValue()) != null ? penLineStyleD.getIntValue(linePen.getOwnLineStyleValue()) : null;
            }
        }
        return null;
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRBasePen linePen = (JRBasePen)this.getValue();
        JSSStyleResolver resolver = this.getStyleResolver();
        if (linePen != null) {
            if (id.equals("lineColor")) {
                Color lineColor = resolver.getLineColor((JRPen)linePen, linePen.getPenContainer().getDefaultLineColor());
                return Colors.getSWTRGB4AWTGBColor(lineColor);
            }
            if (id.equals("lineWidth")) {
                return resolver.getLineWidth((JRPen)linePen, linePen.getPenContainer().getDefaultLineWidth());
            }
            if (id.equals("lineStyle")) {
                if (penLineStyleD == null) {
                    this.getPropertyDescriptors();
                }
                LineStyleEnum lineStyle = resolver.getLineStyleValue((JRPen)linePen);
                return penLineStyleD.getIntValue(lineStyle);
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRPen linePen = (JRPen)this.getValue();
        if (linePen != null) {
            if (id.equals("lineWidth")) {
                Float lineWidth = (Float)value;
                if (lineWidth != null && lineWidth.floatValue() >= 0.0f) {
                    linePen.setLineWidth(Float.valueOf(Math.abs(lineWidth.floatValue())));
                } else {
                    linePen.setLineWidth(null);
                }
            } else if (id.equals("lineColor")) {
                if (value == null) {
                    linePen.setLineColor(null);
                } else if (value instanceof AlfaRGB) {
                    linePen.setLineColor(Colors.getAWT4SWTRGBColor((AlfaRGB)value));
                }
            } else if (id.equals("lineStyle")) {
                linePen.setLineStyle((LineStyleEnum)penLineStyleD.getEnumValue(value));
            }
        }
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return null;
    }
}

