/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroup;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class ReorderBandCommandByIndex
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignBand jrBand;
    private JRDesignSection jrDesignSection;

    public ReorderBandCommandByIndex(MBandGroup child, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDesignSection = (JRDesignSection)child.getSection();
        this.jrBand = child.getValue();
    }

    public ReorderBandCommandByIndex(MBand child, MReport parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDesignSection = (JRDesignSection)parent.getJasperDesign().getDetailSection();
        this.jrBand = child.getValue();
    }

    public void execute() {
        this.oldIndex = this.doExecute(this.oldIndex, this.newIndex);
    }

    private int doExecute(int oldInd, int newInd) {
        List bList = this.jrDesignSection.getBandsList();
        oldInd = bList.indexOf(this.jrBand);
        bList.remove(this.jrBand);
        if (newInd >= 0 && newInd < bList.size()) {
            bList.add(newInd, this.jrBand);
        } else {
            bList.add(this.jrBand);
            newInd = bList.size() - 1;
        }
        this.jrDesignSection.getEventSupport().fireIndexedPropertyChange("changeBandPosition", newInd, oldInd, -1);
        return oldInd;
    }

    public void undo() {
        this.doExecute(this.newIndex, this.oldIndex);
    }

    public static JSSCompoundCommand moveBandsCommand(List<MBand> moved, int location, final EditPart parentPart) {
        JSSCompoundCommand cmd;
        block4: {
            MBand firstBand;
            block5: {
                block3: {
                    final ANode report = moved.get(0).getParent();
                    cmd = new JSSCompoundCommand(report){

                        @Override
                        protected void refreshVisuals() {
                            PropertyChangeEvent event = new PropertyChangeEvent(report.getJasperDesign(), "refresh", null, null);
                            report.propertyChange(event);
                            for (Object part : parentPart.getChildren()) {
                                ((EditPart)part).refresh();
                            }
                        }

                        private void refreshBandNumbers() {
                        }

                        @Override
                        public void execute() {
                            super.execute();
                            this.refreshBandNumbers();
                            this.refreshVisuals();
                        }

                        @Override
                        public void undo() {
                            super.undo();
                            this.refreshBandNumbers();
                            this.refreshVisuals();
                        }
                    };
                    firstBand = moved.get(0);
                    if (!BandTypeEnum.GROUP_HEADER.equals((Object)firstBand.getBandType())) break block3;
                    for (MBand bandNode : moved) {
                        cmd.add(new ReorderBandCommandByIndex((MBandGroup)bandNode, location));
                    }
                    break block4;
                }
                if (!BandTypeEnum.GROUP_FOOTER.equals((Object)firstBand.getBandType())) break block5;
                for (MBand bandNode : moved) {
                    cmd.add(new ReorderBandCommandByIndex((MBandGroup)bandNode, location));
                }
                break block4;
            }
            if (!BandTypeEnum.DETAIL.equals((Object)firstBand.getBandType())) break block4;
            for (MBand bandNode : moved) {
                cmd.add(new ReorderBandCommandByIndex(bandNode, (MReport)bandNode.getParent(), location));
            }
        }
        return cmd;
    }

    private static BandTypeEnum getBandType(MBand band) {
        if (band == null) {
            return null;
        }
        return band.getBandType();
    }

    public static int calculateIndex(MBand band1, MBand band2, MBand movedBand) {
        int destinationIndex = 1;
        BandTypeEnum moveType = movedBand.getBandType();
        BandTypeEnum band1Type = ReorderBandCommandByIndex.getBandType(band1);
        BandTypeEnum band2Type = ReorderBandCommandByIndex.getBandType(band2);
        if (moveType == BandTypeEnum.DETAIL) {
            List<JRBand> allBands = Arrays.asList(movedBand.getJasperDesign().getDetailSection().getBands());
            if (BandTypeEnum.DETAIL.equals((Object)band1Type) && BandTypeEnum.DETAIL.equals((Object)band2Type)) {
                destinationIndex = allBands.indexOf(band2.getValue());
            } else if (BandTypeEnum.DETAIL.equals((Object)band1Type)) {
                destinationIndex = allBands.indexOf(band1.getValue()) + 1;
            } else if (BandTypeEnum.DETAIL.equals((Object)band2Type)) {
                destinationIndex = allBands.indexOf(band2.getValue());
            }
        } else if (moveType == BandTypeEnum.GROUP_HEADER || moveType == BandTypeEnum.GROUP_FOOTER) {
            MBandGroup group = (MBandGroup)movedBand;
            List<JRBand> allBands = Arrays.asList(group.getSection().getBands());
            if (band1 != null && band2 != null) {
                destinationIndex = allBands.indexOf(band2.getValue());
            } else if (band1 != null) {
                destinationIndex = allBands.indexOf(band1.getValue()) + 1;
            } else if (band2 != null) {
                destinationIndex = allBands.indexOf(band2.getValue());
            }
        }
        return destinationIndex;
    }
}

