/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.band.rv;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.DesignExpressionReturnValue;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class BandReturnValueDialog
extends ATitledDialog
implements IExpressionContextSetter {
    protected JasperReportsConfiguration jConfig;
    protected DesignExpressionReturnValue value;
    protected Text incrementText;
    protected Combo calculation;
    protected Combo toVariable;
    protected String[] toVariables;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            BandReturnValueDialog.this.validate();
        }
    };
    private ExpressionContext expContext;
    private ExpressionWidget expr;
    private static final String[] calculations = EnumHelper.getEnumNames((NamedEnum[])CalculationEnum.values(), NullEnum.NOTNULL);

    public BandReturnValueDialog(Shell parentShell, JasperReportsConfiguration jConfig, DesignExpressionReturnValue value, String[] toVariables) {
        super(parentShell);
        this.setTitle(Messages.BandReturnValueDialog_0);
        this.jConfig = jConfig;
        this.value = value;
        this.toVariables = toVariables;
        this.setExpressionContext(new ExpressionContext(jConfig.getJasperDesign().getMainDesignDataset(), jConfig));
        value.getEventSupport().addPropertyChangeListener(this.listener);
    }

    public boolean close() {
        this.value.getEventSupport().removePropertyChangeListener(this.listener);
        return super.close();
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public DesignExpressionReturnValue getValue() {
        return this.value;
    }

    protected void createToVariable(Composite container) {
        Label toVariableLabel = new Label(container, 0);
        toVariableLabel.setText(Messages.RVPropertyPage_to_variable);
        this.toVariable = new Combo(container, 8);
        this.toVariable.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.toVariable.setLayoutData((Object)gd);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        this.expr = new ExpressionWidget(container, Messages.common_expression);
        this.expr.setExpressionContext(this.expContext);
        this.createToVariable(container);
        Label calculationLabel = new Label(container, 0);
        calculationLabel.setText(Messages.RVPropertyPage_calculation_type);
        this.calculation = new Combo(container, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.calculation.setLayoutData((Object)gd);
        this.calculation.setItems(calculations);
        Label incrementLabel = new Label(container, 0);
        incrementLabel.setText(Messages.RVPropertyPage_incrementer_factory_class);
        this.incrementText = new Text(container, 2048);
        this.incrementText.setLayoutData((Object)new GridData(768));
        Button incrementButton = new Button(container, 0);
        incrementButton.setText("...");
        incrementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)BandReturnValueDialog.this.getShell(), (IRunnableContext)new ProgressMonitorDialog(BandReturnValueDialog.this.getShell()), (IJavaSearchScope)BandReturnValueDialog.this.getIncrementContext(), (int)256, (boolean)false);
                    dialog.setTitle(Messages.ClassTypeCellEditor_open_type);
                    dialog.setMessage(Messages.ClassTypeCellEditor_dialog_message);
                    if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length > 0) {
                        IType bt = (IType)dialog.getResult()[0];
                        BandReturnValueDialog.this.incrementText.setText(bt.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.updateContainer();
        this.expr.bindObject(this.value, "Expression");
        this.toVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BandReturnValueDialog.this.value.setToVariable(BandReturnValueDialog.this.toVariable.getText());
            }
        });
        this.incrementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BandReturnValueDialog.this.value.setIncrementerFactoryClassName(BandReturnValueDialog.this.incrementText.getText());
            }
        });
        this.calculation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BandReturnValueDialog.this.value.setCalculation(CalculationEnum.getByName((String)BandReturnValueDialog.this.calculation.getText()));
            }
        });
        return container;
    }

    protected void updateContainer() {
        int index;
        this.expr.setExpression((JRDesignExpression)this.value.getExpression());
        this.toVariable.setItems(this.toVariables);
        if (this.value.getToVariable() != null) {
            index = ArrayUtils.indexOf((Object[])this.toVariables, (Object)this.value.getToVariable());
            if (index == -1) {
                index = 0;
            }
            this.toVariable.select(index);
        } else {
            this.toVariable.select(0);
            this.value.setToVariable(this.toVariable.getText());
        }
        if (this.value.getCalculation() != null) {
            index = ArrayUtils.indexOf((Object[])CalculationEnum.values(), (Object)this.value.getCalculation());
            if (index == -1) {
                index = 0;
            }
            this.calculation.select(index);
        }
        if (this.value.getIncrementerFactoryClassName() != null) {
            this.incrementText.setText(this.value.getIncrementerFactoryClassName());
        }
        this.validate();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.validate();
        return contents;
    }

    protected void validate() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!Misc.isNullOrEmpty((String)this.toVariable.getText()) && this.value.getExpression() != null && !Misc.isNullOrEmpty((String)this.value.getExpression().getText()));
        }
    }

    private IJavaSearchScope getIncrementContext() {
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        IProject prj = ((IFile)this.jConfig.get("ifile")).getProject();
        if (prj != null) {
            try {
                IJavaProject jprj = JavaCore.create((IProject)prj);
                IType t = jprj.findType(JRIncrementerFactory.class.getName());
                if (t != null) {
                    searchScope = BasicSearchEngine.createHierarchyScope((IType)t);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return searchScope;
    }
}

