/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.layout.LazyLayoutCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

public class CreateElementCommand
extends Command {
    protected JasperDesign jasperDesign;
    protected JasperReportsConfiguration jConfig;
    protected MGraphicElement srcNode;
    protected ANode destNode;
    protected JRDesignElement jrElement;
    protected JRElementGroup jrGroup;
    protected Rectangle location;
    protected int index;
    private LazyLayoutCommand lCmd;
    private boolean firstTime = true;
    private JSSCompoundCommand commands;
    protected boolean operationCancelled = false;
    private boolean applyDefault = true;

    protected CreateElementCommand() {
    }

    public CreateElementCommand(MElementGroup destNode, MGraphicElement srcNode, int index) {
        this.setContext(destNode, srcNode, index);
    }

    public CreateElementCommand(MFrame destNode, MGraphicElement srcNode, int index) {
        this.setContext(destNode, srcNode, index);
    }

    public CreateElementCommand(MFrame destNode, MGraphicElement srcNode, Rectangle position, int index) {
        this.location = position;
        this.setContext(destNode, srcNode, index);
    }

    public CreateElementCommand(MBand destNode, MGraphicElement srcNode, int index) {
        this.setContext(destNode, srcNode, index);
    }

    public CreateElementCommand(ANode destNode, MGraphicElement srcNode, Rectangle position, int index) {
        this.location = position;
        this.jrElement = srcNode.getValue();
        if (destNode instanceof IGroupElement) {
            this.setContext(destNode, srcNode, index);
        } else if (destNode instanceof MFrame) {
            this.setContext(destNode, srcNode, index);
        } else {
            this.setContext(destNode, srcNode, index);
        }
    }

    protected void setContext(ANode destNode, MGraphicElement srcNode, int index) {
        if (destNode != null) {
            this.jConfig = destNode.getJasperConfiguration();
            this.srcNode = srcNode;
            this.jasperDesign = destNode.getJasperDesign();
            this.jrElement = srcNode.getValue();
            if (destNode instanceof IGroupElement) {
                this.jrGroup = ((IGroupElement)((Object)destNode)).getJRElementGroup();
            } else if (destNode.getValue() instanceof JRElementGroup) {
                this.jrGroup = (JRElementGroup)destNode.getValue();
            }
            this.destNode = destNode;
            this.index = index;
        } else {
            this.destNode = null;
        }
    }

    public void setJasperDesign(JasperDesign design) {
        this.jasperDesign = design;
    }

    public boolean isCancelled() {
        return this.operationCancelled;
    }

    public boolean canExecute() {
        return this.destNode != null && this.destNode.canAcceptChildren(this.srcNode);
    }

    public void fixLocation(Rectangle position, MBand band) {
        if (this.location == null) {
            this.location = this.jrElement != null ? new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight()) : (band != null ? new Rectangle(band.getBounds().x, band.getBounds().y, 50, 30) : new Rectangle(0, 0, 100, 100));
        }
        if (band != null) {
            this.location = CreateElementCommand.fixLocation(this.location, band, this.jrElement);
        }
    }

    public static Rectangle fixLocation(Rectangle position, MBand band, JRDesignElement jrElement) {
        int x = position.x - band.getBounds().x;
        int y = position.y - band.getBounds().y;
        position.setLocation(x, y);
        return position;
    }

    protected void createObject() {
        if (this.jrElement == null) {
            this.jrElement = this.srcNode.createJRElement(this.jasperDesign);
        }
        if (this.jrElement != null) {
            this.setElementBounds();
        }
    }

    protected void setElementBounds() {
        if (this.location == null) {
            this.location = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
        }
        if (this.location.width <= 0) {
            this.location.width = this.srcNode.getDefaultWidth();
        }
        if (this.location.height <= 0) {
            this.location.height = this.srcNode.getDefaultHeight();
        }
        this.jrElement.setX(this.location.x);
        this.jrElement.setY(this.location.y);
        this.jrElement.setWidth(this.location.width);
        this.jrElement.setHeight(this.location.height);
        if (this.jrGroup instanceof JRDesignBand && this.destNode.getJasperConfiguration().getPropertyBoolean("resizeParentContainer", Boolean.TRUE).booleanValue()) {
            JRDesignBand band = (JRDesignBand)this.jrGroup;
            int height = this.jrElement.getY() + this.jrElement.getHeight();
            if (band.getHeight() < height) {
                int maxBandHeight = ModelUtils.getMaxBandHeight(band, this.jasperDesign);
                if (maxBandHeight < height) {
                    if (this.jrElement.getHeight() < maxBandHeight) {
                        this.jrElement.setY(maxBandHeight - this.jrElement.getHeight());
                        this.location.y = this.jrElement.getY();
                    } else {
                        height = maxBandHeight;
                        this.jrElement.setHeight(height);
                        this.jrElement.setY(maxBandHeight - this.jrElement.getHeight());
                        this.location.y = this.jrElement.getY();
                        this.location.height = this.jrElement.getHeight();
                    }
                }
                SetValueCommand cmd = new SetValueCommand();
                cmd.setTarget((IPropertySource)this.destNode);
                cmd.setPropertyId("height");
                cmd.setPropertyValue(height);
                this.addCommand(cmd);
            }
        }
        if (this.applyDefault) {
            this.applayDefaultAttributes(this.srcNode.getClass(), (JRElement)this.jrElement);
        }
    }

    protected void applayDefaultAttributes(Class<?> clazz, JRElement element) {
        DefaultManager.INSTANCE.applyDefault(clazz, element);
    }

    protected void addCommand(Command command) {
        if (this.commands == null) {
            this.commands = new JSSCompoundCommand(this.srcNode);
        }
        this.commands.add(command);
    }

    protected void addCommands(List<Command> cmds) {
        if (cmds != null) {
            for (Command c : cmds) {
                this.addCommand(c);
            }
        }
    }

    protected void executeCommands() {
        if (this.commands != null) {
            this.commands.execute();
        }
    }

    public void execute() {
        this.createObject();
        if (this.location == null) {
            this.location = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
        }
        Rectangle originalLocation = this.location.getCopy();
        if (this.jrElement != null) {
            CreateElementCommand.removeElement(this.jasperDesign, this.jrElement);
            if (this.jrGroup instanceof JRDesignElementGroup) {
                JRDesignElementGroup jrdgroup = (JRDesignElementGroup)this.jrGroup;
                if (this.index < 0 || this.index > this.jrGroup.getChildren().size()) {
                    jrdgroup.addElement(this.jrElement);
                } else {
                    jrdgroup.addElement(this.index, this.jrElement);
                }
            } else if (this.jrGroup instanceof JRDesignFrame) {
                JRDesignFrame jFrame = (JRDesignFrame)this.jrGroup;
                if (this.index < 0 || this.index > this.jrGroup.getChildren().size()) {
                    jFrame.addElement((JRElement)this.jrElement);
                } else {
                    jFrame.addElement(this.index, (JRElement)this.jrElement);
                }
            }
            if (this.lCmd == null) {
                this.lCmd = new LazyLayoutCommand(this.destNode);
                this.addCommand(this.lCmd);
            }
            this.executeCommands();
            if (this.firstTime) {
                SelectionHelper.setSelection((JRChild)this.jrElement, false);
                this.firstTime = false;
            }
            if (this.jrElement != null) {
                if (this.jrElement instanceof JRDesignComponentElement) {
                    JRDesignComponentElement componentElement = (JRDesignComponentElement)this.jrElement;
                    if (componentElement.getComponent() != null) {
                        JaspersoftStudioPlugin.getInstance().getUsageManager().audit(componentElement.getComponent().getClass().getName(), "Element");
                    } else {
                        JaspersoftStudioPlugin.getInstance().getUsageManager().audit(String.valueOf(this.jrElement.getClass().getName()) + "[null_component]", "Element");
                    }
                } else {
                    JaspersoftStudioPlugin.getInstance().getUsageManager().audit(this.jrElement.getClass().getName(), "Element");
                }
            }
        }
        this.location = originalLocation;
    }

    public void setApplyDefault(boolean applyDefault) {
        this.applyDefault = applyDefault;
    }

    public boolean canUndo() {
        return this.jrGroup != null && this.jrElement != null;
    }

    public void undo() {
        if (this.commands != null) {
            this.commands.undo();
        }
        if (this.jrGroup instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.jrGroup).removeElement(this.jrElement);
        } else if (this.jrGroup instanceof JRDesignFrame) {
            ((JRDesignFrame)this.jrGroup).removeElement((JRElement)this.jrElement);
        }
    }

    public JRDesignElement getJrElement() {
        return this.jrElement;
    }

    public JRElementGroup getJrGroup() {
        return this.jrGroup;
    }

    public Rectangle getLocation() {
        return this.location;
    }

    public int getIndex() {
        return this.index;
    }

    public static void removeElement(JasperDesign jasperDesign, JRDesignElement element) {
        JRBand[] jRBandArray = jasperDesign.getAllBands();
        int n = jRBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRBand band = jRBandArray[n2];
            JRDesignBand b = (JRDesignBand)band;
            b.removeElement(element);
            CreateElementCommand.removeElement(element, b.getElements());
            ++n2;
        }
    }

    public static void removeElement(JRDesignElement element, JRElement[] elements) {
        JRElement[] jRElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JRElement el = jRElementArray[n2];
            if (el instanceof IGroupElement) {
                JRDesignElementGroup egroup = (JRDesignElementGroup)((IGroupElement)el).getJRElementGroup();
                egroup.removeElement(element);
                CreateElementCommand.removeElement(element, egroup.getElements());
            } else if (el instanceof JRDesignFrame) {
                JRDesignFrame frame = (JRDesignFrame)el;
                frame.removeElement((JRElement)element);
                CreateElementCommand.removeElement(element, frame.getElements());
            }
            ++n2;
        }
    }
}

