/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.command;

import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class EncloseIntoFrameCommand
extends Command {
    private List<APropertyNode> nodeList = new ArrayList<APropertyNode>();
    private List<NodePreviousPosition> previousPositions = new ArrayList<NodePreviousPosition>();
    private JRDesignFrame containerFrame;
    private ANode parent;

    public EncloseIntoFrameCommand(ANode nodesParent) {
        this.parent = nodesParent;
    }

    public void execute() {
        LayoutCommand command;
        JRPropertiesMap map;
        ANode nodeParent;
        MGraphicElement element;
        this.previousPositions.clear();
        this.containerFrame = new JRDesignFrame();
        Rectangle frameSize = this.getFrameSize();
        Collections.sort(this.nodeList, new Comparator<APropertyNode>(){

            @Override
            public int compare(APropertyNode o1, APropertyNode o2) {
                int index1 = o1.getParent().getChildren().indexOf(o1);
                int index2 = o2.getParent().getChildren().indexOf(o2);
                return index1 - index2;
            }
        });
        if (this.nodeList.size() == 1) {
            element = (MGraphicElement)this.nodeList.get(0);
            int index = this.getChildIndex(this.parent, element.getValue());
            this.addChild(this.parent, (JRDesignElement)this.containerFrame, index);
        } else {
            this.addChild(this.parent, (JRDesignElement)this.containerFrame);
        }
        for (APropertyNode node : this.nodeList) {
            nodeParent = node.getParent();
            this.previousPositions.add(new NodePreviousPosition(nodeParent.getChildren().indexOf(node), nodeParent, node));
        }
        for (APropertyNode node : this.nodeList) {
            nodeParent = node.getParent();
            JRDesignElement movedElement = (JRDesignElement)node.getValue();
            movedElement.setX(movedElement.getX() - frameSize.x);
            movedElement.setY(movedElement.getY() - frameSize.y);
            this.removeChild(nodeParent, movedElement);
            this.addChild(this.containerFrame, (JRDesignElement)node.getValue());
        }
        this.containerFrame.setX(frameSize.x);
        this.containerFrame.setY(frameSize.y);
        this.containerFrame.setWidth(frameSize.width);
        this.containerFrame.setHeight(frameSize.height);
        if (this.nodeList.size() == 1 && (map = (JRPropertiesMap)(element = (MGraphicElement)this.nodeList.get(0)).getPropertyValue("PROPERTY_MAP")) != null) {
            JRPropertiesMap frameMap = this.containerFrame.getPropertiesMap();
            if (map.containsProperty("com.jaspersoft.layout.grid.colspan")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.colspan", map.getProperty("com.jaspersoft.layout.grid.colspan"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.rowspan")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.rowspan", map.getProperty("com.jaspersoft.layout.grid.rowspan"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.weight.x")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.weight.x", map.getProperty("com.jaspersoft.layout.grid.weight.x"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.weight.y")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.weight.y", map.getProperty("com.jaspersoft.layout.grid.weight.y"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.x")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.x", map.getProperty("com.jaspersoft.layout.grid.x"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.y")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.y", map.getProperty("com.jaspersoft.layout.grid.y"));
            }
            if (map.containsProperty("com.jaspersoft.layout.grid.weight.fixed")) {
                frameMap.setProperty("com.jaspersoft.layout.grid.weight.fixed", map.getProperty("com.jaspersoft.layout.grid.weight.fixed"));
            }
        }
        if ((command = LayoutManager.createRelayoutCommand(this.parent)) != null) {
            command.execute();
        }
        SelectionHelper.setSelection((JRChild)this.containerFrame, false);
    }

    public void redo() {
        this.containerFrame = new JRDesignFrame();
        Rectangle frameSize = this.getFrameSize();
        if (this.nodeList.size() == 1) {
            MGraphicElement element = (MGraphicElement)this.nodeList.get(0);
            int index = this.getChildIndex(this.parent, element.getValue());
            this.addChild(this.parent, (JRDesignElement)this.containerFrame, index);
        } else {
            this.addChild(this.parent, (JRDesignElement)this.containerFrame);
        }
        for (APropertyNode node : this.nodeList) {
            JRDesignElement movedElement = (JRDesignElement)node.getValue();
            movedElement.setX(movedElement.getX() - frameSize.x);
            movedElement.setY(movedElement.getY() - frameSize.y);
            this.removeChild(this.parent, movedElement);
            this.addChild(this.containerFrame, (JRDesignElement)node.getValue());
        }
        this.containerFrame.setX(frameSize.x);
        this.containerFrame.setY(frameSize.y);
        this.containerFrame.setWidth(frameSize.width);
        this.containerFrame.setHeight(frameSize.height);
        LayoutCommand command = LayoutManager.createRelayoutCommand(this.parent);
        if (command != null) {
            command.execute();
        }
        SelectionHelper.setSelection((JRChild)this.containerFrame, false);
    }

    public void undo() {
        for (NodePreviousPosition node : this.previousPositions) {
            JRDesignElement movedElement = (JRDesignElement)node.movedNode.getValue();
            movedElement.setX(node.oldX);
            movedElement.setY(node.oldY);
            this.addChild(node.nodeParent, movedElement, node.nodeIndex);
        }
        this.removeChild(this.parent, (JRDesignElement)this.containerFrame);
        this.containerFrame = null;
        LayoutManager.layoutContainer(this.parent);
    }

    private Rectangle getFrameSize() {
        JRDesignElement firstElement = (JRDesignElement)this.nodeList.get(0).getValue();
        int leftUpperY = firstElement.getY();
        int leftUpperX = firstElement.getX();
        int rightLowerY = firstElement.getY() + firstElement.getHeight();
        int rightLowerX = firstElement.getX() + firstElement.getWidth();
        for (APropertyNode node : this.nodeList) {
            JRDesignElement element = (JRDesignElement)node.getValue();
            if (element.getY() < leftUpperY) {
                leftUpperY = element.getY();
            }
            if (element.getX() < leftUpperX) {
                leftUpperX = element.getX();
            }
            if (element.getY() + element.getHeight() > rightLowerY) {
                rightLowerY = element.getY() + element.getHeight();
            }
            if (element.getX() + element.getWidth() <= rightLowerX) continue;
            rightLowerX = element.getX() + element.getWidth();
        }
        return new Rectangle(leftUpperX, leftUpperY, rightLowerX - leftUpperX, rightLowerY - leftUpperY);
    }

    private void addChild(Object jrParent, JRDesignElement child) {
        if (jrParent instanceof JRDesignFrame) {
            ((JRDesignFrame)jrParent).addElement((JRElement)child);
        } else {
            ((JRDesignElementGroup)jrParent).addElement(child);
        }
    }

    private int getChildIndex(ANode parent, JRDesignElement child) {
        if (parent instanceof MFrame) {
            return ((JRDesignFrame)parent.getValue()).getChildren().indexOf(child);
        }
        if (parent instanceof IGroupElement) {
            return ((JRDesignElementGroup)((IGroupElement)((Object)parent)).getJRElementGroup()).getChildren().indexOf(child);
        }
        return -1;
    }

    private void addChild(ANode parent, JRDesignElement child, int index) {
        if (parent instanceof MFrame) {
            ((JRDesignFrame)parent.getValue()).addElement(index, (JRElement)child);
        } else if (parent instanceof IGroupElement) {
            ((JRDesignElementGroup)((IGroupElement)((Object)parent)).getJRElementGroup()).addElement(index, child);
        }
    }

    private void addChild(ANode parent, JRDesignElement child) {
        if (parent instanceof MFrame) {
            ((JRDesignFrame)parent.getValue()).addElement((JRElement)child);
        } else if (parent instanceof IGroupElement) {
            ((JRDesignElementGroup)((IGroupElement)((Object)parent)).getJRElementGroup()).addElement(child);
        }
    }

    private void removeChild(ANode parent, JRDesignElement child) {
        if (parent instanceof MFrame) {
            ((JRDesignFrame)parent.getValue()).removeElement((JRElement)child);
        } else if (parent instanceof IGroupElement) {
            ((JRDesignElementGroup)((IGroupElement)((Object)parent)).getJRElementGroup()).removeElement(child);
        }
    }

    public boolean canExecute() {
        return !this.nodeList.isEmpty();
    }

    public boolean canUndo() {
        return this.containerFrame != null;
    }

    public boolean addNode(APropertyNode node) {
        if (this.parent == node.getParent() && !this.nodeList.contains(node)) {
            this.nodeList.add(node);
            return true;
        }
        return false;
    }

    private class NodePreviousPosition {
        private int nodeIndex;
        private ANode nodeParent;
        private ANode movedNode;
        private int oldX;
        private int oldY;

        public NodePreviousPosition(int nodeIndex, ANode nodeParent, ANode movedNode) {
            this.nodeIndex = nodeIndex;
            this.nodeParent = nodeParent;
            this.movedNode = movedNode;
            JRDesignElement elementNode = (JRDesignElement)movedNode.getValue();
            this.oldX = elementNode.getX();
            this.oldY = elementNode.getY();
        }
    }
}

