/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset;

import com.jaspersoft.studio.editor.preview.datasnapshot.DataSnapshotManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.DatasetNameValidator;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionDTO;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionsDTO;
import com.jaspersoft.studio.model.field.FieldUtils;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.jrQuery.JRQueryButtonPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.resource.DefaultDatasetPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.resource.ResourceBundlePropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.DesignDatasetPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MDataset
extends APropertyNode
implements ICopyable {
    public static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MAP = "PROPERTY_MAP";
    private static NamedEnumPropertyDescriptor<WhenResourceMissingTypeEnum> whenResMissTypeD;
    private static IPropertyDescriptor[] descriptors;
    private static DatasetNameValidator validator;
    private static IIconDescriptor iconDescriptor;
    private MReport mreport;
    private MQuery mQuery;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("dataset");
        }
        return iconDescriptor;
    }

    public MDataset() {
    }

    public MDataset(MReport mreport, JRDesignDataset jrDataset) {
        this.mreport = mreport;
        this.setValue(jrDataset);
    }

    public boolean isMainDataset() {
        return this.getJasperDesign() != null && this.getJasperDesign().getMainDataset() == this.getValue();
    }

    public MDataset(ANode parent, JRDesignDataset jrDataset, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrDataset);
        INode root = this.getRoot();
        if (root != null && root instanceof MReport) {
            this.mreport = (MReport)root;
        }
    }

    public MReport getMreport() {
        return this.mreport;
    }

    @Override
    public JasperDesign getJasperDesign() {
        MReport mrep;
        JasperDesign jd = super.getJasperDesign();
        if (jd == null && (mrep = this.getMreport()) != null) {
            mrep.getJasperDesign();
        }
        return jd;
    }

    public JRDesignDataset getValue() {
        return (JRDesignDataset)super.getValue();
    }

    @Override
    public String getDisplayText() {
        if (this.getValue() != null) {
            return this.getValue().getName();
        }
        return "";
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MDataset.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MDataset.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateNameValidator();
    }

    protected void updateNameValidator() {
        if (validator == null) {
            validator = new DatasetNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateNameValidator();
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MDataset_name_description);
        desc.add((IPropertyDescriptor)nameD);
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor("propertyExpressions", Messages.MGraphicElement_property_expressions);
        propertiesD.setDescription(Messages.MGraphicElement_property_expressions_description);
        desc.add((IPropertyDescriptor)propertiesD);
        propertiesD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#property"));
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor("scriptletClass", Messages.MDataset_scriplet_class);
        classD.setDescription(Messages.MDataset_class_description);
        ArrayList classes = new ArrayList();
        classes.add(JRAbstractScriptlet.class);
        classD.setClasses(classes);
        desc.add((IPropertyDescriptor)classD);
        classD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#scriptlet"));
        ResourceBundlePropertyDescriptor resBundleD = new ResourceBundlePropertyDescriptor("resourceBundle", Messages.MDataset_resource_bundle);
        resBundleD.setDescription(Messages.MDataset_resource_bundle_description);
        desc.add((IPropertyDescriptor)resBundleD);
        JRQueryButtonPropertyDescriptor queryD = new JRQueryButtonPropertyDescriptor("query", Messages.common_query, NullEnum.NULL, Messages.MDataset_Edit_Query_Button_Text);
        queryD.setDescription(Messages.MDataset_query_description);
        desc.add((IPropertyDescriptor)queryD);
        queryD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#queryString"));
        whenResMissTypeD = new NamedEnumPropertyDescriptor<WhenResourceMissingTypeEnum>("whenResourceMissingType", Messages.MDataset_when_resource_missing_type, WhenResourceMissingTypeEnum.EMPTY, NullEnum.NOTNULL);
        whenResMissTypeD.setDescription(Messages.MDataset_when_resource_missing_type_description);
        desc.add((IPropertyDescriptor)whenResMissTypeD);
        DefaultDatasetPropertyDescriptor defaultDatasetDescriptor = new DefaultDatasetPropertyDescriptor("net.sf.jasperreports.data.adapter", "Default Data Adapter");
        defaultDatasetDescriptor.setDescription(Messages.MDataset_defaultDATooltip);
        desc.add((IPropertyDescriptor)defaultDatasetDescriptor);
        JRExpressionPropertyDescriptor filterExpression = new JRExpressionPropertyDescriptor("filterExpression", Messages.MDataset_filter_expression);
        filterExpression.setDescription(Messages.MDataset_filter_expression_description);
        desc.add((IPropertyDescriptor)filterExpression);
        filterExpression.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#filterExpression"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#subDataset");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("resourceBundle", new DefaultValue(null, true));
        defaultsMap.put("filterExpression", new DefaultValue(null, true));
        int whenResourceMissingValue = NamedEnumPropertyDescriptor.getIntValue(WhenResourceMissingTypeEnum.NULL, NullEnum.NOTNULL, WhenResourceMissingTypeEnum.NULL);
        defaultsMap.put("whenResourceMissingType", new DefaultValue(whenResourceMissingValue, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignDataset jrDataset = this.getValue();
        if (jrDataset == null) {
            return null;
        }
        if (id.equals("name")) {
            return jrDataset.getName();
        }
        if (id.equals("query")) {
            if (this.mQuery == null) {
                JRQuery jdq = jrDataset.getQuery();
                this.mQuery = new MQuery(jdq, this);
                this.mQuery.setJasperConfiguration(this.getJasperConfiguration());
                this.setChildListener(this.mQuery);
            }
            return this.mQuery;
        }
        if (id.equals("filterExpression")) {
            return ExprUtil.getExpression(jrDataset.getFilterExpression());
        }
        if (id.equals("scriptletClass")) {
            return jrDataset.getScriptletClass();
        }
        if (id.equals(PROPERTY_MAP)) {
            JRPropertiesMap pmap = jrDataset.getPropertiesMap().cloneProperties();
            return pmap;
        }
        if (id.equals("whenResourceMissingType")) {
            return whenResMissTypeD.getIntValue(jrDataset.getWhenResourceMissingTypeValue());
        }
        if (id.equals("resourceBundle")) {
            return jrDataset.getResourceBundle();
        }
        if (id.equals("net.sf.jasperreports.data.adapter")) {
            String location = jrDataset.getPropertiesMap().getProperty("net.sf.jasperreports.data.adapter");
            return location;
        }
        if (id.equals("propertyExpressions")) {
            DatasetPropertyExpression[] propertyExpressions = jrDataset.getPropertyExpressions();
            if (propertyExpressions != null) {
                propertyExpressions = (JRPropertyExpression[])propertyExpressions.clone();
            }
            return new DatasetPropertyExpressionsDTO((JRPropertyExpression[])propertyExpressions, this.getPropertiesMapClone(jrDataset), this.getValue(), ModelUtils.getExpressionContext(this));
        }
        if (id.equals(PROPERTY_MAP)) {
            return this.getPropertiesMapClone(jrDataset);
        }
        return null;
    }

    protected JRPropertiesMap getPropertiesMapClone(JRDesignDataset jrElement) {
        JRPropertiesMap propertiesMap = jrElement.getPropertiesMap();
        if (propertiesMap != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof JRDesignQuery || evt.getSource() instanceof JRField || evt.getSource() instanceof JRParameter) {
            DataSnapshotManager.setDataSnapshot(this.getJasperConfiguration().getJRParameters(), true);
        }
        if ("name".equals(evt.getPropertyName())) {
            JasperDesign design = this.getJasperDesign();
            JRDesignDataset jrDataset = this.getValue();
            String oldName = (String)evt.getOldValue();
            if (design != null) {
                design.getDatasetMap().remove(oldName);
                design.getDatasetMap().put(jrDataset.getName(), jrDataset);
            }
        }
        super.propertyChange(evt);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignDataset jrDataset = this.getValue();
        if (id.equals("name")) {
            jrDataset.setName((String)value);
        } else if (id.equals("resourceBundle")) {
            String v = (String)value;
            if (v != null && v.trim().isEmpty()) {
                v = null;
            }
            jrDataset.setResourceBundle(v);
        } else if (id.equals("scriptletClass")) {
            String v = (String)value;
            if (v != null && v.trim().isEmpty()) {
                v = null;
            }
            jrDataset.setScriptletClass(v);
        } else if (id.equals("filterExpression")) {
            jrDataset.setFilterExpression(ExprUtil.setValues(jrDataset.getFilterExpression(), value));
        } else if (id.equals("propertyExpressions")) {
            if (value instanceof DatasetPropertyExpressionsDTO) {
                DatasetPropertyExpressionsDTO dto = (DatasetPropertyExpressionsDTO)value;
                DatasetPropertyExpression[] expr = jrDataset.getPropertyExpressions();
                if (expr != null) {
                    DatasetPropertyExpression[] datasetPropertyExpressionArray = expr;
                    int n = expr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DatasetPropertyExpression ex = datasetPropertyExpressionArray[n2];
                        jrDataset.removePropertyExpression(ex);
                        ++n2;
                    }
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (!p.isExpression()) continue;
                    DesignDatasetPropertyExpression newExp = new DesignDatasetPropertyExpression();
                    newExp.setName(p.getName());
                    newExp.setValueExpression(p.getValueAsExpression());
                    newExp.setEvaluationTime(((DatasetPropertyExpressionDTO)p).getEvalTime());
                    jrDataset.addPropertyExpression((DatasetPropertyExpression)newExp);
                }
                JRPropertiesMap originalMap = jrDataset.getPropertiesMap().cloneProperties();
                String[] names = jrDataset.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    jrDataset.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    jrDataset.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
                this.firePropertyChange(new PropertyChangeEvent(jrDataset, PROPERTY_MAP, originalMap, jrDataset.getPropertiesMap()));
            }
        } else if (id.equals(PROPERTY_MAP)) {
            JRPropertiesMap v = (JRPropertiesMap)value;
            String[] names = jrDataset.getPropertiesMap().getPropertyNames();
            int i = 0;
            while (i < names.length) {
                jrDataset.getPropertiesMap().removeProperty(names[i]);
                ++i;
            }
            names = v.getPropertyNames();
            String[] stringArray = v.getPropertyNames();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String str = stringArray[n3];
                jrDataset.setProperty(str, v.getProperty(str));
                ++n3;
            }
            this.firePropertyChange(new PropertyChangeEvent(jrDataset, PROPERTY_MAP, false, true));
        } else if (id.equals("whenResourceMissingType")) {
            jrDataset.setWhenResourceMissingType(whenResMissTypeD.getEnumValue(value));
        } else if (id.equals("query")) {
            if (value instanceof MQuery) {
                this.unsetChildListener(this.mQuery);
                this.mQuery = (MQuery)value;
                this.setChildListener(this.mQuery);
                JRDesignQuery jrQuery = this.mQuery.getValue();
                jrDataset.setQuery(jrQuery);
            }
        } else if (id.equals("net.sf.jasperreports.data.adapter")) {
            if (value == null || value.toString().trim().isEmpty()) {
                jrDataset.getPropertiesMap().removeProperty("net.sf.jasperreports.data.adapter");
            } else {
                jrDataset.getPropertiesMap().setProperty("net.sf.jasperreports.data.adapter", value.toString());
            }
            this.firePropertyChange(new PropertyChangeEvent(jrDataset, "net.sf.jasperreports.data.adapter", null, value));
        }
    }

    public String toString() {
        return this.getDisplayText();
    }

    public static JRDesignDataset createJRDataset(JasperReportsConfiguration jConfig, JasperDesign jrDesign) {
        JRDesignDataset jrDesignDataset = new JRDesignDataset((JasperReportsContext)jConfig, false);
        jrDesignDataset.setName(ModelUtils.getDefaultName(jrDesign.getDatasetMap(), "Dataset"));
        JRDesignQuery jrDesignQuery = new JRDesignQuery();
        jrDesignQuery.setLanguage("sql");
        jrDesignQuery.setText("");
        jrDesignDataset.setQuery(jrDesignQuery);
        return jrDesignDataset;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MReport) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    public MParameterSystem getParamater(String name) {
        List<INode> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            children = this.mreport.getChildren();
        }
        for (INode n : children) {
            if (!(n instanceof MParameters)) continue;
            for (INode nf : n.getChildren()) {
                MParameterSystem mfield = (MParameterSystem)nf;
                if (!mfield.getValue().getName().equals(name)) continue;
                return mfield;
            }
        }
        return null;
    }

    public MField getField(String name) {
        List<INode> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            children = this.mreport.getChildren();
        }
        for (INode n : children) {
            if (!(n instanceof MFields)) continue;
            for (INode iNode : FieldUtils.getFields((MFields)n)) {
                MField mfield = (MField)iNode;
                if (!mfield.getValue().getName().equals(name)) continue;
                return mfield;
            }
        }
        return null;
    }

    public MFields getMFields() {
        return this.getFirstChildOfType(MFields.class);
    }

    public MParameters<?> getMParameters() {
        return this.getFirstChildOfType(MParameters.class);
    }

    public MSortFields getMSortFields() {
        return this.getFirstChildOfType(MSortFields.class);
    }

    public <T> T getFirstChildOfType(Class<T> classType) {
        List<INode> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            children = this.mreport.getChildren();
        }
        for (INode n : children) {
            if (!classType.isInstance(n)) continue;
            return (T)n;
        }
        return null;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

