/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.dataset.command;

import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.property.dataset.wizard.DatasetWizard;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class CreateDatasetCommand
extends Command {
    private JRDesignDataset jrDataset;
    private JasperDesign jrDesign;
    private JasperReportsConfiguration jConfig;
    private int index;

    public CreateDatasetCommand(JasperReportsConfiguration jConfig, JRDesignDataset jrDataset) {
        this.jrDataset = jrDataset;
        this.jrDesign = jConfig.getJasperDesign();
        this.jConfig = jConfig;
        this.index = -1;
    }

    public CreateDatasetCommand(MReport destNode, MDataset srcNode, int index) {
        this.jrDesign = destNode.getJasperDesign();
        this.jConfig = destNode.getJasperConfiguration();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrDataset = srcNode.getValue();
        }
    }

    public void execute() {
        this.createObject();
        if (this.jrDataset != null) {
            try {
                if (this.index < 0 || this.index > this.jrDesign.getDatasetsList().size()) {
                    this.jrDesign.addDataset(this.jrDataset);
                } else {
                    this.jrDesign.addDataset(this.index, this.jrDataset);
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createObject() {
        if (this.jrDataset == null) {
            DatasetWizard wizard = new DatasetWizard();
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wizard.setConfig(this.jConfig, false);
            dialog.create();
            if (dialog.open() == 0) {
                this.jrDataset = wizard.getDataset();
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDesign.removeDataset((JRDataset)this.jrDataset);
    }
}

