/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.gef.commands.Command;

public class ReorderFieldCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignField jrField;
    private JRDesignDataset jrDataset;

    public ReorderFieldCommand(MField child, MFields parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = parent.getValue();
        this.jrField = child.getValue();
    }

    public ReorderFieldCommand(JRDesignField child, JRDesignDataset jrDataset, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = jrDataset;
        this.jrField = child;
    }

    public void execute() {
        try {
            this.oldIndex = this.jrDataset.getFieldsList().indexOf(this.jrField);
            this.jrDataset.removeField((JRField)this.jrField);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getFieldsList().size()) {
                this.jrDataset.addField((JRField)this.jrField);
            } else {
                this.jrDataset.addField(this.newIndex, (JRField)this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDataset.removeField((JRField)this.jrField);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getFieldsList().size()) {
                this.jrDataset.addField((JRField)this.jrField);
            } else {
                this.jrDataset.addField(this.oldIndex, (JRField)this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

