/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.field.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MFields;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.gef.commands.Command;

public class ReplaceAllFieldsCommand
extends Command {
    private List<JRDesignField> oldJRFields;
    private List<JRDesignField> newOrderedJRFields;
    private JRDesignDataset jrDataset;

    public ReplaceAllFieldsCommand(List<JRDesignField> children, MFields parent) {
        super(Messages.ReplaceAllFieldsCommand_Label);
        this.jrDataset = parent.getValue();
        this.newOrderedJRFields = children;
        this.oldJRFields = new ArrayList<JRDesignField>(this.jrDataset.getFieldsList().size());
    }

    public void execute() {
        try {
            JRField[] originalFields = this.jrDataset.getFields();
            int i = 0;
            while (i < originalFields.length) {
                this.jrDataset.removeField(originalFields[i]);
                this.oldJRFields.add((JRDesignField)originalFields[i]);
                ++i;
            }
            int j = 0;
            while (j < this.newOrderedJRFields.size()) {
                this.jrDataset.addField((JRField)this.newOrderedJRFields.get(j));
                ++j;
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllFieldsCommand_ExecuteError, (Throwable)e);
        }
    }

    public void undo() {
        try {
            JRField[] fields;
            JRField[] jRFieldArray = fields = this.jrDataset.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                JRField jRField = jRFieldArray[n2];
                this.jrDataset.removeField(jRField);
                ++n2;
            }
            for (JRField jRField : this.oldJRFields) {
                this.jrDataset.addField(jRField);
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllFieldsCommand_UndoError, (Throwable)e);
        }
    }
}

