/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.genericElement;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MComponentElement
extends MGraphicElement {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("component");
        }
        return iconDescriptor;
    }

    public MComponentElement() {
    }

    public MComponentElement(ANode parent, JRDesignComponentElement jrCrosstab, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrCrosstab);
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MComponentElement.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MComponentElement.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        String componentKey = (String)this.getPropertyValue("componentKey");
        String tooltip = MComponentElement.getIconDescriptor().getToolTip();
        if (componentKey != null) {
            tooltip = String.valueOf(tooltip) + "\n" + componentKey;
        }
        return tooltip;
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NTextPropertyDescriptor nameD = new NTextPropertyDescriptor("componentKey", "Component Key");
        nameD.setDescription("Component key.");
        nameD.setReadOnly(true);
        desc.add((IPropertyDescriptor)nameD);
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        if (id.equals("componentKey")) {
            ComponentKey ckey = jrElement.getComponentKey();
            if (ckey != null) {
                return String.valueOf(ckey.getName()) + " " + ckey.getNamespacePrefix() + " " + ckey.getNamespace();
            }
            return null;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        super.setPropertyValue(id, value);
    }
}

