/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

public class GroupNameValidator
extends AbstractJSSCellEditorValidator {
    public String isValid(Object value) {
        String selectedName = ((JRGroup)this.getTarget().getValue()).getName();
        if (value.equals(selectedName)) {
            return null;
        }
        JasperDesign d = this.getTarget().getJasperDesign();
        if (d != null) {
            JRGroup group = (JRGroup)d.getGroupsMap().get(value);
            if (group != null) {
                String message = MessageFormat.format(Messages.GroupSection_SameNameErrorMsg, value);
                return message;
            }
            JRVariable groupVar = (JRVariable)this.getTarget().getJasperDesign().getVariablesMap().get(value + "_COUNT");
            if (groupVar != null) {
                String message = MessageFormat.format(Messages.GroupSection_SameVariableNameErrorMsg, value + "_COUNT", value);
                return message;
            }
        }
        return null;
    }
}

