/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.group;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.group.GroupNameValidator;
import com.jaspersoft.studio.model.group.MGroups;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MGroup
extends APropertyNode
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<FooterPositionEnum> positionD;
    private static GroupNameValidator validator;
    private static final Integer CONST_MIN_HEIGHT;

    static {
        CONST_MIN_HEIGHT = new Integer(0);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("group");
        }
        return iconDescriptor;
    }

    public MGroup() {
    }

    public MGroup(ANode parent, JRDesignGroup jfRield, int newIndex) {
        super(parent, newIndex);
        this.setValue(jfRield);
    }

    @Override
    public String getDisplayText() {
        return ((JRDesignGroup)this.getValue()).getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MGroup.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MGroup.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateValidator();
    }

    public void updateValidator() {
        if (validator == null) {
            validator = new GroupNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateValidator();
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MGroup_name_description);
        desc.add((IPropertyDescriptor)nameD);
        JRExpressionPropertyDescriptor expressionD = new JRExpressionPropertyDescriptor("expression", Messages.common_expression);
        expressionD.setDescription(Messages.MGroup_expression_description);
        desc.add((IPropertyDescriptor)expressionD);
        PixelPropertyDescriptor minhD = new PixelPropertyDescriptor("minHeightToStartNewPage", Messages.MGroup_minHeightTitle);
        minhD.setDescription(Messages.MGroup_minHeightDescription);
        desc.add((IPropertyDescriptor)minhD);
        IntegerPropertyDescriptor minStartTopD = new IntegerPropertyDescriptor("minDetailsToStartFromTop", Messages.MGroup_MinDetailsTSFTTitle);
        minStartTopD.setDescription(Messages.MGroup_MinDetailsTSFTDescription);
        desc.add((IPropertyDescriptor)minStartTopD);
        CheckBoxPropertyDescriptor stNewColD = new CheckBoxPropertyDescriptor("isStartNewColumn", Messages.MGroup_newColTitle);
        stNewColD.setDescription(Messages.MGroup_newColDescription);
        desc.add((IPropertyDescriptor)stNewColD);
        CheckBoxPropertyDescriptor stNewPageD = new CheckBoxPropertyDescriptor("isStartNewPage", Messages.MGroup_newPageTitle);
        stNewPageD.setDescription(Messages.MGroup_newPageDescription);
        desc.add((IPropertyDescriptor)stNewPageD);
        CheckBoxPropertyDescriptor stPrevOrfanFooterD = new CheckBoxPropertyDescriptor("preventOrphanFooter", Messages.MGroup_PreventOrphanFooterTitle);
        stPrevOrfanFooterD.setDescription(Messages.MGroup_PreventOrphanFooterTitle);
        desc.add((IPropertyDescriptor)stPrevOrfanFooterD);
        CheckBoxPropertyDescriptor rPageNumD = new CheckBoxPropertyDescriptor("isResetPageNumber", Messages.MGroup_pageNumberTitle);
        rPageNumD.setDescription(Messages.MGroup_pageNumberDescription);
        desc.add((IPropertyDescriptor)rPageNumD);
        CheckBoxPropertyDescriptor rHeadEPD = new CheckBoxPropertyDescriptor("isReprintHeaderOnEachPage", Messages.MGroup_reprintHeaderEPTitle);
        rHeadEPD.setDescription(Messages.MGroup_reprintHeaderEPDescription);
        desc.add((IPropertyDescriptor)rHeadEPD);
        CheckBoxPropertyDescriptor rColEPD = new CheckBoxPropertyDescriptor("isReprintHeaderOnEachColumn", Messages.MGroup_ReprintHeaderECTitle);
        rHeadEPD.setDescription(Messages.MGroup_ReprintHeaderECDescription);
        desc.add((IPropertyDescriptor)rColEPD);
        CheckBoxPropertyDescriptor keepToD = new CheckBoxPropertyDescriptor("keepTogether", Messages.MGroup_keepTitle);
        keepToD.setDescription(Messages.MGroup_keepDescription);
        desc.add((IPropertyDescriptor)keepToD);
        positionD = new NamedEnumPropertyDescriptor<FooterPositionEnum>("footerPosition", Messages.MGroup_footerPosTitle, FooterPositionEnum.COLLATE_AT_BOTTOM, NullEnum.NOTNULL);
        positionD.setDescription(Messages.MGroup_footerPosDescription);
        desc.add((IPropertyDescriptor)positionD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#group");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("minHeightToStartNewPage", new DefaultValue(CONST_MIN_HEIGHT, false));
        defaultsMap.put("minDetailsToStartFromTop", new DefaultValue(0, false));
        defaultsMap.put("keepTogether", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isReprintHeaderOnEachPage", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isReprintHeaderOnEachColumn", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isResetPageNumber", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isStartNewColumn", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isStartNewPage", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("preventOrphanFooter", new DefaultValue(Boolean.FALSE, false));
        int footerPositionValue = NamedEnumPropertyDescriptor.getIntValue(FooterPositionEnum.NORMAL, NullEnum.NOTNULL, FooterPositionEnum.NORMAL);
        defaultsMap.put("footerPosition", new DefaultValue(footerPositionValue, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignGroup jrGroup = (JRDesignGroup)this.getValue();
        if (id.equals("name")) {
            return jrGroup.getName();
        }
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrGroup.getExpression());
        }
        if (id.equals("minHeightToStartNewPage")) {
            return jrGroup.getMinHeightToStartNewPage();
        }
        if (id.equals("minDetailsToStartFromTop")) {
            return jrGroup.getMinDetailsToStartFromTop();
        }
        if (id.equals("isStartNewColumn")) {
            return jrGroup.isStartNewColumn();
        }
        if (id.equals("isStartNewPage")) {
            return jrGroup.isStartNewPage();
        }
        if (id.equals("isResetPageNumber")) {
            return jrGroup.isResetPageNumber();
        }
        if (id.equals("isReprintHeaderOnEachPage")) {
            return jrGroup.isReprintHeaderOnEachPage();
        }
        if (id.equals("isReprintHeaderOnEachColumn")) {
            return jrGroup.isReprintHeaderOnEachColumn();
        }
        if (id.equals("keepTogether")) {
            return jrGroup.isKeepTogether();
        }
        if (id.equals("preventOrphanFooter")) {
            return jrGroup.isPreventOrphanFooter();
        }
        if (id.equals("footerPosition")) {
            return positionD.getIntValue(jrGroup.getFooterPositionValue());
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            JRDesignGroup jrGroup = (JRDesignGroup)this.getValue();
            JasperDesign design = this.getJasperDesign();
            if (design != null) {
                design.getGroupsMap().remove(evt.getOldValue());
                design.getGroupsMap().put(jrGroup.getName(), jrGroup);
                Map<String, JRVariable> variablesMap = this.getVariablesMap();
                JRVariable groupVar = variablesMap.get(evt.getOldValue() + "_COUNT");
                if (groupVar != null) {
                    ((JRDesignVariable)groupVar).setName(String.valueOf(jrGroup.getName()) + "_COUNT");
                }
            }
        }
        super.propertyChange(evt);
    }

    protected Map<String, JRVariable> getVariablesMap() {
        if (this.getParent() != null && this.getParent().getParent() instanceof MDataset) {
            return ((MDataset)this.getParent().getParent()).getValue().getVariablesMap();
        }
        return this.getJasperDesign().getVariablesMap();
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignGroup jrGroup = (JRDesignGroup)this.getValue();
        if (id.equals("name")) {
            jrGroup.setName((String)value);
        } else if (id.equals("expression")) {
            jrGroup.setExpression(ExprUtil.setValues(jrGroup.getExpression(), value, null));
        } else if (id.equals("minHeightToStartNewPage")) {
            int minH = 0;
            if (value != null) {
                minH = Math.max(0, (Integer)value);
            }
            jrGroup.setMinHeightToStartNewPage(minH);
        } else if (id.equals("minDetailsToStartFromTop")) {
            int minH = 0;
            if (value != null) {
                minH = Math.max(0, (Integer)value);
            }
            jrGroup.setMinDetailsToStartFromTop(minH);
        } else if (id.equals("isStartNewColumn")) {
            jrGroup.setStartNewColumn(((Boolean)value).booleanValue());
        } else if (id.equals("isStartNewPage")) {
            jrGroup.setStartNewPage(((Boolean)value).booleanValue());
        } else if (id.equals("isResetPageNumber")) {
            jrGroup.setResetPageNumber(((Boolean)value).booleanValue());
        } else if (id.equals("isReprintHeaderOnEachPage")) {
            jrGroup.setReprintHeaderOnEachPage(((Boolean)value).booleanValue());
        } else if (id.equals("isReprintHeaderOnEachColumn")) {
            jrGroup.setReprintHeaderOnEachColumn(((Boolean)value).booleanValue());
        } else if (id.equals("preventOrphanFooter")) {
            jrGroup.setPreventOrphanFooter(((Boolean)value).booleanValue());
        } else if (id.equals("keepTogether")) {
            jrGroup.setKeepTogether(((Boolean)value).booleanValue());
        } else if (id.equals("footerPosition")) {
            jrGroup.setFooterPosition(positionD.getEnumValue(value));
        }
    }

    public static JRDesignGroup createJRGroup(JRDesignDataset jrDataset) {
        JRDesignGroup jrDesignGroup = new JRDesignGroup();
        jrDesignGroup.setName(ModelUtils.getDefaultName(jrDataset.getGroupsMap(), "Group"));
        return jrDesignGroup;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MGroups) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public Object getAdapter(Class adapter) {
        ExpressionContext expContext;
        if (ExpressionContext.class.equals((Object)adapter) && this.getParent() != null && (expContext = (ExpressionContext)this.getParent().getAdapter(ExpressionContext.class)) != null) {
            return expContext;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

