/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.image;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.JRImageExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.ImageHAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.ImageVAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.SpinnerPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MImage
extends MGraphicElementLineBox {
    public static final String PATH_ANNOTATION = "@path";
    public static final long serialVersionUID = 10200L;
    private static NamedEnumPropertyDescriptor<ScaleImageEnum> scaleImageD;
    private static ImageHAlignPropertyDescriptor hAlignD;
    private static NamedEnumPropertyDescriptor<FillEnum> fillD;
    private static ImageVAlignPropertyDescriptor vAlignD;
    private static NamedEnumPropertyDescriptor<OnErrorTypeEnum> onErrorTypeD;
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;
    private RWComboBoxPropertyDescriptor evalGroupD;
    private MHyperLink mHyperLink;
    private static NamedEnumPropertyDescriptor<RotationEnum> rotateD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("image");
        }
        return iconDescriptor;
    }

    public MImage() {
    }

    public MImage(ANode parent, JRDesignImage jrImage, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrImage);
    }

    public JRDesignImage getValue() {
        return (JRDesignImage)super.getValue();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evalGroupD != null) {
            this.evalGroupD.setItems(items);
        }
    }

    @Override
    public JRDataset getElementDataset() {
        return this.getElementDataset(this);
    }

    private JRDataset getElementDataset(ANode node) {
        JRDesignDatasetRun datasetRun;
        APropertyNode pnode;
        MDatasetRun mdataset;
        if (node instanceof APropertyNode && (mdataset = (MDatasetRun)(pnode = (APropertyNode)node).getPropertyValue("datasetRun")) != null && (datasetRun = mdataset.getValue()) != null) {
            String dsname = datasetRun.getDatasetName();
            return (JRDataset)this.getJasperDesign().getDatasetMap().get(dsname);
        }
        ANode parent = node.getParent();
        if (parent != null) {
            return this.getElementDataset(parent);
        }
        if (this.getJasperDesign() != null) {
            return this.getJasperDesign().getMainDataset();
        }
        return null;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        JRImageExpressionPropertyDescriptor expressionD = new JRImageExpressionPropertyDescriptor("expression", Messages.common_expression);
        expressionD.setDescription(Messages.MImage_expression_description);
        desc.add((IPropertyDescriptor)expressionD);
        expressionD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#imageExpression"));
        fillD = new NamedEnumPropertyDescriptor<FillEnum>("fill", Messages.common_fill, FillEnum.SOLID, NullEnum.INHERITED);
        fillD.setDescription(Messages.MImage_fill_description);
        desc.add((IPropertyDescriptor)fillD);
        fillD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#style_fill"));
        scaleImageD = new NamedEnumPropertyDescriptor<ScaleImageEnum>("scaleImage", Messages.MImage_scale_image, ScaleImageEnum.CLIP, NullEnum.INHERITED);
        scaleImageD.setDescription(Messages.MImage_scale_image_description);
        desc.add((IPropertyDescriptor)scaleImageD);
        hAlignD = new ImageHAlignPropertyDescriptor("horizontalImageAlignment", Messages.common_horizontal_alignment, NullEnum.INHERITED);
        hAlignD.setDescription(Messages.MImage_horizontal_alignment_description);
        desc.add((IPropertyDescriptor)hAlignD);
        vAlignD = new ImageVAlignPropertyDescriptor("verticalImageAlignment", Messages.common_vertical_alignment, NullEnum.INHERITED);
        vAlignD.setDescription(Messages.MImage_vertical_alignment_description);
        desc.add((IPropertyDescriptor)vAlignD);
        onErrorTypeD = new NamedEnumPropertyDescriptor<OnErrorTypeEnum>("onErrorType", Messages.MImage_on_error_type, OnErrorTypeEnum.BLANK, NullEnum.NULL);
        onErrorTypeD.setDescription(Messages.MImage_on_error_type_description);
        desc.add((IPropertyDescriptor)onErrorTypeD);
        evaluationTimeD = new NamedEnumPropertyDescriptor<EvaluationTimeEnum>("evaluationTime", Messages.MImage_evaluation_type, EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MImage_evaluation_type_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        rotateD = new NamedEnumPropertyDescriptor<RotationEnum>("rotation", Messages.common_rotation, RotationEnum.NONE, NullEnum.NOTNULL);
        rotateD.setDescription(Messages.MImage_on_error_type_description);
        desc.add((IPropertyDescriptor)rotateD);
        this.evalGroupD = new RWComboBoxPropertyDescriptor("evaluationGroup", Messages.MTextField_evaluation_group, new String[]{""}, NullEnum.NULL);
        this.evalGroupD.setDescription(Messages.MTextField_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evalGroupD);
        CheckBoxPropertyDescriptor usingCacheD = new CheckBoxPropertyDescriptor("isUsingCache", Messages.common_using_cache, NullEnum.INHERITED);
        usingCacheD.setDescription(Messages.MImage_using_cache_description);
        desc.add((IPropertyDescriptor)usingCacheD);
        CheckBoxPropertyDescriptor lazyD = new CheckBoxPropertyDescriptor("isLazy", Messages.MImage_lazy, NullEnum.NOTNULL);
        lazyD.setDescription(Messages.MImage_lazy_description);
        desc.add((IPropertyDescriptor)lazyD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#image");
        JRExpressionPropertyDescriptor anchorNameExp = new JRExpressionPropertyDescriptor("anchorNameExpression", Messages.MTextField_anchorNameLabel);
        anchorNameExp.setDescription(Messages.MTextField_anchorNameDescription);
        desc.add((IPropertyDescriptor)anchorNameExp);
        JRExpressionPropertyDescriptor bookmarkLevelExp = new JRExpressionPropertyDescriptor("bookmarkLevelExpression", Messages.MTextField_bookmarkLevelExpression);
        bookmarkLevelExp.setDescription(Messages.MTextField_bookmarkLevelExpressionDescription);
        desc.add((IPropertyDescriptor)bookmarkLevelExp);
        SpinnerPropertyDescriptor bookmarkLevel = new SpinnerPropertyDescriptor("bookmarkLevel", Messages.MTextField_bookmarkLevelLabel);
        bookmarkLevel.setDescription(Messages.MTextField_bookmarkLevelDescription);
        bookmarkLevel.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart_bookmarkLevel"));
        desc.add((IPropertyDescriptor)bookmarkLevel);
        if (this.mHyperLink == null) {
            this.mHyperLink = new MHyperLink(null);
        }
        this.mHyperLink.createPropertyDescriptors(desc);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#image");
        evaluationTimeD.setCategory(Messages.MImage_image_properties_category);
        this.evalGroupD.setCategory(Messages.MImage_image_properties_category);
        onErrorTypeD.setCategory(Messages.MImage_image_properties_category);
        scaleImageD.setCategory(Messages.MImage_image_properties_category);
        expressionD.setCategory(Messages.MImage_image_properties_category);
        hAlignD.setCategory(Messages.MImage_image_properties_category);
        vAlignD.setCategory(Messages.MImage_image_properties_category);
        rotateD.setCategory(Messages.MImage_image_properties_category);
        usingCacheD.setCategory(Messages.MImage_image_properties_category);
        lazyD.setCategory(Messages.MImage_image_properties_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("fill", new DefaultValue(null, true));
        defaultsMap.put("rotation", new DefaultValue(RotationEnum.NONE, false));
        defaultsMap.put("scaleImage", new DefaultValue(null, true));
        defaultsMap.put("horizontalImageAlignment", new DefaultValue(null, true));
        defaultsMap.put("verticalImageAlignment", new DefaultValue(null, true));
        defaultsMap.put("expression", new DefaultValue("java.lang.String", false));
        defaultsMap.put("isLazy", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("evaluationTime", new DefaultValue(EvaluationTimeEnum.NOW, false));
        int onErrorValue = NamedEnumPropertyDescriptor.getIntValue(OnErrorTypeEnum.ERROR, NullEnum.NULL, OnErrorTypeEnum.ERROR);
        defaultsMap.put("onErrorType", new DefaultValue(onErrorValue, true));
        defaultsMap.putAll(new MHyperLink(null).getDefaultsPropertiesMap());
        return defaultsMap;
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignImage jrElement = this.getValue();
        if (id.equals("fill")) {
            if (jrElement.getOwnFillValue() == null) {
                return null;
            }
            return fillD.getIntValue(jrElement.getOwnFillValue());
        }
        if (id.equals("scaleImage")) {
            if (jrElement.getOwnScaleImageValue() == null) {
                return null;
            }
            return scaleImageD.getIntValue(jrElement.getOwnScaleImageValue());
        }
        if (id.equals("horizontalImageAlignment")) {
            if (jrElement.getOwnHorizontalImageAlign() == null) {
                return null;
            }
            return hAlignD.getIntValue(jrElement.getOwnHorizontalImageAlign());
        }
        if (id.equals("verticalImageAlignment")) {
            if (jrElement.getOwnVerticalImageAlign() == null) {
                return null;
            }
            return vAlignD.getIntValue(jrElement.getOwnVerticalImageAlign());
        }
        if (id.equals("rotation")) {
            if (jrElement.getOwnRotation() == null) {
                return null;
            }
            return rotateD.getIntValue(jrElement.getOwnRotation());
        }
        if (id.equals("onErrorType")) {
            return onErrorTypeD.getIntValue(jrElement.getOnErrorTypeValue());
        }
        if (id.equals("evaluationTime")) {
            return jrElement.getEvaluationTimeValue();
        }
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrElement.getExpression());
        }
        if (id.equals("evaluationGroup")) {
            if (jrElement.getEvaluationGroup() != null) {
                return jrElement.getEvaluationGroup().getName();
            }
            return "";
        }
        if (id.equals("hyperlinkParameters")) {
            return jrElement.getHyperlinkParameters();
        }
        if (id.equals("isUsingCache")) {
            return jrElement.getUsingCache();
        }
        if (id.equals("isLazy")) {
            return new Boolean(jrElement.isLazy());
        }
        if (id.equals("linkTarget")) {
            return jrElement.getLinkTarget();
        }
        if (id.equals("hyperlinkType")) {
            return jrElement.getLinkType();
        }
        if (id.equals("hyperlinkAnchorExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkAnchorExpression());
        }
        if (id.equals("hyperlinkPageExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkPageExpression());
        }
        if (id.equals("hyperlinkReferenceExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkReferenceExpression());
        }
        if (id.equals("hyperlinkTooltipExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkTooltipExpression());
        }
        if (id.equals("hyperlinkWhenExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkWhenExpression());
        }
        if (id.equals("anchorNameExpression")) {
            return ExprUtil.getExpression(jrElement.getAnchorNameExpression());
        }
        if (id.equals("bookmarkLevelExpression")) {
            return ExprUtil.getExpression(jrElement.getBookmarkLevelExpression());
        }
        if (id.equals("bookmarkLevel")) {
            return jrElement.getBookmarkLevel();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRDesignImage jrElement = this.getValue();
        if (id.equals("fill")) {
            return fillD.getIntValue(jrElement.getFillValue());
        }
        if (id.equals("scaleImage")) {
            return scaleImageD.getIntValue(jrElement.getScaleImageValue());
        }
        if (id.equals("horizontalImageAlignment")) {
            return hAlignD.getIntValue(jrElement.getHorizontalImageAlign());
        }
        if (id.equals("verticalImageAlignment")) {
            return vAlignD.getIntValue(jrElement.getVerticalImageAlign());
        }
        if (id.equals("onErrorType")) {
            return onErrorTypeD.getIntValue(jrElement.getOnErrorTypeValue());
        }
        if (id.equals("evaluationTime")) {
            return jrElement.getEvaluationTimeValue();
        }
        if (id.equals("rotation")) {
            return rotateD.getIntValue(jrElement.getRotation());
        }
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrElement.getExpression());
        }
        if (id.equals("evaluationGroup")) {
            if (jrElement.getEvaluationGroup() != null) {
                return jrElement.getEvaluationGroup().getName();
            }
            return "";
        }
        if (id.equals("isUsingCache")) {
            return jrElement.getUsingCache();
        }
        if (id.equals("isLazy")) {
            return new Boolean(jrElement.isLazy());
        }
        if (id.equals("linkTarget")) {
            return jrElement.getLinkTarget();
        }
        if (id.equals("hyperlinkType")) {
            return jrElement.getLinkType();
        }
        if (id.equals("hyperlinkAnchorExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkAnchorExpression());
        }
        if (id.equals("hyperlinkPageExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkPageExpression());
        }
        if (id.equals("hyperlinkReferenceExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkReferenceExpression());
        }
        if (id.equals("hyperlinkTooltipExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkTooltipExpression());
        }
        if (id.equals("hyperlinkWhenExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkWhenExpression());
        }
        return super.getPropertyActualValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignImage jrElement = this.getValue();
        if (id.equals("fill")) {
            jrElement.setFill(fillD.getEnumValue(value));
        } else if (id.equals("scaleImage")) {
            jrElement.setScaleImage(scaleImageD.getEnumValue(value));
        } else if (id.equals("horizontalImageAlignment")) {
            jrElement.setHorizontalImageAlign((HorizontalImageAlignEnum)hAlignD.getEnumValue(value));
        } else if (id.equals("rotation")) {
            jrElement.setRotation(rotateD.getEnumValue(value));
        } else if (id.equals("verticalImageAlignment")) {
            jrElement.setVerticalImageAlign((VerticalImageAlignEnum)vAlignD.getEnumValue(value));
        } else if (id.equals("onErrorType")) {
            jrElement.setOnErrorType(onErrorTypeD.getEnumValue(value));
        } else if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            jrElement.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                jrElement.setEvaluationGroup(null);
            }
        } else if (id.equals("evaluationGroup")) {
            jrElement.setEvaluationGroup(ModelUtils.getGroupForProperty(value, (JRDesignDataset)this.getElementDataset()));
        } else if (id.equals("expression")) {
            jrElement.setExpression(ExprUtil.setValues(jrElement.getExpression(), value));
        } else if (id.equals("isUsingCache")) {
            jrElement.setUsingCache((Boolean)value);
        } else if (id.equals("isLazy")) {
            jrElement.setLazy(((Boolean)value).booleanValue());
        } else if (id.equals("linkTarget")) {
            jrElement.setLinkTarget((String)value);
        } else if (id.equals("hyperlinkType")) {
            jrElement.setLinkType((String)value);
        } else if (id.equals("hyperlinkAnchorExpression")) {
            jrElement.setHyperlinkAnchorExpression(ExprUtil.setValues(jrElement.getHyperlinkAnchorExpression(), value));
        } else if (id.equals("hyperlinkPageExpression")) {
            jrElement.setHyperlinkPageExpression(ExprUtil.setValues(jrElement.getHyperlinkPageExpression(), value));
        } else if (id.equals("hyperlinkReferenceExpression")) {
            jrElement.setHyperlinkReferenceExpression(ExprUtil.setValues(jrElement.getHyperlinkReferenceExpression(), value));
        } else if (id.equals("hyperlinkTooltipExpression")) {
            jrElement.setHyperlinkTooltipExpression(ExprUtil.setValues(jrElement.getHyperlinkTooltipExpression(), value));
        } else if (id.equals("hyperlinkWhenExpression")) {
            jrElement.setHyperlinkWhenExpression(ExprUtil.setValues(jrElement.getHyperlinkWhenExpression(), value));
        } else if (id.equals("anchorNameExpression")) {
            jrElement.setAnchorNameExpression(ExprUtil.setValues(jrElement.getAnchorNameExpression(), value));
        } else if (id.equals("bookmarkLevelExpression")) {
            jrElement.setBookmarkLevelExpression(ExprUtil.setValues(jrElement.getBookmarkLevelExpression(), value));
        } else if (id.equals("bookmarkLevel")) {
            jrElement.setBookmarkLevel(value != null ? Integer.parseInt(value.toString()) : 0);
        } else if (id.equals("hyperlinkParameters")) {
            int n;
            int n2;
            JRHyperlinkParameter[] jRHyperlinkParameterArray;
            JRHyperlinkParameter[] oldParameters = jrElement.getHyperlinkParameters();
            JRHyperlinkParameter[] newParameters = (JRHyperlinkParameter[])value;
            if (oldParameters != null) {
                jRHyperlinkParameterArray = oldParameters;
                n2 = oldParameters.length;
                n = 0;
                while (n < n2) {
                    JRHyperlinkParameter prm = jRHyperlinkParameterArray[n];
                    jrElement.removeHyperlinkParameter(prm);
                    ++n;
                }
            }
            jRHyperlinkParameterArray = newParameters;
            n2 = newParameters.length;
            n = 0;
            while (n < n2) {
                JRHyperlinkParameter param = jRHyperlinkParameterArray[n];
                jrElement.addHyperlinkParameter(param);
                ++n;
            }
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 50;
    }

    @Override
    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(this.getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 50;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applayDefault) {
        JRDesignImage jrDesignElement = new JRDesignImage((JRDefaultStyleProvider)jasperDesign);
        if (applayDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)jrDesignElement);
        }
        jrDesignElement.setWidth(this.getDefaultWidth());
        jrDesignElement.setHeight(this.getDefaultHeight());
        return jrDesignElement;
    }

    @Override
    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MImage.getIconDescriptor().getTitle() : p;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MImage.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        JRDesignImage value = this.getValue();
        if (value != null) {
            String tip = "";
            if (value.getExpression() != null) {
                tip = String.valueOf(tip) + value.getExpression().getText();
            }
            if (tip.trim().isEmpty()) {
                return String.valueOf(MImage.getIconDescriptor().getTitle()) + ": " + Messages.common_noExpressionMessage;
            }
            return String.valueOf(MImage.getIconDescriptor().getTitle()) + ": " + tip;
        }
        return MImage.getIconDescriptor().getToolTip();
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("fill");
        result.add("scaleImage");
        result.add("horizontalImageAlignment");
        result.add("rotation");
        result.add("verticalImageAlignment");
        result.add("expression");
        return result;
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignImage jrSource = this.getValue();
        if (jrSource != null) {
            JRDesignImage jrTarget = (JRDesignImage)target;
            jrTarget.setFill(jrSource.getOwnFillValue());
            jrTarget.setScaleImage(jrSource.getOwnScaleImageValue());
            jrTarget.setHorizontalImageAlign(jrSource.getOwnHorizontalImageAlign());
            jrTarget.setVerticalImageAlign(jrSource.getOwnVerticalImageAlign());
            jrTarget.setRotation(jrSource.getOwnRotation());
            jrTarget.setOnErrorType(jrSource.getOnErrorTypeValue());
            jrTarget.setUsingCache(jrSource.getUsingCache());
            jrTarget.setLazy(jrSource.isLazy());
        }
    }
}

