/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.parameter;

import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.parameter.ParameterNameValidator;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeComboCellEditor;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPClassTypeCombo;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MParameterSystem
extends APropertyNode
implements IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;
    private static ParameterNameValidator validator;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("parameter-report");
        }
        return iconDescriptor;
    }

    public MParameterSystem() {
        this.setEditable(false);
    }

    public MParameterSystem(ANode parent, JRDesignParameter jrParameter, int newIndex) {
        super(parent, newIndex);
        this.setEditable(false);
        this.setValue(jrParameter);
    }

    public JRDesignParameter getValue() {
        return (JRDesignParameter)super.getValue();
    }

    @Override
    public Color getForeground() {
        return UIUtils.getSystemColor((int)39);
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MParameterSystem.getIconDescriptor().getIcon16();
    }

    @Override
    public String getDisplayText() {
        return this.getValue().getName();
    }

    @Override
    public String getToolTip() {
        return MParameterSystem.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateNameValidator();
    }

    protected void updateNameValidator() {
        if (validator == null) {
            validator = new ParameterNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateNameValidator();
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MParameterSystem_name_description);
        desc.add((IPropertyDescriptor)nameD);
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor((Object)"valueClassName", Messages.common_class, ClassTypeComboCellEditor.DEFAULT_ITEMS){

            @Override
            public ASPropertyWidget<RWComboBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                SPClassTypeCombo<RWComboBoxPropertyDescriptor> classNameWidget = new SPClassTypeCombo<RWComboBoxPropertyDescriptor>(parent, section, this);
                classNameWidget.setClassesOfType(this.classes);
                classNameWidget.setReadOnly(this.readOnly);
                return classNameWidget;
            }
        };
        classD.setDescription(Messages.MParameterSystem_class_description);
        desc.add((IPropertyDescriptor)classD);
        classD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#parameter_class"));
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("valueClassName", new DefaultValue("java.lang.String", false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignParameter jrParameter = this.getValue();
        if (id.equals("name")) {
            return jrParameter.getName();
        }
        if (id.equals("valueClassName")) {
            return jrParameter.getValueClassName();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            JRDesignDataset d = ModelUtils.getDataset(this);
            JRDesignParameter jrParameter = this.getValue();
            if (d != null) {
                d.getParametersMap().remove(evt.getOldValue());
                d.getParametersMap().put(jrParameter.getName(), jrParameter);
            }
        }
        super.propertyChange(evt);
    }

    public void setPropertyValue(Object id, Object value) {
        if (!this.isEditable()) {
            return;
        }
        JRDesignParameter jrParameter = this.getValue();
        if (id.equals("name")) {
            if (!value.equals("")) {
                JRDesignDataset d = ModelUtils.getDataset(this);
                for (JRParameter p : d.getParametersList()) {
                    if (p == jrParameter || !p.getName().equals(value)) continue;
                    return;
                }
                jrParameter.setName((String)value);
            }
        } else if (id.equals("valueClassName")) {
            jrParameter.setValueClassName((String)value);
        }
    }

    public static JRDesignParameter createJRParameter(JRDesignDataset jrDataset) {
        JRDesignParameter jrDesignParameter = new JRDesignParameter();
        jrDesignParameter.setSystemDefined(true);
        jrDesignParameter.setName(ModelUtils.getDefaultName(jrDataset.getParametersMap(), "Parameter"));
        return jrDesignParameter;
    }
}

