/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.parameter.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.parameter.command.ReorderParameterCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateParameterCommand
extends Command {
    private JRDesignParameter jrParameter;
    private JRDesignDataset jrDataset;
    private int index;
    private JasperReportsConfiguration jrContext;
    private ReorderParameterCommand rc;

    public CreateParameterCommand(MParameters<?> destNode, MParameter srcNode, int index) {
        this.jrDataset = (JRDesignDataset)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrParameter = srcNode.getValue();
        }
        this.jrContext = destNode.getJasperConfiguration();
    }

    public CreateParameterCommand(JRDesignDataset jDataset, JRParameter jParam, JasperReportsConfiguration jrContext, int index) {
        this.jrContext = jrContext;
        this.jrDataset = jDataset;
        this.index = index;
        this.jrParameter = (JRDesignParameter)jParam;
    }

    public void execute() {
        block9: {
            if (this.rc != null) {
                this.rc.execute();
                return;
            }
            if (this.jrParameter == null) {
                this.jrParameter = MParameter.createJRParameter(this.jrDataset);
            }
            if (this.jrParameter != null) {
                try {
                    if (this.jrDataset.getParametersList().contains(this.jrParameter)) {
                        this.rc = new ReorderParameterCommand(this.jrParameter, this.jrDataset, this.jrContext, this.index);
                        this.rc.execute();
                        return;
                    }
                    if (this.index < 0 || this.index > this.jrDataset.getParametersList().size()) {
                        this.jrDataset.addParameter((JRParameter)this.jrParameter);
                    } else {
                        this.jrDataset.addParameter(this.index, (JRParameter)this.jrParameter);
                    }
                    SelectionHelper.setOutlineSelection(this.jrParameter);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("Duplicate declaration")) break block9;
                    String defaultName = ModelUtils.getDefaultName(this.jrDataset.getParametersMap(), "CopyOFParameter_");
                    InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateParameterCommand_parameter_name, Messages.CreateParameterCommand_parameter_name_dialog_text, defaultName, null);
                    if (dlg.open() == 0) {
                        this.jrParameter.setName(dlg.getValue());
                        this.execute();
                    }
                    return;
                }
            }
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        if (this.rc != null) {
            this.rc.undo();
        } else {
            this.jrDataset.removeParameter((JRParameter)this.jrParameter);
        }
    }
}

