/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.parameter.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.parameter.MParameters;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.gef.commands.Command;

public class ReplaceAllParametersCommand
extends Command {
    private List<JRDesignParameter> oldJRParameters;
    private List<JRDesignParameter> newOrderedJRParameters;
    private JRDesignDataset jrDataset;

    public ReplaceAllParametersCommand(List<JRDesignParameter> children, MParameters<?> mParameters) {
        super(Messages.ReplaceAllParametersCommand_Label);
        this.jrDataset = (JRDesignDataset)mParameters.getValue();
        this.newOrderedJRParameters = children;
        this.oldJRParameters = new ArrayList<JRDesignParameter>(this.jrDataset.getParametersList().size());
    }

    public void execute() {
        try {
            JRParameter[] originalParameters = this.jrDataset.getParameters();
            int i = 0;
            while (i < originalParameters.length) {
                this.jrDataset.removeParameter(originalParameters[i]);
                this.oldJRParameters.add((JRDesignParameter)originalParameters[i]);
                ++i;
            }
            int j = 0;
            while (j < this.newOrderedJRParameters.size()) {
                this.jrDataset.addParameter((JRParameter)this.newOrderedJRParameters.get(j));
                ++j;
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllParametersCommand_ExecuteError, (Throwable)e);
        }
    }

    public void undo() {
        try {
            JRParameter[] fields;
            JRParameter[] jRParameterArray = fields = this.jrDataset.getParameters();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                JRParameter jRParameter = jRParameterArray[n2];
                this.jrDataset.removeParameter(jRParameter);
                ++n2;
            }
            for (JRParameter jRParameter : this.oldJRParameters) {
                this.jrDataset.addParameter(jRParameter);
            }
        }
        catch (JRException e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio", (String)Messages.ReplaceAllParametersCommand_UndoError, (Throwable)e);
        }
    }
}

