/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPToolBarEnum;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MSortField
extends APropertyNode
implements ICopyable,
IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;
    private RComboBoxPropertyDescriptor nameD;
    private JRDesignDataset dataset;
    private static NamedEnumPropertyDescriptor<SortFieldTypeEnum> typeD;
    private static NamedEnumPropertyDescriptor<SortOrderEnum> orderD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("sortfield");
        }
        return iconDescriptor;
    }

    public MSortField() {
    }

    public MSortField(ANode parent, JRDesignSortField jfRield, int newIndex) {
        super(parent, newIndex);
        this.setValue(jfRield);
    }

    @Override
    public String getDisplayText() {
        return ((JRDesignSortField)this.getValue()).getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        if (this.getValue() != null) {
            JRDesignSortField sortField = (JRDesignSortField)this.getValue();
            if (sortField.getType().equals((Object)SortFieldTypeEnum.FIELD)) {
                return MField.getIconDescriptor().getIcon16();
            }
            if (sortField.getType().equals((Object)SortFieldTypeEnum.VARIABLE)) {
                return MVariable.getIconDescriptor().getIcon16();
            }
        }
        return MSortField.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MSortField.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        if (this.nameD != null) {
            JRDesignDataset jrDataset = this.getDataSet();
            if (jrDataset == null) {
                return;
            }
            if (this.getValue() != null) {
                Map sortFields = jrDataset.getSortFieldsMap();
                JRDesignSortField sortField = (JRDesignSortField)this.getValue();
                ArrayList<String> items = new ArrayList<String>();
                items.add(sortField.getName());
                if (sortField.getType().equals((Object)SortFieldTypeEnum.FIELD)) {
                    for (JRField f : jrDataset.getFieldsList()) {
                        JRSortField checkIfPresent = (JRSortField)sortFields.get(String.valueOf(f.getName()) + "|" + SortFieldTypeEnum.FIELD.getName());
                        if (checkIfPresent != null) continue;
                        items.add(f.getName());
                    }
                } else {
                    for (JRVariable f : jrDataset.getVariablesList()) {
                        JRSortField checkIfPresent = (JRSortField)sortFields.get(String.valueOf(f.getName()) + "|" + SortFieldTypeEnum.VARIABLE.getName());
                        if (checkIfPresent != null) continue;
                        items.add(f.getName());
                    }
                }
                this.nameD.setItems(items.toArray(new String[items.size()]));
            }
        }
    }

    protected JRDesignDataset getDataSet() {
        if (this.dataset != null) {
            return this.dataset;
        }
        return ModelUtils.getDataset(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.nameD = new RComboBoxPropertyDescriptor("name", Messages.common_name, new String[]{""});
        this.nameD.setDescription(Messages.MSortField_name_description);
        desc.add((IPropertyDescriptor)this.nameD);
        typeD = new NamedEnumPropertyDescriptor<SortFieldTypeEnum>((Object)"type", Messages.MSortField_typeTitle, SortFieldTypeEnum.FIELD, NullEnum.NOTNULL){

            @Override
            public ASPropertyWidget<NamedEnumPropertyDescriptor<SortFieldTypeEnum>> createWidget(Composite parent, AbstractSection section) {
                Image[] images = new Image[]{JaspersoftStudioPlugin.getInstance().getImage("icons/resources/fields-sort-16.png"), JaspersoftStudioPlugin.getInstance().getImage("icons/resources/variables-sort-16.png")};
                return new SPToolBarEnum<NamedEnumPropertyDescriptor<SortFieldTypeEnum>>(parent, section, this, images, false);
            }
        };
        typeD.setDescription("Sort field type");
        desc.add((IPropertyDescriptor)typeD);
        orderD = new NamedEnumPropertyDescriptor<SortOrderEnum>((Object)"order", Messages.common_order, SortOrderEnum.ASCENDING, NullEnum.NOTNULL){

            @Override
            public ASPropertyWidget<NamedEnumPropertyDescriptor<SortOrderEnum>> createWidget(Composite parent, AbstractSection section) {
                Image[] images = new Image[]{JaspersoftStudioPlugin.getInstance().getImage("icons/resources/sort-number-column.png"), JaspersoftStudioPlugin.getInstance().getImage("icons/resources/sort-number-descending.png")};
                return new SPToolBarEnum<NamedEnumPropertyDescriptor<SortOrderEnum>>(parent, section, this, images, false);
            }
        };
        orderD.setDescription(Messages.MSortField_order_description);
        desc.add((IPropertyDescriptor)orderD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#sortField");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        SortOrderEnum sortOrderValue = NamedEnumPropertyDescriptor.getEnumValue(SortOrderEnum.ASCENDING, NullEnum.NOTNULL, SortOrderEnum.ASCENDING);
        defaultsMap.put("order", new DefaultValue(sortOrderValue, false));
        SortFieldTypeEnum sortTypeValue = NamedEnumPropertyDescriptor.getEnumValue(SortFieldTypeEnum.FIELD, NullEnum.NOTNULL, SortFieldTypeEnum.FIELD);
        defaultsMap.put("type", new DefaultValue(sortTypeValue, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignSortField jrField = (JRDesignSortField)this.getValue();
        if (id.equals("name")) {
            return jrField.getName();
        }
        if (id.equals("order")) {
            if (orderD == null) {
                this.getPropertyDescriptors();
            }
            return orderD.getIntValue(jrField.getOrderValue());
        }
        if (id.equals("type")) {
            if (typeD == null) {
                this.getPropertyDescriptors();
            }
            return typeD.getIntValue(jrField.getType());
        }
        return null;
    }

    private String getSortFieldKey(JRSortField sortField) {
        return this.getSortFieldKey(sortField.getName(), sortField.getType().getName());
    }

    private String getSortFieldKey(String name, String type) {
        return String.valueOf(name) + "|" + type;
    }

    private void changeNameAndType(String oldName, String oldType, String newName, SortFieldTypeEnum newType, JRSortField field) {
        JRDesignDataset d = ModelUtils.getDataset(this);
        if (d != null) {
            String oldKey = this.getSortFieldKey(oldName, oldType);
            d.getSortFieldsMap().remove(oldKey);
            d.getSortFieldsMap().put(this.getSortFieldKey(newName, newType.getName()), field);
            JRDesignSortField jrField = (JRDesignSortField)field;
            jrField.setName(newName);
            jrField.setType(newType);
        }
    }

    private boolean selectFirstAvailableName(SortFieldTypeEnum newType) {
        block4: {
            JRDesignDataset d = ModelUtils.getDataset(this);
            JRDesignSortField jrField = (JRDesignSortField)this.getValue();
            if (newType.equals((Object)jrField.getType())) break block4;
            String oldType = jrField.getType().getName();
            if (newType.equals((Object)SortFieldTypeEnum.FIELD)) {
                List fields = d.getFieldsList();
                for (JRField field : fields) {
                    String newName = field.getName();
                    String key = this.getSortFieldKey(newName, SortFieldTypeEnum.FIELD.getName());
                    if (d.getSortFieldsMap().containsKey(key)) continue;
                    this.changeNameAndType(jrField.getName(), oldType, newName, SortFieldTypeEnum.FIELD, (JRSortField)jrField);
                    return true;
                }
            } else {
                List variables = d.getVariablesList();
                for (JRVariable variable : variables) {
                    String newName = variable.getName();
                    String key = this.getSortFieldKey(newName, SortFieldTypeEnum.VARIABLE.getName());
                    if (d.getSortFieldsMap().containsKey(key)) continue;
                    this.changeNameAndType(jrField.getName(), oldType, newName, SortFieldTypeEnum.VARIABLE, (JRSortField)jrField);
                    return true;
                }
            }
        }
        return false;
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignSortField jrField = (JRDesignSortField)this.getValue();
        if (id.equals("name")) {
            if (!value.equals("")) {
                String oldName = jrField.getName();
                String oldType = jrField.getType().getName();
                String newName = (String)value;
                this.changeNameAndType(oldName, oldType, newName, jrField.getType(), (JRSortField)jrField);
            }
        } else if (id.equals("order")) {
            jrField.setOrder(orderD.getEnumValue(value));
        } else if (id.equals("type")) {
            SortFieldTypeEnum type = typeD.getEnumValue(value);
            this.selectFirstAvailableName(type);
        }
    }

    public static JRDesignSortField createJRSortField(JRDesignDataset jrDataset) {
        JRDesignSortField jrDesignField = new JRDesignSortField();
        return jrDesignField;
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MSortFields) {
            return ICopyable.RESULT.COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

