/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import org.eclipse.gef.commands.Command;

public class ChangeSortFieldNameCommand
extends Command {
    private MSortField oldFieldModel;
    private JRDesignDataset jrDataSet;
    private String oldName;
    private String newName;

    public ChangeSortFieldNameCommand(MSortFields destNode, MSortField srcNode, String newName) {
        this.jrDataSet = (JRDesignDataset)destNode.getValue();
        this.oldFieldModel = srcNode;
        this.newName = newName;
    }

    private String getSortFieldKey(JRSortField sortField) {
        return String.valueOf(sortField.getName()) + "|" + sortField.getType().getName();
    }

    public void execute() {
        if (this.oldFieldModel.getValue() != null) {
            JRDesignSortField sortField = (JRDesignSortField)this.oldFieldModel.getValue();
            this.oldName = sortField.getName();
            if (this.oldName.equals(this.newName)) {
                return;
            }
            this.jrDataSet.getSortFieldsMap().remove(this.getSortFieldKey((JRSortField)sortField));
            sortField.setName(this.newName);
            this.jrDataSet.getSortFieldsMap().put(this.getSortFieldKey((JRSortField)sortField), sortField);
        }
    }

    public boolean canUndo() {
        return this.oldName != null;
    }

    public void undo() {
        JRDesignSortField sortField = (JRDesignSortField)this.oldFieldModel.getValue();
        if (this.oldName.equals(this.newName)) {
            return;
        }
        this.jrDataSet.getSortFieldsMap().remove(this.getSortFieldKey((JRSortField)sortField));
        sortField.setName(this.oldName);
        this.jrDataSet.getSortFieldsMap().put(this.getSortFieldKey((JRSortField)sortField), sortField);
        this.oldName = null;
    }
}

