/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command;

import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import org.eclipse.gef.commands.Command;

public class DeleteSortFieldCommand
extends Command {
    private JRDesignDataset jrDataset;
    private JRSortField jrField;
    private int elementPosition = 0;

    public DeleteSortFieldCommand(MSortFields destNode, MSortField srcNode) {
        this.jrDataset = (JRDesignDataset)destNode.getValue();
        this.jrField = (JRDesignSortField)srcNode.getValue();
    }

    public DeleteSortFieldCommand(JRDesignDataset destNode, JRSortField srcNode) {
        this.jrDataset = destNode;
        this.jrField = srcNode;
    }

    public void execute() {
        this.elementPosition = this.jrDataset.getSortFieldsList().indexOf(this.jrField);
        this.jrDataset.removeSortField(this.jrField);
    }

    public boolean canUndo() {
        return this.jrDataset != null && this.jrField != null;
    }

    public void undo() {
        try {
            if (this.elementPosition < 0 || this.elementPosition > this.jrDataset.getSortFieldsList().size()) {
                this.jrDataset.addSortField(this.jrField);
            } else {
                this.jrDataset.addSortField(this.elementPosition, this.jrField);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

