/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.sortfield.command.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.TLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class WizardSortFieldPage
extends WizardPage {
    private SHOW_TYPE showType = SHOW_TYPE.BOTH;
    private JRDesignDataset jrDataset;
    private JRDesignSortField jrSortfield;
    private TableViewer tableView;
    private Table table;

    public WizardSortFieldPage(JRDesignDataset jrDataset, JRDesignSortField jrSortField, SHOW_TYPE showType) {
        this(jrDataset, jrSortField);
        this.showType = showType;
    }

    public WizardSortFieldPage(JRDesignDataset jrDataset, JRDesignSortField jrSortField) {
        super("sortfieldpage");
        this.jrDataset = jrDataset;
        this.jrSortfield = jrSortField;
        this.setTitle(Messages.WizardSortFieldPage_Title);
        this.setDescription(Messages.WizardSortFieldPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.table = new Table(composite, 68100);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.table, 0)};
        col[0].setText(Messages.WizardSortFieldPage_Col1);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.table.setLayout((Layout)tlayout);
        this.tableView = new TableViewer(this.table);
        this.tableView.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableView.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.fillTable();
        SFSelectionListener listener = new SFSelectionListener();
        this.table.addSelectionListener((SelectionListener)listener);
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            listener.widgetSelected(null);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "Jaspersoft.wizard");
    }

    private void fillTable() {
        JRSortField checkIfPresent;
        ArrayList<JRField> objects = new ArrayList<JRField>();
        Map sortFields = this.jrDataset.getSortFieldsMap();
        if (this.showType == SHOW_TYPE.BOTH || this.showType == SHOW_TYPE.FIELDS) {
            for (JRField f : this.jrDataset.getFieldsList()) {
                checkIfPresent = (JRSortField)sortFields.get(String.valueOf(f.getName()) + "|" + SortFieldTypeEnum.FIELD.getName());
                if (checkIfPresent != null) continue;
                objects.add(f);
            }
        }
        if (this.showType == SHOW_TYPE.BOTH || this.showType == SHOW_TYPE.VARIABLES) {
            for (JRField f : this.jrDataset.getVariablesList()) {
                checkIfPresent = (JRSortField)sortFields.get(String.valueOf(f.getName()) + "|" + SortFieldTypeEnum.VARIABLE.getName());
                if (checkIfPresent != null) continue;
                objects.add(f);
            }
        }
        this.setPageComplete(!objects.isEmpty());
        this.tableView.setInput(objects);
    }

    private final class SFSelectionListener
    implements SelectionListener {
        private SFSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection sel = (IStructuredSelection)WizardSortFieldPage.this.tableView.getSelection();
            Object obj = sel.getFirstElement();
            if (obj instanceof JRField) {
                WizardSortFieldPage.this.jrSortfield.setName(((JRField)obj).getName());
                WizardSortFieldPage.this.jrSortfield.setType(SortFieldTypeEnum.FIELD);
            } else if (obj instanceof JRVariable) {
                WizardSortFieldPage.this.jrSortfield.setName(((JRVariable)obj).getName());
                WizardSortFieldPage.this.jrSortfield.setType(SortFieldTypeEnum.VARIABLE);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public static enum SHOW_TYPE {
        VARIABLES,
        FIELDS,
        BOTH;

    }
}

