/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MLinePen;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MNotConditionalMarker;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.model.style.StyleNameValidator;
import com.jaspersoft.studio.model.text.MParagraph;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptor.JRPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.box.BoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.FontNamePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.FontSizeButtonPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWFontSizePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWStyleComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.pattern.PatternPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.pen.PenPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.ImageHAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.ImageVAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.RotationPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TextHAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TextVAlignPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPBooleanToggle;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MStyle
extends APropertyNode
implements ICopyable,
IPastable,
IContainerEditPart,
IDragable,
MNotConditionalMarker {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static StyleNameValidator validator;
    private static RWComboBoxPropertyDescriptor styleD;
    private static NamedEnumPropertyDescriptor<FillEnum> fillD;
    private static NamedEnumPropertyDescriptor<ScaleImageEnum> scaleD;
    private static TextHAlignPropertyDescriptor halignText;
    private static TextVAlignPropertyDescriptor valignText;
    private static ImageHAlignPropertyDescriptor halignImage;
    private static ImageVAlignPropertyDescriptor valignImage;
    private static RotationPropertyDescriptor rotationD;
    private static final String LINE_PEN = "LinePen";
    private static final String LINE_BOX = "LineBox";
    public static final String PARAGRAPH = "paragraph";
    private MLinePen linePen;
    private MLineBox lineBox;
    private MParagraph mParagraph;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("style");
        }
        return iconDescriptor;
    }

    public MStyle() {
    }

    public MStyle(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MStyle(ANode parent, JRDesignStyle jrstyle, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrstyle);
    }

    @Override
    public String getDisplayText() {
        return this.getValue().getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MStyle.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MStyle.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateNameValidator();
    }

    protected void updateNameValidator() {
        if (validator == null) {
            validator = new StyleNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getValue() == null) {
            return result;
        }
        JRStyle element = this.getValue();
        result.put("backcolor", element.getOwnBackcolor());
        result.put("forecolor", element.getOwnForecolor());
        result.put("fill", element.getOwnFillValue());
        result.put("fontName", element.getOwnFontName());
        result.put("fontSize", element.getOwnFontsize());
        result.put("isBold", element.isOwnBold());
        result.put("isItalic", element.isOwnItalic());
        result.put("isUnderline", element.isOwnUnderline());
        result.put("isStrikeThrough", element.isOwnStrikeThrough());
        result.put("horizontalImageAlignment", element.getOwnHorizontalImageAlign());
        result.put("horizontalTextAlignment", element.getOwnHorizontalTextAlign());
        result.put("markup", element.getOwnMarkup());
        result.put("mode", element.getOwnModeValue());
        result.put("pattern", element.getOwnPattern());
        result.put("radius", element.getOwnRadius());
        result.put("rotation", element.getOwnRotationValue());
        result.put("scaleImage", element.getOwnScaleImageValue());
        result.put("verticalTextAlignment", element.getOwnVerticalTextAlign());
        result.put("verticalImageAlignment", element.getOwnVerticalImageAlign());
        result.put("isBlankWhenNull", element.isOwnBlankWhenNull());
        result.put("pdfFontName", element.getOwnPdfFontName());
        result.put("pdfEncoding", element.getOwnPdfEncoding());
        result.put("isPdfEmbedded", element.isOwnPdfEmbedded());
        result.put(PARAGRAPH, this.getPropertyValue(PARAGRAPH));
        MLinePen linePen = (MLinePen)this.getPropertyValue(LINE_PEN);
        result.put(LINE_PEN, linePen);
        MLineBox lineBox = (MLineBox)this.getPropertyValue(LINE_BOX);
        result.put(LINE_BOX, lineBox);
        return result;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateNameValidator();
        styleD = new RWStyleComboBoxPropertyDescriptor("parentStyle", Messages.common_parent_style, new String[]{""}, NullEnum.NULL);
        styleD.setDescription(Messages.MStyle_parent_style_description);
        styleD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#reportElement_style"));
        desc.add((IPropertyDescriptor)styleD);
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MStyle_name_description);
        desc.add((IPropertyDescriptor)nameD);
        PenPropertyDescriptor linePenD = new PenPropertyDescriptor(LINE_PEN, Messages.common_line_pen);
        linePenD.setDescription(Messages.MStyle_line_pen_description);
        desc.add((IPropertyDescriptor)linePenD);
        BoxPropertyDescriptor lineBoxD = new BoxPropertyDescriptor(LINE_BOX, Messages.common_line_box);
        lineBoxD.setDescription(Messages.MStyle_line_box_description);
        desc.add((IPropertyDescriptor)lineBoxD);
        lineBoxD.setCategory(Messages.common_graphic);
        ColorPropertyDescriptor forecolorD = new ColorPropertyDescriptor("forecolor", Messages.common_forecolor, NullEnum.INHERITED);
        forecolorD.setDescription(Messages.MStyle_forecolor_description);
        desc.add((IPropertyDescriptor)forecolorD);
        ColorPropertyDescriptor backcolorD = new ColorPropertyDescriptor("backcolor", Messages.common_backcolor, NullEnum.INHERITED);
        backcolorD.setDescription(Messages.MStyle_backcolor_description);
        desc.add((IPropertyDescriptor)backcolorD);
        IntegerPropertyDescriptor radiusD = new IntegerPropertyDescriptor("radius", Messages.common_radius);
        radiusD.setDescription(Messages.MStyle_radius_description);
        desc.add((IPropertyDescriptor)radiusD);
        fillD = new NamedEnumPropertyDescriptor<FillEnum>("fill", Messages.common_fill, FillEnum.SOLID, NullEnum.UNDEFINED);
        fillD.setDescription(Messages.MStyle_fill_description);
        desc.add((IPropertyDescriptor)fillD);
        scaleD = new NamedEnumPropertyDescriptor<ScaleImageEnum>("scaleImage", Messages.MStyle_scale, ScaleImageEnum.CLIP, NullEnum.UNDEFINED);
        scaleD.setDescription(Messages.MStyle_scale_description);
        desc.add((IPropertyDescriptor)scaleD);
        halignText = new TextHAlignPropertyDescriptor("horizontalTextAlignment", Messages.MStyle_textHorizontal, NullEnum.INHERITED);
        halignText.setDescription(Messages.MStyle_horizontal_alignment_description);
        desc.add((IPropertyDescriptor)halignText);
        valignText = new TextVAlignPropertyDescriptor("verticalTextAlignment", Messages.MStyle_textVertical, NullEnum.INHERITED);
        valignText.setDescription(Messages.MStyle_vertical_alignment_description);
        desc.add((IPropertyDescriptor)valignText);
        halignImage = new ImageHAlignPropertyDescriptor("horizontalImageAlignment", Messages.MStyle_imageHorizontal, NullEnum.INHERITED);
        halignImage.setDescription(Messages.MStyle_horizontal_alignment_description);
        desc.add((IPropertyDescriptor)halignImage);
        valignImage = new ImageVAlignPropertyDescriptor("verticalImageAlignment", Messages.MStyle_imageVertical, NullEnum.INHERITED);
        valignImage.setDescription(Messages.MStyle_vertical_alignment_description);
        desc.add((IPropertyDescriptor)valignImage);
        rotationD = new RotationPropertyDescriptor("rotation", Messages.common_rotation, NullEnum.INHERITED);
        rotationD.setDescription(Messages.MStyle_rotation_description);
        desc.add((IPropertyDescriptor)rotationD);
        CheckBoxPropertyDescriptor opaqueDBool = new CheckBoxPropertyDescriptor("mode", Messages.common_opaque);
        opaqueDBool.setDescription(Messages.MGraphicElement_opaque_description);
        desc.add((IPropertyDescriptor)opaqueDBool);
        CheckBoxPropertyDescriptor blankWhenNullD = new CheckBoxPropertyDescriptor("isBlankWhenNull", Messages.common_blank_when_null, NullEnum.INHERITED);
        blankWhenNullD.setDescription(Messages.MStyle_blank_when_null_description);
        desc.add((IPropertyDescriptor)blankWhenNullD);
        CheckBoxPropertyDescriptor boldD = new CheckBoxPropertyDescriptor("isBold", Messages.common_bold, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/bold.png"));
            }
        };
        boldD.setDescription(Messages.MFont_bold_description);
        desc.add((IPropertyDescriptor)boldD);
        CheckBoxPropertyDescriptor italicD = new CheckBoxPropertyDescriptor("isItalic", Messages.common_italic, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/italic.png"));
            }
        };
        italicD.setDescription(Messages.MFont_italic_description);
        desc.add((IPropertyDescriptor)italicD);
        CheckBoxPropertyDescriptor underlineD = new CheckBoxPropertyDescriptor("isUnderline", Messages.common_underline, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/underline.png"));
            }
        };
        underlineD.setDescription(Messages.MFont_underline_description);
        desc.add((IPropertyDescriptor)underlineD);
        CheckBoxPropertyDescriptor strikeThroughD = new CheckBoxPropertyDescriptor("isStrikeThrough", Messages.common_strike_trough, NullEnum.INHERITED){

            @Override
            public ASPropertyWidget<CheckBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                return new SPBooleanToggle(parent, section, this, JaspersoftStudioPlugin.getInstance().getImage("icons/resources/strikethrought.png"));
            }
        };
        strikeThroughD.setDescription(Messages.MFont_strike_trough_description);
        desc.add((IPropertyDescriptor)strikeThroughD);
        CheckBoxPropertyDescriptor defaultD = new CheckBoxPropertyDescriptor("isDefault", Messages.MStyle_default_style, NullEnum.NOTNULL);
        defaultD.setDescription(Messages.MStyle_default_style_description);
        desc.add((IPropertyDescriptor)defaultD);
        RWComboBoxPropertyDescriptor markupD = new RWComboBoxPropertyDescriptor("markup", Messages.MStyle_markup, ModelUtils.getMarkups(this.getJasperConfiguration()), NullEnum.INHERITED);
        markupD.setDescription(Messages.MStyle_markup_description);
        desc.add((IPropertyDescriptor)markupD);
        FontNamePropertyDescriptor fontNameD = new FontNamePropertyDescriptor("fontName", Messages.common_font_name, this.getJasperConfiguration().getFontList(), NullEnum.INHERITED);
        fontNameD.setDescription(Messages.MStyle_font_name_description);
        desc.add((IPropertyDescriptor)fontNameD);
        RWFontSizePropertyDescriptor fontSizeD = new RWFontSizePropertyDescriptor("fontSize", Messages.common_font_size, ModelUtils.FONT_SIZES, NullEnum.INHERITED);
        fontSizeD.setDescription(Messages.MStyle_font_size_description);
        desc.add((IPropertyDescriptor)fontSizeD);
        FontSizeButtonPropertyDescriptor fontIncrement = new FontSizeButtonPropertyDescriptor("FONT_INCREMENT", this);
        desc.add((IPropertyDescriptor)fontIncrement);
        PatternPropertyDescriptor patternD = new PatternPropertyDescriptor("pattern", Messages.common_pattern);
        patternD.setDescription(Messages.MStyle_pattern_description);
        desc.add((IPropertyDescriptor)patternD);
        JRPropertyDescriptor paragraph = new JRPropertyDescriptor(PARAGRAPH, "Paragraph");
        desc.add((IPropertyDescriptor)paragraph);
        RWComboBoxPropertyDescriptor pdfFontNameD = new RWComboBoxPropertyDescriptor("pdfFontName", Messages.MFont_pdf_font_name, ModelUtils.getPDFFontNames(), NullEnum.INHERITED);
        pdfFontNameD.setDescription(Messages.MFont_pdf_font_name_description);
        pdfFontNameD.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfFontNameD);
        RWComboBoxPropertyDescriptor pdfEncodingD = new RWComboBoxPropertyDescriptor("pdfEncoding", Messages.MFont_pdf_encoding, ModelUtils.getPDFEncodings(), NullEnum.INHERITED);
        pdfEncodingD.setDescription(Messages.MFont_pdf_encoding_description);
        pdfEncodingD.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfEncodingD);
        CheckBoxPropertyDescriptor pdfEmbedded = new CheckBoxPropertyDescriptor("isPdfEmbedded", Messages.MFont_pdf_embedded);
        pdfEmbedded.setDescription(Messages.MFont_pdf_embedded_description);
        pdfEmbedded.setCategory(Messages.MFont_pdfCategory);
        desc.add((IPropertyDescriptor)pdfEmbedded);
        paragraph.setCategory(Messages.common_text);
        styleD.setCategory(Messages.MStyle_Style_properties);
        nameD.setCategory(Messages.MStyle_Style_properties);
        defaultD.setCategory(Messages.MStyle_Style_properties);
        forecolorD.setCategory(Messages.MStyle_common_category);
        backcolorD.setCategory(Messages.MStyle_common_category);
        opaqueDBool.setCategory(Messages.MStyle_common_category);
        linePenD.setCategory(Messages.common_graphic);
        radiusD.setCategory(Messages.common_graphic);
        scaleD.setCategory(Messages.common_graphic);
        fillD.setCategory(Messages.common_graphic);
        patternD.setCategory(Messages.common_text);
        blankWhenNullD.setCategory(Messages.common_text);
        rotationD.setCategory(Messages.common_text);
        markupD.setCategory(Messages.common_text);
        halignText.setCategory(Messages.common_text);
        valignText.setCategory(Messages.common_text);
        halignImage.setCategory(Messages.common_text);
        valignImage.setCategory(Messages.common_text);
        fontNameD.setCategory(Messages.MStyle_text_font_category);
        fontSizeD.setCategory(Messages.MStyle_text_font_category);
        boldD.setCategory(Messages.MStyle_text_font_category);
        italicD.setCategory(Messages.MStyle_text_font_category);
        underlineD.setCategory(Messages.MStyle_text_font_category);
        strikeThroughD.setCategory(Messages.MStyle_text_font_category);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#style");
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("forecolor", new DefaultValue(null, true));
        defaultsMap.put("backcolor", new DefaultValue(null, true));
        defaultsMap.put("fill", new DefaultValue(null, true));
        defaultsMap.put("scaleImage", new DefaultValue(null, true));
        defaultsMap.put("horizontalTextAlignment", new DefaultValue(null, true));
        defaultsMap.put("verticalTextAlignment", new DefaultValue(null, true));
        defaultsMap.put("horizontalImageAlignment", new DefaultValue(null, true));
        defaultsMap.put("verticalImageAlignment", new DefaultValue(null, true));
        defaultsMap.put("rotation", new DefaultValue(null, true));
        defaultsMap.put("isBlankWhenNull", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("isStrikeThrough", new DefaultValue(null, true));
        defaultsMap.put("isUnderline", new DefaultValue(null, true));
        defaultsMap.put("isItalic", new DefaultValue(null, true));
        defaultsMap.put("isBold", new DefaultValue(null, true));
        defaultsMap.put("fontName", new DefaultValue("SansSerif", true));
        defaultsMap.put("fontSize", new DefaultValue(Float.valueOf(10.0f), true));
        int modeValue = NamedEnumPropertyDescriptor.getIntValue(ModeEnum.OPAQUE, NullEnum.NOTNULL, ModeEnum.OPAQUE);
        defaultsMap.put("mode", new DefaultValue(modeValue, true));
        return defaultsMap;
    }

    public JRStyle getActualStyle() {
        JRBaseStyle jrElement = (JRBaseStyle)this.getValue();
        if (jrElement.getStyle() != null && !this.getJasperDesign().getStylesMap().containsKey(jrElement.getStyle().getName())) {
            return null;
        }
        if (jrElement.getStyle() != null) {
            return jrElement.getStyle();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        Object val;
        JRBaseStyle jrstyle;
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue() instanceof JRBaseStyle) {
            jrstyle = (JRBaseStyle)this.getValue();
            if (id.equals("name")) {
                return jrstyle.getName();
            }
            if (id.equals("isDefault")) {
                return new Boolean(jrstyle.isDefault());
            }
            if (id.equals("parentStyle")) {
                if (jrstyle.getStyleNameReference() != null) {
                    return jrstyle.getStyleNameReference();
                }
                JRStyle actualStyle = this.getActualStyle();
                return actualStyle != null ? actualStyle.getName() : "";
            }
            if (id.equals(PARAGRAPH)) {
                if (this.mParagraph == null) {
                    this.mParagraph = new MParagraph((ANode)this, (JRBaseParagraph)jrstyle.getParagraph());
                    this.setChildListener(this.mParagraph);
                }
                return this.mParagraph;
            }
        }
        jrstyle = (JRBaseStyle)this.getValue();
        if (id.equals(LINE_PEN)) {
            if (this.linePen == null) {
                this.linePen = new MLinePen(jrstyle.getLinePen());
                this.linePen.setJasperConfiguration(this.getJasperConfiguration());
                this.setChildListener(this.linePen);
            }
            return this.linePen;
        }
        if (id.equals(LINE_BOX)) {
            if (this.lineBox == null) {
                this.lineBox = new MLineBox(jrstyle.getLineBox(), this);
                this.setChildListener(this.lineBox);
            }
            return this.lineBox;
        }
        if (id.equals("pattern")) {
            return jrstyle.getOwnPattern();
        }
        if (id.equals("radius")) {
            return jrstyle.getOwnRadius();
        }
        if (id.equals("markup")) {
            return jrstyle.getOwnMarkup();
        }
        if (id.equals("forecolor")) {
            return Colors.getSWTRGB4AWTGBColor(jrstyle.getOwnForecolor());
        }
        if (id.equals("backcolor")) {
            return Colors.getSWTRGB4AWTGBColor(jrstyle.getOwnBackcolor());
        }
        if (id.equals("fill")) {
            if (jrstyle.getOwnFillValue() == null) {
                return null;
            }
            return fillD.getIntValue(jrstyle.getOwnFillValue());
        }
        if (id.equals("scaleImage")) {
            if (jrstyle.getOwnScaleImageValue() == null) {
                return null;
            }
            return scaleD.getIntValue(jrstyle.getOwnScaleImageValue());
        }
        if (id.equals("horizontalTextAlignment")) {
            if (jrstyle.getOwnHorizontalTextAlign() == null) {
                return null;
            }
            return halignText.getIntValue(jrstyle.getOwnHorizontalTextAlign());
        }
        if (id.equals("verticalTextAlignment")) {
            if (jrstyle.getOwnVerticalTextAlign() == null) {
                return null;
            }
            return valignText.getIntValue(jrstyle.getOwnVerticalTextAlign());
        }
        if (id.equals("horizontalImageAlignment")) {
            if (jrstyle.getOwnHorizontalImageAlign() == null) {
                return null;
            }
            return halignImage.getIntValue(jrstyle.getOwnHorizontalImageAlign());
        }
        if (id.equals("verticalImageAlignment")) {
            if (jrstyle.getOwnVerticalImageAlign() == null) {
                return null;
            }
            return valignImage.getIntValue(jrstyle.getOwnVerticalImageAlign());
        }
        if (id.equals("rotation")) {
            if (jrstyle.getOwnRotationValue() == null) {
                return null;
            }
            return rotationD.getIntValue(jrstyle.getOwnRotationValue());
        }
        if (id.equals("mode")) {
            ModeEnum modeValue = jrstyle.getOwnModeValue();
            return modeValue != null ? Boolean.valueOf(modeValue.equals((Object)ModeEnum.TRANSPARENT)) : null;
        }
        if (id.equals("isBlankWhenNull")) {
            return jrstyle.isOwnBlankWhenNull();
        }
        if (id.equals("isStrikeThrough")) {
            return jrstyle.isOwnStrikeThrough();
        }
        if (id.equals("isUnderline")) {
            return jrstyle.isOwnUnderline();
        }
        if (id.equals("isItalic")) {
            return jrstyle.isOwnItalic();
        }
        if (id.equals("isBold")) {
            return jrstyle.isOwnBold();
        }
        if (id.equals("fontName")) {
            return jrstyle.getOwnFontName();
        }
        if (id.equals("fontSize")) {
            return jrstyle.getOwnFontsize();
        }
        if (id.equals("pdfFontName")) {
            return jrstyle.getOwnPdfFontName();
        }
        if (id.equals("pdfEncoding")) {
            return jrstyle.getOwnPdfEncoding();
        }
        if (id.equals("isPdfEmbedded")) {
            return jrstyle.isOwnPdfEmbedded();
        }
        if (this.lineBox != null && (val = this.lineBox.getPropertyValue(id)) != null) {
            return val;
        }
        if (this.linePen != null && (val = this.linePen.getPropertyValue(id)) != null) {
            return val;
        }
        return null;
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        Object val;
        if (this.getValue() == null) {
            return null;
        }
        JSSStyleResolver resolver = this.getStyleResolver();
        JRBaseStyle jrstyle = (JRBaseStyle)this.getValue();
        if (id.equals("pattern")) {
            return resolver.getPattern((JRStyle)jrstyle);
        }
        if (id.equals("radius")) {
            return resolver.getRadius((JRStyle)jrstyle);
        }
        if (id.equals("markup")) {
            return resolver.getMarkup((JRStyle)jrstyle);
        }
        if (id.equals("forecolor")) {
            Color color = resolver.getForecolor((JRStyle)jrstyle);
            return Colors.getSWTRGB4AWTGBColor(color);
        }
        if (id.equals("backcolor")) {
            Color color = resolver.getBackcolor((JRStyle)jrstyle);
            return Colors.getSWTRGB4AWTGBColor(color);
        }
        if (id.equals("fill")) {
            FillEnum fillValue = resolver.getFillValue((JRStyle)jrstyle);
            return fillD.getIntValue(fillValue);
        }
        if (id.equals("scaleImage")) {
            ScaleImageEnum imageValue = resolver.getScaleImageValue((JRStyle)jrstyle);
            return scaleD.getIntValue(imageValue);
        }
        if (id.equals("horizontalTextAlignment")) {
            HorizontalTextAlignEnum textAlignValue = resolver.getHorizontalTextAlign((JRStyle)jrstyle);
            return halignText.getIntValue(textAlignValue);
        }
        if (id.equals("verticalTextAlignment")) {
            VerticalTextAlignEnum textAlignValue = resolver.getVerticalTextAlign((JRStyle)jrstyle);
            return valignText.getIntValue(textAlignValue);
        }
        if (id.equals("horizontalImageAlignment")) {
            HorizontalImageAlignEnum imageAlignValue = resolver.getHorizontalImageAlign((JRStyle)jrstyle);
            return halignImage.getIntValue(imageAlignValue);
        }
        if (id.equals("verticalImageAlignment")) {
            VerticalImageAlignEnum imageAlignValue = resolver.getVerticalImageAlign((JRStyle)jrstyle);
            return valignImage.getIntValue(imageAlignValue);
        }
        if (id.equals("rotation")) {
            RotationEnum rotationValue = resolver.getRotationValue((JRStyle)jrstyle);
            return rotationD.getIntValue(rotationValue);
        }
        if (id.equals("mode")) {
            ModeEnum modeValue = resolver.getModeValue((JRStyle)jrstyle);
            return modeValue == null ? true : ModeEnum.TRANSPARENT == modeValue;
        }
        if (id.equals("isBlankWhenNull")) {
            return resolver.isBlankWhenNull((JRStyle)jrstyle);
        }
        if (id.equals("isStrikeThrough")) {
            return resolver.isStrikeThrough((JRStyle)jrstyle);
        }
        if (id.equals("isUnderline")) {
            return resolver.isUnderline((JRStyle)jrstyle);
        }
        if (id.equals("isItalic")) {
            return resolver.isItalic((JRStyle)jrstyle);
        }
        if (id.equals("isBold")) {
            return resolver.isBold((JRStyle)jrstyle);
        }
        if (id.equals("fontName")) {
            return resolver.getFontName((JRStyle)jrstyle);
        }
        if (id.equals("fontSize")) {
            return resolver.getFontsize((JRStyle)jrstyle);
        }
        if (id.equals("pdfFontName")) {
            return resolver.getPdfFontName((JRStyle)jrstyle);
        }
        if (id.equals("pdfEncoding")) {
            return resolver.getPdfEncoding((JRStyle)jrstyle);
        }
        if (id.equals("isPdfEmbedded")) {
            return resolver.isPdfEmbedded((JRStyle)jrstyle);
        }
        if (this.lineBox != null && (val = this.lineBox.getPropertyActualValue(id)) != null) {
            return val;
        }
        if (this.linePen != null && (val = this.linePen.getPropertyActualValue(id)) != null) {
            return val;
        }
        return super.getPropertyActualValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignStyle jrstyle;
        if (!this.isEditable()) {
            return;
        }
        if (this.getValue() instanceof JRDesignStyle) {
            jrstyle = (JRDesignStyle)this.getValue();
            if (id.equals("name")) {
                jrstyle.setName((String)value);
            } else if (id.equals("isDefault")) {
                jrstyle.setDefault(((Boolean)value).booleanValue());
            } else if (id.equals("parentStyle")) {
                if (!Misc.isNullOrEmpty((String)((String)value))) {
                    JRStyle style = (JRStyle)this.getJasperDesign().getStylesMap().get(value);
                    if (style != null) {
                        jrstyle.setParentStyleNameReference(null);
                        jrstyle.setParentStyle(style);
                    } else {
                        jrstyle.setParentStyleNameReference((String)value);
                        this.fixExternalStyleReference((String)value);
                    }
                } else {
                    jrstyle.setParentStyleNameReference(null);
                    jrstyle.setParentStyle(null);
                }
            }
        }
        jrstyle = (JRBaseStyle)this.getValue();
        if (id.equals("pattern")) {
            jrstyle.setPattern((String)value);
        } else if (id.equals("radius")) {
            jrstyle.setRadius((Integer)value);
        } else if (id.equals("markup")) {
            jrstyle.setMarkup((String)value);
        } else if (id.equals("forecolor")) {
            jrstyle.setForecolor(Colors.getAWT4SWTRGBColor((AlfaRGB)value));
        } else if (id.equals("backcolor")) {
            jrstyle.setBackcolor(Colors.getAWT4SWTRGBColor((AlfaRGB)value));
        } else if (id.equals("fill")) {
            jrstyle.setFill(fillD.getEnumValue(value));
        } else if (id.equals("scaleImage")) {
            jrstyle.setScaleImage(scaleD.getEnumValue(value));
        } else if (id.equals("horizontalTextAlignment")) {
            jrstyle.setHorizontalTextAlign((HorizontalTextAlignEnum)halignText.getEnumValue(value));
        } else if (id.equals("verticalTextAlignment")) {
            jrstyle.setVerticalTextAlign((VerticalTextAlignEnum)valignText.getEnumValue(value));
        } else if (id.equals("horizontalImageAlignment")) {
            jrstyle.setHorizontalImageAlign((HorizontalImageAlignEnum)halignImage.getEnumValue(value));
        } else if (id.equals("verticalImageAlignment")) {
            jrstyle.setVerticalImageAlign((VerticalImageAlignEnum)valignImage.getEnumValue(value));
        } else if (id.equals("rotation")) {
            jrstyle.setRotation((RotationEnum)rotationD.getEnumValue(value));
        } else if (id.equals("mode")) {
            if (value == null) {
                jrstyle.setMode(null);
            } else if (((Boolean)value).booleanValue()) {
                jrstyle.setMode(ModeEnum.TRANSPARENT);
            } else {
                jrstyle.setMode(ModeEnum.OPAQUE);
            }
        } else if (id.equals("isBlankWhenNull")) {
            jrstyle.setBlankWhenNull((Boolean)value);
        } else if (id.equals("isStrikeThrough")) {
            jrstyle.setStrikeThrough((Boolean)value);
        } else if (id.equals("isUnderline")) {
            jrstyle.setUnderline((Boolean)value);
        } else if (id.equals("isItalic")) {
            jrstyle.setItalic((Boolean)value);
        } else if (id.equals("isBold")) {
            jrstyle.setBold((Boolean)value);
        } else if (id.equals("fontName")) {
            jrstyle.setFontName((String)value);
        } else if (id.equals("fontSize")) {
            jrstyle.setFontSize((Float)value);
        } else if (id.equals("pdfFontName")) {
            jrstyle.setPdfFontName((String)value);
        } else if (id.equals("pdfEncoding")) {
            jrstyle.setPdfEncoding((String)value);
        } else if (id.equals("isPdfEmbedded")) {
            jrstyle.setPdfEmbedded((Boolean)value);
        } else if (this.lineBox != null) {
            this.lineBox.setPropertyValue(id, value);
        }
        if (this.linePen != null) {
            this.linePen.setPropertyValue(id, value);
        }
    }

    protected void fixExternalStyleReference(String externalStyleName) {
        if (externalStyleName != null) {
            JRDesignStyle jrstyle = (JRDesignStyle)this.getValue();
            jrstyle.setParentStyle(ExternalStylesManager.getExternalStyle(externalStyleName, this.getJasperConfiguration()));
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.fixExternalStyleReference(((JRBaseStyle)value).getStyleNameReference());
    }

    public static JRDesignStyle createJRStyle(JasperDesign jrDesign) {
        JRDesignStyle jrDesignStyle = new JRDesignStyle((JRDefaultStyleProvider)jrDesign);
        jrDesignStyle.setName(ModelUtils.getDefaultName(jrDesign.getStylesMap(), "Style"));
        return jrDesignStyle;
    }

    private void setStyleRefresh(INode node, boolean force) {
        if (force || this.getValue().isDefault()) {
            if (node instanceof IGraphicalPropertiesHandler) {
                IGraphicalPropertiesHandler graphicalElement = (IGraphicalPropertiesHandler)((Object)node);
                graphicalElement.setChangedProperty(true);
                ((ANode)node).revalidateChildren();
            }
            for (INode child : node.getChildren()) {
                this.setStyleRefresh(child, force);
            }
        } else {
            Map<String, List<ANode>> nodesUsingStyle = ((ANode)node).getUsedStyles();
            List<ANode> nodes = nodesUsingStyle.get(this.getValue().getName());
            if (nodes == null) {
                return;
            }
            for (ANode aNode : nodes) {
                if (!aNode.getUsedStyles().containsKey(this.getValue().getName()) || !(aNode instanceof IGraphicalPropertiesHandler)) continue;
                IGraphicalPropertiesHandler graphicalElement = (IGraphicalPropertiesHandler)((Object)aNode);
                graphicalElement.setStyleChangedProperty();
                aNode.revalidateChildren();
            }
        }
    }

    protected boolean isDependencyStyle() {
        ANode stylesRoot = this.getStylesRoot();
        if (stylesRoot != null) {
            String styleName = this.getValue().getName();
            return this.searchStyleDependency(stylesRoot, styleName);
        }
        return false;
    }

    protected boolean searchStyleDependency(ANode parent, String name) {
        for (INode child : parent.getChildren()) {
            if (!(child instanceof MStyle)) continue;
            MStyle style = (MStyle)child;
            JRStyle jrStyle = style.getValue().getStyle();
            if (jrStyle != null && jrStyle.getName().equals(name)) {
                return true;
            }
            this.searchStyleDependency(style, name);
        }
        return false;
    }

    protected ANode getStylesRoot() {
        ANode parent = this.getParent();
        while (parent != null && !(parent instanceof MStyles)) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Override
    public Map<String, List<ANode>> getUsedStyles() {
        Map<String, List<ANode>> result = super.getUsedStyles();
        JRStyle style = this.getValue().getStyle();
        this.addElementStyle(style, result);
        return result;
    }

    @Override
    public void setStyle(JRStyle style) {
        if (this.getValue() != null) {
            ((JRDesignStyle)this.getValue()).setParentStyle(style);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            JasperDesign design = this.getJasperDesign();
            JRBaseStyle jrstyle = (JRBaseStyle)this.getValue();
            if (design != null) {
                design.getStylesMap().remove(evt.getOldValue());
                design.getStylesMap().put(jrstyle.getName(), jrstyle);
            }
        } else if (evt.getPropertyName().equals("conditionalStyles") && evt.getSource() == this.getValue()) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                int newIndex = -1;
                if (evt instanceof CollectionElementAddedEvent) {
                    newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                }
                ReportFactory.createNode(this, evt.getNewValue(), newIndex);
            } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    this.removeChild((ANode)n);
                    break;
                }
            } else {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    n.setValue(evt.getNewValue());
                }
            }
        }
        evt = new PropertyChangeEvent(this.getValue(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        boolean isDependencyStyle = this.isDependencyStyle();
        this.fireUpdateForElements(evt.getPropertyName().equals("isDefault") || isDependencyStyle);
        super.propertyChange(evt);
    }

    public void fireUpdateForElements(final boolean force) {
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                INode root = MStyle.this.getRoot();
                if (root != null) {
                    MStyle.this.setStyleRefresh(root, force);
                    JSSCompoundCommand.forceRefreshVisuals(JSSCompoundCommand.getMainNode((ANode)root));
                }
            }
        };
        new Thread(notifier).start();
    }

    public JRStyle getValue() {
        return (JRStyle)super.getValue();
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        MLineBox lineBox = (MLineBox)this.getPropertyValue(LINE_BOX);
        lineBox.setEditable(editable);
        MLinePen linePen = (MLinePen)this.getPropertyValue(LINE_PEN);
        linePen.setEditable(editable);
        MParagraph paragraph = (MParagraph)this.getPropertyValue(PARAGRAPH);
        paragraph.setEditable(editable);
    }

    @Override
    public ICopyable.RESULT isCopyable2(Object parent) {
        if (parent instanceof MStyles) {
            return ICopyable.RESULT.COPYABLE;
        }
        if (parent instanceof MStylesTemplate) {
            MStylesTemplate template = (MStylesTemplate)parent;
            if (template.getParent() instanceof MRoot) {
                return ICopyable.RESULT.COPYABLE;
            }
            return ICopyable.RESULT.NOT_COPYABLE;
        }
        if (parent instanceof MConditionalStyle) {
            return ICopyable.RESULT.NOT_COPYABLE;
        }
        return ICopyable.RESULT.CHECK_PARENT;
    }

    @Override
    public boolean isCuttable(ISelection currentSelection) {
        return true;
    }
}

