/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.util.ReportFactory;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import org.eclipse.jface.resource.ImageDescriptor;

public class MStyles
extends ANode
implements IPastable,
IContainerEditPart {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("styles");
        }
        return iconDescriptor;
    }

    public MStyles(ANode parent) {
        this(parent, -1);
    }

    public MStyles(ANode parent, int index) {
        super(parent, index);
        this.setValue(this.getJasperDesign());
    }

    @Override
    public String getDisplayText() {
        return MStyles.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MStyles.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MStyles.getIconDescriptor().getToolTip();
    }

    private JRStyle getDefaultStyle(List<INode> children) {
        for (INode node : children) {
            JRStyle style;
            if (node instanceof MStyleTemplate) {
                JRStyle result = this.getDefaultStyle(node.getChildren());
                if (result == null) continue;
                return result;
            }
            if (!(node instanceof MStyle) || !(style = (JRStyle)node.getValue()).isDefault()) continue;
            return style;
        }
        return null;
    }

    public void updateDefaulStyle() {
        JRStyle newDefault;
        JRStyle oldDefault;
        JasperDesign jd = this.getJasperDesign();
        if (jd != null && (oldDefault = jd.getDefaultStyle()) != (newDefault = this.getDefaultStyle(this.getChildren()))) {
            if (oldDefault != null && jd.getStylesList().contains(oldDefault)) {
                ((JRDesignStyle)oldDefault).setDefault(false);
            } else {
                this.fireUpdateForElements();
            }
            jd.setDefaultStyle(newDefault);
        }
    }

    private void refreshAllElements(List<INode> childerns) {
        for (INode child : childerns) {
            if (child instanceof IGraphicalPropertiesHandler) {
                IGraphicalPropertiesHandler graphicalElement = (IGraphicalPropertiesHandler)((Object)child);
                graphicalElement.setChangedProperty(true);
            }
            this.refreshAllElements(new ArrayList<INode>(child.getChildren()));
        }
    }

    private void fireUpdateForElements() {
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                INode root = MStyles.this.getRoot();
                if (root != null) {
                    MStyles.this.refreshAllElements(new ArrayList<INode>(root.getChildren()));
                }
            }
        };
        new Thread(notifier).start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("templates") && evt.getSource() == this.getValue()) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                int newIndex = -1;
                if (evt instanceof CollectionElementAddedEvent) {
                    newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
                }
                if (evt.getNewValue() instanceof JRDesignReportTemplate) {
                    newIndex = 0;
                }
                ANode style = ReportFactory.createNode(this, evt.getNewValue(), newIndex);
                if (evt.getNewValue() instanceof JRDesignStyle) {
                    JRDesignStyle jrStyle = (JRDesignStyle)evt.getNewValue();
                    for (JRConditionalStyle it : jrStyle.getConditionalStyleList()) {
                        ReportFactory.createNode(style, it, -1);
                    }
                }
            } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    this.removeChild((ANode)n);
                    break;
                }
            } else {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    n.setValue(evt.getNewValue());
                }
            }
        }
        if (evt.getPropertyName().equals("isDefault") || evt.getPropertyName().equals("templates") || evt.getPropertyName().equals("styles")) {
            this.updateDefaulStyle();
        }
        if (!(evt.getPropertyName().equals("title") || evt.getPropertyName().equals("pageHeader") || evt.getPropertyName().equals("columnHeader") || evt.getPropertyName().equals("columnFooter") || evt.getPropertyName().equals("pageFooter") || evt.getPropertyName().equals("lastPageFooter") || evt.getPropertyName().equals("summary") || evt.getPropertyName().equals("noData") || evt.getPropertyName().equals("detail") || evt.getPropertyName().equals("background"))) {
            super.propertyChange(evt);
        }
    }
}

