/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.StyleTemplateFactory;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;

public class MStylesTemplate
extends ANode
implements IPastable,
IContainerEditPart {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private IFile file;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("styles");
        }
        return iconDescriptor;
    }

    public MStylesTemplate(ANode parent, IFile file) {
        super(parent, -1);
        this.setValue(this.getJasperDesign());
        this.file = file;
    }

    @Override
    public String getDisplayText() {
        return MStylesTemplate.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MStylesTemplate.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MStylesTemplate.getIconDescriptor().getToolTip();
    }

    protected void propertyAddEvent(PropertyChangeEvent evt) {
        int newIndex = -1;
        if (evt instanceof CollectionElementAddedEvent) {
            newIndex = ((CollectionElementAddedEvent)evt).getAddedIndex();
        }
        if (evt.getNewValue() instanceof JRDesignReportTemplate) {
            newIndex = 0;
            JasperDesign jd = this.getJasperDesign();
            if (jd != null) {
                jd.addTemplate((JRReportTemplate)((JRDesignReportTemplate)evt.getNewValue()));
            }
        } else if (evt.getNewValue() instanceof JRDesignStyle) {
            JasperDesign jd = this.getJasperDesign();
            if (jd != null) {
                try {
                    jd.addStyle((JRStyle)((JRDesignStyle)evt.getNewValue()));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        } else if (evt.getNewValue() instanceof JRTemplateReference) {
            JasperReportsConfiguration jConfig = this.getJasperConfiguration();
            JasperDesign jd = this.getJasperDesign();
            if (jd != null && jConfig != null) {
                JRTemplateReference externalNode = (JRTemplateReference)evt.getNewValue();
                JRDesignReportTemplate jrTemplate = MStyleTemplate.createJRTemplate();
                JRDesignExpression jre = new JRDesignExpression();
                jre.setText("\"" + StyleTemplateFactory.getStylePath(externalNode, jConfig) + "\"");
                jrTemplate.setSourceExpression((JRExpression)jre);
                jd.addTemplate((JRReportTemplate)jrTemplate);
            }
        }
        StyleTemplateFactory.createNode(this, evt.getNewValue(), newIndex, this.file, (JRSimpleTemplate)this.getValue());
    }

    protected void propertyRemoveEvent(PropertyChangeEvent evt) {
        JasperDesign jd;
        if (evt.getOldValue() instanceof JRDesignStyle) {
            jd = this.getJasperDesign();
            if (jd != null) {
                jd.removeStyle((JRStyle)((JRDesignStyle)evt.getOldValue()));
            }
        } else if (evt.getOldValue() instanceof JRDesignReportTemplate) {
            jd = this.getJasperDesign();
            if (jd != null) {
                jd.removeTemplate((JRReportTemplate)((JRDesignReportTemplate)evt.getOldValue()));
            }
        } else if (evt.getOldValue() instanceof JRTemplateReference) {
            JasperReportsConfiguration jConfig = this.getJasperConfiguration();
            JasperDesign jd2 = this.getJasperDesign();
            JRTemplateReference externalNode = (JRTemplateReference)evt.getOldValue();
            JRDesignExpression jre = new JRDesignExpression();
            jre.setText("\"" + StyleTemplateFactory.getStylePath(externalNode, jConfig) + "\"");
            if (jd2 != null && jConfig != null) {
                JRReportTemplate[] jRReportTemplateArray = jd2.getTemplates();
                int n = jRReportTemplateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JRReportTemplate template = jRReportTemplateArray[n2];
                    if (ExpressionUtil.ExpressionEquals((JRExpression)jre, template.getSourceExpression())) {
                        jd2.removeTemplate(template);
                        break;
                    }
                    ++n2;
                }
            }
        }
        for (INode n : this.getChildren()) {
            if (n.getValue() != evt.getOldValue()) continue;
            this.removeChild((ANode)n);
            break;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("style") || evt.getPropertyName().equals("incluldedTemplates") && evt.getSource() == this.getValue()) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                this.propertyAddEvent(evt);
            } else if (evt.getOldValue() != null && evt.getNewValue() == null) {
                this.propertyRemoveEvent(evt);
            } else {
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getOldValue()) continue;
                    n.setValue(evt.getNewValue());
                }
            }
        }
        super.propertyChange(evt);
    }
}

