/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;

public class CreateConditionalStyleCommand
extends Command {
    private JRConditionalStyle jrConditionalStyle;
    private JRDesignStyle jrStyle;
    private int index;

    public CreateConditionalStyleCommand(MStyle destNode, MConditionalStyle srcNode, int index) {
        this.index = index;
        this.jrStyle = (JRDesignStyle)destNode.getValue();
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrConditionalStyle = (JRConditionalStyle)srcNode.getValue();
        }
    }

    public CreateConditionalStyleCommand(MStyle destNode, JRConditionalStyle style) {
        this.index = -1;
        this.jrStyle = (JRDesignStyle)destNode.getValue();
        this.jrConditionalStyle = style;
    }

    public CreateConditionalStyleCommand(JRDesignStyle destNode, JRConditionalStyle style) {
        this.index = -1;
        this.jrStyle = destNode;
        this.jrConditionalStyle = style;
    }

    public void execute() {
        if (this.jrConditionalStyle == null) {
            this.jrConditionalStyle = MConditionalStyle.createJRStyle();
        }
        if (this.jrConditionalStyle != null) {
            if (this.index < 0 || this.index > this.jrStyle.getConditionalStyleList().size()) {
                this.jrStyle.addConditionalStyle(this.jrConditionalStyle);
            } else {
                this.jrStyle.addConditionalStyle(this.index, this.jrConditionalStyle);
            }
            SelectionHelper.setOutlineSelection(this.jrConditionalStyle);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrStyle.removeConditionalStyle(this.jrConditionalStyle);
    }
}

