/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

public class CreateStyleTemplateCommand
extends Command {
    private JRDesignReportTemplate jrTemplate;
    private JasperDesign jrDesign;
    private int index;

    public CreateStyleTemplateCommand(MStyles destNode, MStyleTemplate srcNode, int index) {
        this(destNode, (JRDesignReportTemplate)srcNode.getValue(), index);
    }

    public CreateStyleTemplateCommand(MStyles destNode, JRDesignReportTemplate srcNode, int index) {
        Assert.isNotNull((Object)srcNode);
        this.jrDesign = destNode.getJasperDesign();
        this.index = index;
        this.jrTemplate = srcNode;
    }

    public void execute() {
        if (this.jrTemplate != null) {
            if (this.index < 0 || this.index > this.jrDesign.getTemplatesList().size()) {
                this.jrDesign.addTemplate((JRReportTemplate)this.jrTemplate);
            } else {
                this.jrDesign.addTemplate(this.index, (JRReportTemplate)this.jrTemplate);
            }
            SelectionHelper.setOutlineSelection(this.jrTemplate);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDesign.removeTemplate((JRReportTemplate)this.jrTemplate);
    }
}

