/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.commands.Command;

public class ReorderConditionalStyleCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignConditionalStyle jrConditionalStyle;
    private JRDesignStyle jrStyle;

    public ReorderConditionalStyleCommand(MConditionalStyle child, MStyle parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrStyle = (JRDesignStyle)parent.getValue();
        this.jrConditionalStyle = (JRDesignConditionalStyle)child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrStyle.getConditionalStyleList().indexOf(this.jrConditionalStyle);
        this.jrStyle.removeConditionalStyle((JRConditionalStyle)this.jrConditionalStyle);
        if (this.newIndex < 0 || this.newIndex > this.jrStyle.getConditionalStyleList().size()) {
            this.jrStyle.addConditionalStyle((JRConditionalStyle)this.jrConditionalStyle);
        } else {
            this.jrStyle.addConditionalStyle(this.newIndex, (JRConditionalStyle)this.jrConditionalStyle);
        }
    }

    public void undo() {
        this.jrStyle.removeConditionalStyle((JRConditionalStyle)this.jrConditionalStyle);
        if (this.oldIndex < 0 || this.oldIndex > this.jrStyle.getConditionalStyleList().size()) {
            this.jrStyle.addConditionalStyle((JRConditionalStyle)this.jrConditionalStyle);
        } else {
            this.jrStyle.addConditionalStyle(this.oldIndex, (JRConditionalStyle)this.jrConditionalStyle);
        }
    }
}

